/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;

public class PathUtil {
    private PathUtil() {
    }

    public static void robustRename(File file, File file2) throws IOException {
        int n;
        int n2 = -1;
        boolean bl = file.exists();
        boolean bl2 = file2.exists();
        boolean bl3 = false;
        if (System.getProperty("os.name").startsWith("Windows")) {
            bl3 = true;
        }
        if (bl3) {
            for (n = 0; n < 100 && file2.exists(); ++n) {
                file2.delete();
            }
            n2 = n;
            if (file2.exists()) {
                throw new IOException("could not remove " + file2 + " before renaming " + file);
            }
        }
        n = bl3 ? 9 : 1;
        long l = 10L;
        int n3 = 0;
        boolean bl4 = false;
        for (int i = 0; i < n; ++i) {
            if (file.renameTo(file2)) {
                bl4 = true;
                break;
            }
            ++n3;
            if (i + 1 < n) {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("delay in robustRename was interrupted: " + interruptedException);
                }
            }
            l *= 2L;
        }
        if (n3 > 0) {
            String string = bl4 ? "PathUtil.robustRename(): File.renameTo() returned true after returning false " + n3 + " times\n" : "PathUtil.robustRename(): File.renameTo() returned false " + n3 + " times\n";
            string = string + "       source=\"" + file + "\": exists=" + bl + "\n";
            string = string + "  destination=\"" + file2 + "\": exists=" + bl2 + "\n";
            string = string + "  deleteTries = " + n2;
            Logger logger = Logger.getLogger("com.connecterra.util.PathUtil.robustRename");
            logger.finest(string);
        }
        if (!bl4) {
            throw new IOException("failed to rename " + file + " to " + file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[10240];
        try {
            int n;
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static String[] getPathComponents(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (file != null) {
            arrayList.add(0, file.getName());
            file = file.getParentFile();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String b(File file) {
        File file2;
        while (file != null && (file2 = file.getParentFile()) != null) {
            file = file2;
        }
        return file.toString();
    }

    public static File getRelativePath(File file, File file2) throws IOException {
        int n;
        if ((file = file.getCanonicalFile()).equals(file2 = file2.getCanonicalFile())) {
            return new File(".");
        }
        if (!PathUtil.b(file).equals(PathUtil.b(file2))) {
            return null;
        }
        File file3 = null;
        String[] stringArray = PathUtil.getPathComponents(file);
        String[] stringArray2 = PathUtil.getPathComponents(file2);
        for (n = 0; n < Math.min(stringArray.length, stringArray2.length) && stringArray[n].equals(stringArray2[n]); ++n) {
        }
        for (int i = 0; i < stringArray.length - n; ++i) {
            file3 = file3 == null ? new File("..") : new File(file3, "..");
        }
        while (n < stringArray2.length) {
            file3 = file3 == null ? new File(stringArray2[n]) : new File(file3, stringArray2[n]);
            ++n;
        }
        return file3;
    }
}

