/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plctypes;

import com.connecterra.i18n.I18N;
import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCListener;
import com.connecterra.plctypes.AbstractPLCTransport;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.RawConfig;
import com.connecterra.util.ValidatedConfig;
import com.connecterra.util.event.AbstractEventProcessor;
import com.connecterra.util.event.Event;
import com.connecterra.util.event.PeriodicEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;

public abstract class PLCPollTransport
extends AbstractPLCTransport {
    protected int m_pollInterval;
    private AbstractEventProcessor.PeriodicEventHandle l = new AbstractEventProcessor.PeriodicEventHandle();
    public static final String POLL_INTERVAL_PROP = "pollInterval";
    public static final String DEFAULT_POLL_INTERVAL = "500";

    protected void initFromRC(RawConfig rawConfig) throws ConfigValidationException {
        ValidatedConfig validatedConfig = new ValidatedConfig();
        validatedConfig.addIntegerItem(POLL_INTERVAL_PROP, DEFAULT_POLL_INTERVAL);
        this.m_pollInterval = validatedConfig.getIntegerValue(POLL_INTERVAL_PROP);
    }

    void c() {
        s_log.fine("start polling");
        this.doPeriodic(this.l, this.m_pollInterval, new PeriodicEvent(){

            public void handle() {
                if (PLCPollTransport.this.k.size() == 0) {
                    AbstractPLCTransport.s_log.fine("stop polling");
                    this.stop();
                } else {
                    AbstractPLCTransport.s_log.fine("Poll Items ---: m_pollInterval=" + PLCPollTransport.this.m_pollInterval);
                    PLCPollTransport.this.pollItems();
                }
            }
        });
    }

    protected void addIVListener(final String string, final PLCListener pLCListener, final AbstractPLCTransport.ItemValue itemValue) throws IOException, PLCException {
        this.doASAP(new Event(){

            public void handle() {
                boolean bl = PLCPollTransport.this.k.isEmpty();
                AbstractPLCTransport.WatchedItem watchedItem = (AbstractPLCTransport.WatchedItem)PLCPollTransport.this.k.get(string);
                if (watchedItem == null) {
                    watchedItem = new AbstractPLCTransport.WatchedItem(string);
                    PLCPollTransport.this.k.put(string, watchedItem);
                }
                watchedItem.addListener(pLCListener, itemValue);
                if (bl) {
                    PLCPollTransport.this.c();
                }
            }
        });
    }

    protected void pollItems() {
        try {
            this.connect();
        }
        catch (PLCException pLCException) {
            s_log.log(this.j ? Level.WARNING : Level.FINE, I18N.get("Error connecting for changes: {0}", pLCException.getMessage()), pLCException);
            this.j = false;
            return;
        }
        catch (IOException iOException) {
            s_log.log(this.j ? Level.WARNING : Level.FINE, I18N.get("Error connecting for changes: {0}", iOException.getMessage()), iOException);
            this.j = false;
            return;
        }
        ArrayList arrayList = new ArrayList(this.k.keySet());
        ArrayList arrayList2 = new ArrayList(this.k.values());
        Object object = arrayList2.iterator();
        while (object.hasNext()) {
            ((AbstractPLCTransport.WatchedItem)object.next()).addExtraItemsTo(arrayList);
        }
        try {
            s_log.finest("PLCPoll Reading itemName count=: " + arrayList.size());
            object = this.getReadings(arrayList);
            if (!this.j) {
                s_log.info(I18N.get("PLC polling resumed after error"));
            }
            this.j = true;
        }
        catch (PLCException pLCException) {
            s_log.log(this.j ? Level.WARNING : Level.FINE, I18N.get("PLC polling error: {0}", pLCException.getMessage()), pLCException);
            this.j = false;
            return;
        }
        catch (IOException iOException) {
            s_log.log(this.j ? Level.WARNING : Level.FINE, I18N.get("PLC polling error: {0}", iOException.getMessage()), iOException);
            this.j = false;
            return;
        }
        HashMap hashMap = new HashMap();
        Iterator iterator = arrayList.iterator();
        Iterator iterator2 = object.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            try {
                hashMap.put(iterator.next(), ((AbstractPLCTransport.ItemValue)iterator2.next()).getValue());
            }
            catch (PLCException pLCException) {
                s_log.log(Level.WARNING, I18N.get("Error converting tag to value: {0}", pLCException.getMessage()), pLCException);
            }
        }
        iterator = arrayList2.iterator();
        iterator2 = object.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            ((AbstractPLCTransport.WatchedItem)iterator.next()).update((AbstractPLCTransport.ItemValue)iterator2.next(), hashMap);
        }
    }
}

