/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plctypes;

import com.connecterra.i18n.I18N;
import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCListener;
import com.connecterra.plctypes.AbstractPLCTransport;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.RawConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public abstract class PLCAsyncTransport
extends AbstractPLCTransport {
    protected void initFromRC(RawConfig rawConfig) throws ConfigValidationException {
    }

    protected void addIVListener(String string, PLCListener pLCListener, AbstractPLCTransport.ItemValue itemValue) throws IOException, PLCException {
        AbstractPLCTransport.WatchedItem watchedItem = (AbstractPLCTransport.WatchedItem)this.k.get(string);
        if (watchedItem == null) {
            watchedItem = new AbstractPLCTransport.WatchedItem(string);
            this.k.put(string, watchedItem);
        }
        watchedItem.addListener(pLCListener, itemValue);
        try {
            this.reSetWatchListOnDevice();
        }
        catch (PLCException pLCException) {
            s_log.log(Level.WARNING, "set watch list on the device failed", pLCException);
        }
        catch (IOException iOException) {
            s_log.log(Level.WARNING, "set watch list on the device failed", iOException);
        }
    }

    public List read(List list) throws IOException, PLCException {
        throw new PLCException(I18N.get("read is not supported in the asynchronous PLCTRansport."));
    }

    protected abstract void setWatchListOnDevice(List var1) throws IOException, PLCException;

    public void reSetWatchListOnDevice() throws IOException, PLCException {
        ArrayList arrayList = new ArrayList(this.k.keySet());
        this.setWatchListOnDevice(arrayList);
    }

    public void pushUpItemValues(List list, List list2) {
        Object object;
        if (s_log.isLoggable(Level.FINER)) {
            s_log.finer("pushUpItemValues items:" + list);
            s_log.finer("pushUpItemValues values:" + list2);
        }
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("itemNames and values must have same size");
        }
        ArrayList<AbstractPLCTransport.DefaultItemValue> arrayList = new ArrayList<AbstractPLCTransport.DefaultItemValue>(list2.size());
        Object object2 = list2.iterator();
        while (object2.hasNext()) {
            arrayList.add(new AbstractPLCTransport.DefaultItemValue(object2.next()));
        }
        object2 = new HashMap();
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            object = new AbstractPLCTransport.DefaultItemValue(iterator2.next());
            object2.put(iterator.next(), object);
        }
        iterator = list.iterator();
        iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            object = (String)iterator.next();
            AbstractPLCTransport.WatchedItem watchedItem = (AbstractPLCTransport.WatchedItem)this.k.get(object);
            AbstractPLCTransport.DefaultItemValue defaultItemValue = new AbstractPLCTransport.DefaultItemValue(iterator2.next());
            if (watchedItem != null) {
                watchedItem.update(defaultItemValue, (Map)object2);
                continue;
            }
            s_log.warning(I18N.get("pushUpItem {0} is not recognized", object));
        }
    }
}

