/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plctypes;

import com.connecterra.i18n.I18N;
import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCInboundMessage;
import com.connecterra.plc.PLCInboundMessageListener;
import com.connecterra.plc.PLCListener;
import com.connecterra.plc.PLCMessageConvention;
import com.connecterra.plc.PLCOutboundMessage;
import com.connecterra.plc.PLCTransport;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.ListOfOne;
import com.connecterra.util.RawConfig;
import com.connecterra.util.ValidatedConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LatchMessageConvention
implements PLCMessageConvention {
    private String f = null;
    private PLCTransport g = null;
    private static Logger e = Logger.getLogger(LatchMessageConvention.class.getName());

    public void initialize(String string, PLCTransport pLCTransport, RawConfig rawConfig) throws ConfigValidationException {
        this.f = string;
        this.g = pLCTransport;
    }

    public PLCTransport getTransport() {
        return this.g;
    }

    public PLCOutboundMessage createOutboundMessage(String string, RawConfig rawConfig) throws ConfigValidationException {
        throw new ConfigValidationException(I18N.get("the multiple item convention does not support inbound messages"));
    }

    public PLCInboundMessage createInboundMessage(String string, RawConfig rawConfig) throws ConfigValidationException {
        return new InboundMessage(string, rawConfig);
    }

    public boolean isAlive() {
        return this.getTransport().isAlive();
    }

    private class InboundMessage
    implements PLCInboundMessage,
    PLCListener {
        private String g = null;
        private String k = null;
        private String f = null;
        private List j = null;
        private List i = null;
        private Set h = Collections.synchronizedSet(new HashSet());

        public InboundMessage(String string, RawConfig rawConfig) throws ConfigValidationException {
            this.g = string;
            ValidatedConfig validatedConfig = new ValidatedConfig();
            validatedConfig.addStringItem("receiveItem");
            validatedConfig.addStringItem("issetValue");
            validatedConfig.addStringItem("resetItem");
            validatedConfig.addIntegerItem("resetValue", 0, 65535);
            validatedConfig.readFrom(rawConfig);
            this.k = validatedConfig.getStringValue("receiveItem");
            this.f = validatedConfig.getStringValue("issetValue");
            this.j = new ListOfOne(validatedConfig.getStringValue("resetItem"));
            this.i = new ListOfOne(new Short((short)validatedConfig.getIntegerValue("resetValue")));
        }

        public PLCMessageConvention getMessageConvention() {
            return LatchMessageConvention.this;
        }

        public synchronized void addListener(PLCInboundMessageListener pLCInboundMessageListener) throws PLCException, IOException {
            boolean bl = this.h.isEmpty();
            this.h.add(pLCInboundMessageListener);
            if (bl) {
                this.b();
                LatchMessageConvention.this.g.addListener(this.k, this, null);
            }
        }

        public synchronized void removeListener(PLCInboundMessageListener pLCInboundMessageListener) throws PLCException, IOException {
            this.h.remove(pLCInboundMessageListener);
            if (this.h.isEmpty()) {
                LatchMessageConvention.this.g.removeListener(this.k, this);
            }
        }

        public void removeAllListeners() throws PLCException, IOException {
            this.h.clear();
            LatchMessageConvention.this.g.removeListener(this.k, this);
        }

        public List getExtraItems() {
            return null;
        }

        public void itemChanged(String string, Object object, List list) {
            if (!this.b(object)) {
                return;
            }
            Iterator iterator = this.h.iterator();
            while (iterator.hasNext()) {
                ((PLCInboundMessageListener)iterator.next()).receiveMessage(this.g, new ListOfOne(object));
            }
            try {
                if (!this.h.isEmpty()) {
                    LatchMessageConvention.this.g.removeListener(this.k, this);
                }
                this.b();
                if (!this.h.isEmpty()) {
                    LatchMessageConvention.this.g.addListener(this.k, this, null);
                }
            }
            catch (PLCException pLCException) {
                e.log(Level.WARNING, I18N.get("Error resetting latch: {0}", pLCException.getMessage()), pLCException);
            }
            catch (IOException iOException) {
                e.log(Level.WARNING, I18N.get("Error resetting latch: {0}", iOException.getMessage()), iOException);
            }
        }

        private void b() throws PLCException, IOException {
            long l = 0L;
            if (e.isLoggable(Level.FINE)) {
                l = System.currentTimeMillis();
            }
            do {
                LatchMessageConvention.this.g.write(this.j, this.i);
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!e.isLoggable(Level.FINER)) continue;
                e.finer("read after reset, still set");
            } while (LatchMessageConvention.this.g.read(new ListOfOne(this.k)).get(0).toString().equals(this.f));
            if (e.isLoggable(Level.FINER)) {
                e.finer("read after reset, now reset ");
            }
            long l2 = System.currentTimeMillis() - l;
            if (e.isLoggable(Level.FINE)) {
                e.fine("reset took " + l2 + " ms");
            }
        }

        private boolean b(Object object) {
            return object.toString().equals(this.f);
        }
    }
}

