/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plctypes;

import com.connecterra.i18n.I18N;
import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCInboundMessage;
import com.connecterra.plc.PLCInboundMessageListener;
import com.connecterra.plc.PLCListener;
import com.connecterra.plc.PLCMessageConvention;
import com.connecterra.plc.PLCOutboundMessage;
import com.connecterra.plc.PLCTransport;
import com.connecterra.util.ConfigItem;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.ListConfigItem;
import com.connecterra.util.ListOfOne;
import com.connecterra.util.RawConfig;
import com.connecterra.util.ValidatedConfig;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CounterPairMessageConvention
implements PLCMessageConvention,
PLCInboundMessageListener {
    private static final int s = 1;
    private static final int k = 2;
    private static final int u = 3;
    private static Logger p = Logger.getLogger(CounterPairMessageConvention.class.getName());
    private String m = null;
    private PLCTransport v = null;
    private State o = new State(1);
    private InboundMessage x;
    private List t;
    private long r;
    private Set j = Collections.synchronizedSet(new HashSet());
    private static final int n = 1;
    private static final int w = 2;
    private static final int l = 3;
    private static final int q = 4;
    private static final int i = 5;

    public void initialize(String string, PLCTransport pLCTransport, RawConfig rawConfig) throws ConfigValidationException, PLCException, IOException {
        this.m = string;
        this.v = pLCTransport;
        RawConfig rawConfig2 = rawConfig.getSubConfig("restart");
        if (rawConfig2.listValueNames().size() == 0) {
            this.o.setState(2);
            return;
        }
        ValidatedConfig validatedConfig = new ValidatedConfig();
        validatedConfig.addStringItem("restartAckStatusItem", null);
        validatedConfig.addLongItem("restartDelay", "0");
        validatedConfig.readFrom(rawConfig);
        this.t = validatedConfig.isValid("restartAckStatusItem") ? new ListOfOne(validatedConfig.getStringValue("restartAckStatusItem")) : null;
        this.r = validatedConfig.getLongValue("restartDelay");
        this.x = new InboundMessage("restart", rawConfig.getSubConfig("restart"), true);
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(this.x.f());
        arrayList.add(this.x.getCounterItem());
        arrayList.add((String)this.x.e().get(0));
        List list = this.v.read(arrayList);
        if (list.get(0).equals(list.get(1))) {
            if (((Short)list.get(2) & 1) == 1) {
                p.fine("PLC restarting at startup");
                this.o.setState(3);
            } else {
                p.fine("PLC running at startup");
                this.o.setState(2);
            }
        }
        this.x.addListener(this);
    }

    public PLCTransport getTransport() {
        return this.v;
    }

    public PLCOutboundMessage createOutboundMessage(String string, RawConfig rawConfig) throws ConfigValidationException {
        return new OutboundMessage(string, rawConfig);
    }

    public PLCInboundMessage createInboundMessage(String string, RawConfig rawConfig) throws ConfigValidationException {
        return new InboundMessage(string, rawConfig);
    }

    public boolean isAlive() {
        return this.v.isAlive() && this.o.getState() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(String string, List list) {
        boolean bl;
        Object object;
        try {
            object = (Short)list.get(0);
            bl = ((Short)object & 1) != 0;
        }
        catch (ClassCastException classCastException) {
            p.warning(I18N.get("restart: status item value has incorrect type {0}", list.get(0).getClass().getName()));
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            p.warning(I18N.get("restart: status item value not present"));
            return;
        }
        if (bl) {
            p.fine("PLC restart initiated");
            this.o.setState(3);
            object = this.j;
            synchronized (object) {
                Iterator iterator = this.j.iterator();
                while (iterator.hasNext()) {
                    ((Suspendable)iterator.next()).suspend();
                }
            }
        }
        try {
            if (this.o.isState(1)) {
                p.fine("PLC initialization complete");
                return;
            }
            p.fine("PLC restart complete");
        }
        finally {
            this.o.setState(2);
        }
        object = this.j;
        synchronized (object) {
            Iterator iterator;
            Object object22;
            ArrayList<String> arrayList = new ArrayList<String>(this.j.size());
            for (Object object22 : this.j) {
                arrayList.add(object22.getCounterItem());
            }
            Object object3 = null;
            try {
                object3 = this.v.read(arrayList);
            }
            catch (PLCException pLCException) {
                p.log(Level.WARNING, I18N.get("Couldn''t initialize counters after restart: {0}", pLCException.getMessage()), pLCException);
            }
            catch (IOException iOException) {
                p.log(Level.WARNING, I18N.get("Couldn''t initialize counters after restart: {0}", iOException.getMessage()), iOException);
            }
            object22 = this.j.iterator();
            Iterator iterator2 = iterator = object3 == null ? null : object3.iterator();
            while (object22.hasNext()) {
                Suspendable suspendable = (Suspendable)object22.next();
                suspendable.resume();
                if (iterator == null) continue;
                Object e = iterator.next();
                if (!(e instanceof Short)) {
                    p.warning(I18N.get("counter item {0} has type {1} instead of Short", (Object)suspendable.getCounterItem(), (Object)e.getClass().getName()));
                    continue;
                }
                suspendable.setCounter((Short)e);
            }
        }
        if (this.t == null) {
            return;
        }
        try {
            Thread.sleep(this.r);
        }
        catch (InterruptedException interruptedException) {
            p.fine("restart transaction interrupted");
            Thread.currentThread().interrupt();
        }
        try {
            this.v.write(this.t, list);
        }
        catch (PLCException pLCException) {
            p.log(Level.WARNING, I18N.get("Couldn''t set restart ack status: {0}", pLCException.getMessage()), pLCException);
        }
        catch (IOException iOException) {
            p.log(Level.WARNING, I18N.get("Couldn''t set restart ack status: {0}", iOException.getMessage()), iOException);
        }
    }

    private class InboundMessage
    implements PLCInboundMessage,
    PLCListener,
    Suspendable {
        private String t;
        private boolean ab;
        private String u;
        private String bb;
        private boolean y;
        private boolean z;
        private List v;
        private Short x;
        private Set s = new HashSet();

        public InboundMessage(String string, RawConfig rawConfig, boolean bl) throws ConfigValidationException {
            this.t = string;
            this.ab = bl;
            ValidatedConfig validatedConfig = new ValidatedConfig();
            validatedConfig.addStringItem("receiveCounterItem");
            validatedConfig.addStringItem("ackCounterItem");
            validatedConfig.addBooleanItem("prefetch", "false");
            validatedConfig.addBooleanItem("alwaysAck", "true");
            validatedConfig.addItem("dataItems", (ConfigItem)new ListConfigItem(true), "");
            validatedConfig.readFrom(rawConfig);
            this.u = validatedConfig.getStringValue("receiveCounterItem");
            this.bb = validatedConfig.getStringValue("ackCounterItem");
            this.y = validatedConfig.getBooleanValue("prefetch");
            this.z = validatedConfig.getBooleanValue("alwaysAck");
            this.v = Arrays.asList(validatedConfig.getListValue("dataItems"));
            if (!this.z) {
                return;
            }
            try {
                this.c();
            }
            catch (IOException iOException) {
                p.log(Level.WARNING, I18N.get("inbound message {0}: setting up static ack: {1}", (Object)this.t, (Object)iOException.getMessage()), iOException);
                return;
            }
            catch (PLCException pLCException) {
                p.log(Level.WARNING, I18N.get("inbound message {0}: setting up static ack: {1}", (Object)this.t, (Object)pLCException.getMessage()), pLCException);
                return;
            }
        }

        public InboundMessage(String string, RawConfig rawConfig) throws ConfigValidationException {
            this(string, rawConfig, false);
        }

        private void c() throws IOException, PLCException {
            if (CounterPairMessageConvention.this.o.isState(2) || this.ab) {
                CounterPairMessageConvention.this.v.addListener(this.u, this, null);
            }
            if (!this.ab) {
                CounterPairMessageConvention.this.j.add(this);
            }
        }

        private void d() throws IOException, PLCException {
            CounterPairMessageConvention.this.v.removeListener(this.u, this);
            CounterPairMessageConvention.this.j.remove(this);
        }

        public PLCMessageConvention getMessageConvention() {
            return CounterPairMessageConvention.this;
        }

        public String getCounterItem() {
            return this.bb;
        }

        public void setCounter(Short s) {
            this.x = s;
        }

        String f() {
            return this.bb;
        }

        List e() {
            return this.v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(PLCInboundMessageListener pLCInboundMessageListener) throws PLCException, IOException {
            Set set = this.s;
            synchronized (set) {
                boolean bl = this.s.isEmpty();
                this.s.add(pLCInboundMessageListener);
                if (bl && !this.z) {
                    this.c();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(PLCInboundMessageListener pLCInboundMessageListener) throws PLCException, IOException {
            Set set = this.s;
            synchronized (set) {
                this.s.remove(pLCInboundMessageListener);
                if (this.s.isEmpty() && !this.z) {
                    this.d();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAllListeners() throws PLCException, IOException {
            Set set = this.s;
            synchronized (set) {
                if (!this.s.isEmpty()) {
                    this.s.clear();
                    if (!this.z) {
                        this.d();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspend() {
            p.fine("suspending inbound message " + this.t);
            Set set = this.s;
            synchronized (set) {
                try {
                    CounterPairMessageConvention.this.v.removeListener(this.u, this);
                }
                catch (IOException iOException) {
                    p.log(Level.WARNING, I18N.get("inbound message {0}: failed suspending listener", this.t), iOException);
                    return;
                }
                catch (PLCException pLCException) {
                    p.log(Level.WARNING, I18N.get("inbound message {0}: failed suspending listener", this.t), pLCException);
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            Set set = this.s;
            synchronized (set) {
                this.x = null;
                if (this.s.isEmpty() && !this.z) {
                    return;
                }
                try {
                    CounterPairMessageConvention.this.v.addListener(this.u, this, null);
                }
                catch (IOException iOException) {
                    p.log(Level.WARNING, I18N.get("inbound message {0}: failed resuming listener: {1}", (Object)this.t, (Object)iOException.getMessage()), iOException);
                    return;
                }
                catch (PLCException pLCException) {
                    p.log(Level.WARNING, I18N.get("inbound message {0}: failed resuming listener: {1}", (Object)this.t, (Object)pLCException.getMessage()), pLCException);
                    return;
                }
            }
        }

        public List getExtraItems() {
            return this.y ? this.v : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void itemChanged(String string, Object object, List list) {
            Short s;
            if (p.isLoggable(Level.FINER)) {
                p.log(Level.FINER, "item " + string + " changed to value " + object);
            }
            if (!CounterPairMessageConvention.this.o.isState(2) && !this.ab) {
                p.log(Level.FINE, "ignoring change because initializing or restarting");
                return;
            }
            if (!CounterPairMessageConvention.this.o.isState(2) && !this.ab) {
                return;
            }
            if (this.x == null) {
                try {
                    s = CounterPairMessageConvention.this.v.read(new ListOfOne(this.bb)).get(0);
                    if (!(s instanceof Short)) {
                        p.warning(I18N.get("inbound message {0}: counter item {1} has type {2} instead of Short", (Object)this.t, (Object)this.bb, (Object)s.getClass().getName()));
                        return;
                    }
                    this.x = s;
                }
                catch (PLCException pLCException) {
                    p.log(Level.WARNING, I18N.get("Couldn''t initialize counter for inbound message {0}: {1}", (Object)this.t, (Object)pLCException.getMessage()), pLCException);
                    return;
                }
                catch (IOException iOException) {
                    p.log(Level.WARNING, I18N.get("Couldn''t initialize counter for inbound message {0}: {1}", (Object)this.t, (Object)iOException.getMessage()), iOException);
                    return;
                }
            }
            if (!(object instanceof Short)) {
                p.warning(I18N.get("inbound message {0}: counter item {1} has type {2} instead of Short", (Object)this.t, (Object)this.u, (Object)object.getClass().getName()));
                return;
            }
            s = (Short)object;
            if (this.x.equals(s)) {
                p.info(I18N.get("changed ack counter {0} equals current value", s));
                return;
            }
            List list2 = null;
            if (this.y) {
                list2 = list;
            } else if (this.v.size() > 0) {
                try {
                    list2 = CounterPairMessageConvention.this.v.read(this.v);
                }
                catch (IOException iOException) {
                    p.log(Level.WARNING, I18N.get("Couldn''t read data items for inbound message {0}: {1}", (Object)this.t, (Object)iOException.getMessage()), iOException);
                    return;
                }
                catch (PLCException pLCException) {
                    p.log(Level.WARNING, I18N.get("Couldn''t read data items for inbound message {0}: {1}", (Object)this.t, (Object)pLCException.getMessage()), pLCException);
                    return;
                }
            }
            p.fine("Inbound message " + this.t + " txn " + s + " received with values " + list2);
            Set set = this.s;
            synchronized (set) {
                Iterator iterator = this.s.iterator();
                while (iterator.hasNext()) {
                    ((PLCInboundMessageListener)iterator.next()).receiveMessage(this.t, list2);
                }
            }
            if (this == CounterPairMessageConvention.this.x && CounterPairMessageConvention.this.t == null) {
                p.log(Level.FINE, "restarting in slave mode; not acknowledging");
                this.x = s;
                return;
            }
            try {
                CounterPairMessageConvention.this.v.write(new ListOfOne(this.bb), new ListOfOne(s));
                this.x = s;
            }
            catch (PLCException pLCException) {
                this.x = null;
                p.log(Level.WARNING, I18N.get("Couldn''t ack counter for inbound message {0}: {1}", (Object)this.t, (Object)pLCException.getMessage()), pLCException);
            }
            catch (IOException iOException) {
                this.x = null;
                p.log(Level.WARNING, I18N.get("Couldn''t ack counter for inbound message {0}: {1}", (Object)this.t, (Object)iOException.getMessage()), iOException);
            }
        }
    }

    private class OutboundMessage
    implements PLCOutboundMessage,
    PLCListener,
    Suspendable {
        private String p;
        private String n;
        private String r;
        private List o;
        private volatile Short m;
        private State q = new State(1);

        public OutboundMessage(String string, RawConfig rawConfig) throws ConfigValidationException {
            this.p = string;
            ValidatedConfig validatedConfig = new ValidatedConfig();
            validatedConfig.addStringItem("sendCounterItem");
            validatedConfig.addStringItem("ackCounterItem");
            validatedConfig.addItem("dataItems", (ConfigItem)new ListConfigItem(true), "");
            validatedConfig.readFrom(rawConfig);
            this.n = validatedConfig.getStringValue("sendCounterItem");
            this.r = validatedConfig.getStringValue("ackCounterItem");
            this.o = Arrays.asList(validatedConfig.getListValue("dataItems"));
        }

        public PLCMessageConvention getMessageConvention() {
            return CounterPairMessageConvention.this;
        }

        public String getCounterItem() {
            return this.r;
        }

        public void setCounter(Short s) {
            this.m = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(List list) throws PLCException, IOException {
            if (list == null && this.o.size() != 0) {
                throw new PLCException(I18N.get("expected {0} data items, but got none", this.o.size()));
            }
            if (list.size() != this.o.size()) {
                throw new PLCException(I18N.get("expected {0} data items, but got {1}", this.o.size(), list.size()));
            }
            CounterPairMessageConvention.this.o.waitForState(2);
            State state = this.q;
            synchronized (state) {
                if (!this.q.isState(1)) {
                    throw new IllegalStateException("message invocation is not reentrant");
                }
                try {
                    while (true) {
                        Short s;
                        this.q.setState(2);
                        if (this.m == null) {
                            s = CounterPairMessageConvention.this.v.read(new ListOfOne(this.r)).get(0);
                            if (!(s instanceof Short)) {
                                throw new PLCException(I18N.get("counter item {0} has type {1} instead of Short", (Object)this.r, (Object)s.getClass().getName()));
                            }
                            this.m = s;
                        }
                        s = this.m;
                        this.b(list);
                        CounterPairMessageConvention.this.v.addListener(this.r, this, s);
                        CounterPairMessageConvention.this.j.add(this);
                        while (!this.q.isState(3) && !this.q.isState(5)) {
                            this.q.waitOnce();
                        }
                        p.finer("Outbound message " + this.p + " txn " + this.m + " state after wait is " + this.q.getState());
                        if (!this.q.isState(3)) continue;
                        p.fine("Outbound message " + this.p + " txn " + this.m + " complete");
                        return;
                        finally {
                            CounterPairMessageConvention.this.j.remove(this);
                            CounterPairMessageConvention.this.v.removeListener(this.r, this);
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.q.setState(1);
                }
            }
        }

        private void b(List list) throws PLCException, IOException {
            short s = (short)(this.m + 1);
            if (s > 255) {
                s = 1;
            }
            this.m = new Short(s);
            p.fine("Invoking outbound message " + this.p + " txn " + this.m + " with params " + list);
            ArrayList<String> arrayList = new ArrayList<String>(this.o.size() + 1);
            ArrayList<Short> arrayList2 = new ArrayList<Short>(this.o.size() + 1);
            arrayList.addAll(this.o);
            arrayList.add(this.n);
            arrayList2.addAll(list);
            arrayList2.add(this.m);
            CounterPairMessageConvention.this.v.write(arrayList, arrayList2);
        }

        public List getExtraItems() {
            return null;
        }

        public void itemChanged(String string, Object object, List list) {
            if (!(object instanceof Short)) {
                p.warning(I18N.get("outbound message {0}: counter item {1} has type {2} instead of Short", (Object)this.p, (Object)this.r, (Object)object.getClass().getName()));
                return;
            }
            Short s = (Short)object;
            if (!this.m.equals(s)) {
                p.fine(I18N.get("outbound message {0}: counter contains unexpected value {1}, should be {2}", (Object)this.p, (Object)s, (Object)this.m));
                return;
            }
            p.fine("outbound message " + this.p + " txn " + this.m + " acknowledged.");
            this.q.setState(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspend() {
            p.fine("suspending outbound message " + this.p);
            State state = this.q;
            synchronized (state) {
                if (this.q.isState(2) || this.q.isState(5)) {
                    this.q.setState(4);
                    try {
                        CounterPairMessageConvention.this.v.removeListener(this.r, this);
                    }
                    catch (IOException iOException) {
                        p.log(Level.WARNING, I18N.get("outbound message {0}: failed suspending listener", this.p), iOException);
                        return;
                    }
                    catch (PLCException pLCException) {
                        p.log(Level.WARNING, I18N.get("outbound message {0}: failed suspending listener", this.p), pLCException);
                        return;
                    }
                }
            }
            p.fine("outbound message " + this.p + " txn " + this.m + " held");
        }

        public void resume() {
            Short s = this.m;
            this.m = null;
            try {
                CounterPairMessageConvention.this.v.addListener(this.r, this, null);
            }
            catch (IOException iOException) {
                p.log(Level.WARNING, I18N.get("outbound message {0}: failed resuming listener: {1}", (Object)this.p, (Object)iOException.getMessage()), iOException);
                return;
            }
            catch (PLCException pLCException) {
                p.log(Level.WARNING, I18N.get("outbound message {0}: failed resuming listener: {1}", (Object)this.p, (Object)pLCException.getMessage()), pLCException);
                return;
            }
            this.q.setState(5);
            p.fine("outbound message " + this.p + " txn " + s + " resumed");
        }
    }

    private static interface Suspendable {
        public String getCounterItem();

        public void setCounter(Short var1);

        public void suspend();

        public void resume();
    }

    private static class State {
        private int b;

        public State(int n) {
            this.b = n;
        }

        public synchronized void setState(int n) {
            this.b = n;
            this.notifyAll();
        }

        public synchronized int getState() {
            return this.b;
        }

        public synchronized boolean isState(int n) {
            return this.b == n;
        }

        public synchronized void waitOnce() throws InterruptedIOException {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                InterruptedIOException interruptedIOException = new InterruptedIOException(I18N.get("waiting for state: {0}", interruptedException.getMessage()));
                interruptedIOException.initCause(interruptedException);
                throw interruptedIOException;
            }
        }

        public synchronized void waitForState(int n) throws InterruptedIOException {
            while (this.b != n) {
                this.waitOnce();
            }
        }

        public synchronized void waitForNotState(int n) throws InterruptedIOException {
            while (this.b == n) {
                this.waitOnce();
            }
        }
    }
}

