/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.modbus.protocol;

import com.connecterra.modbus.protocol.MODBUSConstants;
import com.connecterra.modbus.protocol.MODBUSPDU;
import com.connecterra.modbus.protocol.ProtocolException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class ADU
implements MODBUSConstants {
    private static final Logger r = Logger.getLogger("com.connecterra.modbus.client");
    private int o;
    private MODBUSPDU p;
    private int q;

    public ADU(int n, int n2, MODBUSPDU mODBUSPDU) {
        this.o = n2;
        this.p = mODBUSPDU;
        this.q = n;
    }

    public int getTransactionID() {
        return this.o;
    }

    public MODBUSPDU getPDU() {
        return this.p;
    }

    public static ADU read(DataInputStream dataInputStream, boolean bl) throws IOException, ProtocolException {
        byte[] byArray = new byte[7];
        try {
            dataInputStream.readFully(byArray);
        }
        catch (EOFException eOFException) {
            if (eOFException.getMessage() == null) {
                throw new EOFException("Modbus slave closed.");
            }
            throw eOFException;
        }
        catch (IOException iOException) {
            if (iOException.getMessage() == null) {
                throw new IOException("IO Error in reading MBAP.");
            }
            throw iOException;
        }
        int n = (byArray[0] << 8) + byArray[1];
        int n2 = (byArray[2] << 8) + byArray[3];
        int n3 = (byArray[4] << 8) + byArray[5];
        byte by = byArray[6];
        if (n2 != 0) {
            throw new ProtocolException("Bad protocol ID (" + n2 + ")");
        }
        if (n3 < 2) {
            throw new ProtocolException("ADU length too short (" + n3 + ")");
        }
        int n4 = n3 - 1;
        byte[] byArray2 = new byte[n4];
        try {
            dataInputStream.readFully(byArray2);
        }
        catch (IOException iOException) {
            if (iOException.getMessage() == null) {
                throw new IOException("Error in reading PDU.");
            }
            throw iOException;
        }
        MODBUSPDU mODBUSPDU = MODBUSPDU.parse(byArray2, bl);
        return new ADU(by, n, mODBUSPDU);
    }

    public void write(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = this.p.b() + 1;
        byteArrayOutputStream.write(this.o >> 8);
        byteArrayOutputStream.write(this.o);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(n >> 8);
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(this.q);
        this.p.b(byteArrayOutputStream);
        outputStream.write(byteArrayOutputStream.toByteArray());
        outputStream.flush();
        byteArrayOutputStream.close();
    }
}

