/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.httpMessage;

import com.connecterra.httpMessage.DecodeException;
import com.connecterra.httpMessage.URIUtil;
import com.connecterra.i18n.I18N;
import com.connecterra.util.ObjectUtil;

public class URL {
    private String e = "";
    private String d = "";
    private int c = 80;
    private String f = "/";
    private String b = null;

    public URL(String string) throws DecodeException {
        if (string == null) {
            throw new NullPointerException(I18N.get("Null url arg."));
        }
        int n = string.indexOf("://");
        if (n == -1) {
            throw new DecodeException(I18N.get("Missing protocol portion: {0}", string));
        }
        this.e = string.substring(0, n).toLowerCase();
        if (!this.e.equals("http") && !this.e.equals("https")) {
            throw new DecodeException(I18N.get("Invalid protocol: {0}", this.e));
        }
        String string2 = null;
        String string3 = string.substring(n + 3);
        int n2 = string3.indexOf("/");
        if (n2 == -1) {
            string2 = "/";
            n2 = string3.length();
        } else {
            string2 = string3.substring(n2);
        }
        int n3 = string2.indexOf("?");
        if (n3 != -1) {
            this.f = string2.substring(0, n3);
            this.b = string2.substring(n3 + 1);
        } else {
            this.f = string2;
        }
        String string4 = string3.substring(0, n2);
        int n4 = string4.indexOf(":");
        if (n4 != -1) {
            try {
                this.c = Integer.parseInt(string4.substring(n4 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new DecodeException(I18N.get("Bad port portion: {0}", string));
            }
            if (this.c < 0 || this.c > 65535) {
                throw new DecodeException(I18N.get("Invalid port: {0}", string));
            }
            this.d = string4.substring(0, n4).toLowerCase();
        } else {
            this.d = string4.toLowerCase();
            if (this.e.equals("https")) {
                this.c = 443;
            }
        }
    }

    public URL(String string, String string2, int n, String string3, String string4) {
        if (string == null) {
            throw new NullPointerException(I18N.get("Null prot arg."));
        }
        this.e = string.toLowerCase();
        if (string2 != null) {
            this.d = string2.toLowerCase();
        }
        this.c = n;
        this.f = string3;
        this.b = string4;
        if (!this.e.equals("http") && !this.e.equals("https")) {
            throw new IllegalArgumentException(I18N.get("Invalid protocol: {0}", this.e));
        }
        if (this.c < 0 || this.c > 65535) {
            throw new IllegalArgumentException(I18N.get("Invalid port: {0}", this.c));
        }
        if (this.f == null || !this.f.startsWith("/")) {
            throw new IllegalArgumentException(I18N.get("Invalid path: {0}", this.f));
        }
    }

    public String getProtocol() {
        return this.e;
    }

    public String getHost() {
        return this.d;
    }

    public int getPort() {
        return this.c;
    }

    public String getPath() {
        return this.f;
    }

    public String getQuery() {
        return this.b;
    }

    public String getPathAndQuery() {
        if (this.b != null) {
            return this.f + "?" + this.b;
        }
        return this.f;
    }

    public String toString() {
        String string = "";
        if (this.e.equals("http") && this.c != 80) {
            string = ":" + this.c;
        } else if (this.e.equals("https") && this.c != 443) {
            string = ":" + this.c;
        }
        return this.e + "://" + this.d + string + this.getPathAndQuery();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("prot: " + this.e);
        stringBuffer.append("; host: " + this.d);
        stringBuffer.append("; port: " + this.c);
        stringBuffer.append("; path: " + this.f);
        stringBuffer.append("; query: " + this.b);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof URL)) {
            return false;
        }
        URL uRL = (URL)object;
        return this.e.equals(uRL.e) && this.d.equals(uRL.d) && this.c == uRL.c && URIUtil.decode(this.f).equals(URIUtil.decode(uRL.f)) && ObjectUtil.equals(URIUtil.decode(this.b), URIUtil.decode(uRL.b));
    }

    public int hashCode() {
        return this.e.hashCode() + this.d.hashCode() + this.c + URIUtil.decode(this.f).hashCode() + ObjectUtil.hashCode(URIUtil.decode(this.b));
    }
}

