/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.httpMessage;

import com.connecterra.i18n.I18N;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URIUtil {
    private static final char[] b = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final BitSet c = URIUtil.b();

    public static final String decode(String string) {
        return URIUtil.decode(string, false);
    }

    public static final String decode(String string, boolean bl) {
        try {
            return string == null ? null : URIUtil.decode(string.getBytes(), null, bl);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(I18N.get("Default encoding not supported !?!"));
        }
    }

    public static final String decode(byte[] byArray, String string, boolean bl) throws UnsupportedEncodingException {
        return URIUtil.decode(byArray, 0, byArray.length, string, bl);
    }

    public static final String decode(byte[] byArray, int n, int n2, String string, boolean bl) throws UnsupportedEncodingException {
        if (null == byArray) {
            return null;
        }
        int n3 = n + n2;
        int n4 = n;
        int n5 = n;
        while (n4 < n3) {
            int n6 = byArray[n4++];
            if (bl && n6 == 43) {
                n6 = 32;
            } else if (n6 == 37) {
                n6 = (byte)((URIUtil.b(byArray[n4++]) << 4) + URIUtil.b(byArray[n4++]));
            }
            byArray[n5++] = n6;
        }
        if (string != null) {
            return new String(byArray, n, n5, string);
        }
        return new String(byArray, n, n5);
    }

    public static final String encode(String string) {
        return URIUtil.encode(string, null, false);
    }

    public static final String encode(String string, boolean bl) {
        return URIUtil.encode(string, null, bl);
    }

    public static final String encode(String string, BitSet bitSet) {
        return string == null ? null : URIUtil.encode(string.getBytes(), bitSet, false);
    }

    public static final String encode(String string, BitSet bitSet, boolean bl) {
        return string == null ? null : URIUtil.encode(string.getBytes(), bitSet, bl);
    }

    public static final String encode(byte[] byArray, BitSet bitSet) {
        return byArray == null ? null : URIUtil.encode(byArray, 0, byArray.length, bitSet, false);
    }

    public static final String encode(byte[] byArray, BitSet bitSet, boolean bl) {
        return byArray == null ? null : URIUtil.encode(byArray, 0, byArray.length, bitSet, bl);
    }

    public static final String encode(byte[] byArray, int n, int n2, BitSet bitSet) {
        return byArray == null ? null : URIUtil.encode(byArray, 0, byArray.length, bitSet, false);
    }

    public static final String encode(byte[] byArray, int n, int n2, BitSet bitSet, boolean bl) {
        if (null == byArray) {
            return null;
        }
        if (null == bitSet) {
            bitSet = c;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = n; i < n2; ++i) {
            char c = (char)byArray[i];
            if (bitSet.get(c)) {
                stringBuffer.append(c);
                continue;
            }
            if (bl && ' ' == c) {
                stringBuffer.append('+');
                continue;
            }
            byte by = byArray[i];
            stringBuffer.append('%');
            int n3 = by & 0xF;
            int n4 = (by & 0xF0) >> 4;
            stringBuffer.append(b[n4]);
            stringBuffer.append(b[n3]);
        }
        return stringBuffer.toString();
    }

    public static final String encode(String string, BitSet bitSet, String string2) {
        return URIUtil.encode(string, bitSet, string2, false);
    }

    public static final String encode(String string, BitSet bitSet, String string2, boolean bl) {
        try {
            return URIUtil.encode(string.getBytes(string2), bitSet, bl);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return URIUtil.encode(string.getBytes(), bitSet, bl);
        }
    }

    public static final BitSet pathSafe() {
        return c;
    }

    private static final BitSet b() {
        int n;
        BitSet bitSet = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            bitSet.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            bitSet.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            bitSet.set(n);
        }
        bitSet.set(45);
        bitSet.set(95);
        bitSet.set(46);
        bitSet.set(33);
        bitSet.set(126);
        bitSet.set(42);
        bitSet.set(39);
        bitSet.set(40);
        bitSet.set(41);
        bitSet.set(47);
        bitSet.set(59);
        bitSet.set(61);
        bitSet.set(63);
        return bitSet;
    }

    private static final byte b(byte by) {
        switch (by) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return (byte)(by - 48);
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return (byte)(by - 97 + 10);
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return (byte)(by - 65 + 10);
            }
        }
        throw new IllegalArgumentException(I18N.get("{0} is not a hex value", by));
    }
}

