/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.httpMessage;

import com.connecterra.httpMessage.DecodeException;
import com.connecterra.httpMessage.HTTPMessage;
import com.connecterra.httpMessage.HTTPStream;
import com.connecterra.httpMessage.ProtocolException;
import com.connecterra.httpMessage.TimeoutException;
import com.connecterra.i18n.I18N;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class HTTPMessageCodec {
    private static Logger k = Logger.getLogger("com.connecterra.httpMessage.HTTPMessageCodec");
    private static final String r = "\r\n";
    private HTTPStream b = null;
    private byte[] w = null;
    private int q = 0;
    private HTTPMessage f = null;
    private boolean g = false;
    private boolean p = false;
    private boolean i = false;
    private byte[] h = null;
    private byte[] s = null;
    private ByteArrayOutputStream j = new ByteArrayOutputStream();
    private int x = 0;
    private boolean t = false;
    private String d = null;
    private String c = "";
    private StringBuffer v = new StringBuffer();
    private boolean l = false;
    private int n = 0;
    private static final int m = 1;
    private static final int u = 2;
    private static final int o = 3;
    private static final int e = 4;

    public HTTPMessageCodec(HTTPStream hTTPStream) {
        if (hTTPStream == null) {
            throw new NullPointerException(I18N.get("Null stream arg."));
        }
        this.b = hTTPStream;
        this.setupRead();
    }

    public HTTPStream getStream() {
        return this.b;
    }

    public void reset() {
        this.setupRead();
        this.w = null;
        this.q = 0;
    }

    protected void setupRead() {
        this.f = new HTTPMessage();
        this.g = false;
        this.p = false;
        this.i = false;
        this.h = null;
        this.s = null;
        this.j.reset();
        this.x = 0;
        this.t = false;
        this.l = false;
        this.d = null;
        this.c = "";
        this.v.setLength(0);
    }

    public void writeMessage(HTTPMessage hTTPMessage, int n) throws IOException, TimeoutException, InterruptedException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (hTTPMessage.getRequestMethod() != null) {
            if (hTTPMessage.getRequestMethod().equals("POST") || hTTPMessage.getRequestMethod().equals("PUT")) {
                bl = true;
            } else if (hTTPMessage.getContent().length > 0) {
                throw new IllegalArgumentException(I18N.get("HTTP {0} request with non-empty content: {1}", (Object)hTTPMessage.getRequestMethod(), (Object)hTTPMessage));
            }
            this.writeRequestLine(hTTPMessage, stringBuffer);
        } else if (hTTPMessage.getResponseCode() != -1) {
            this.writeResponseLine(hTTPMessage, stringBuffer);
            bl = true;
        } else {
            throw new IllegalArgumentException(I18N.get("HTTP message is neither a request nor a response: {0}", hTTPMessage));
        }
        this.writeHeaders(hTTPMessage, bl, stringBuffer);
        stringBuffer.append(r);
        String string = stringBuffer.toString();
        byte[] byArray = string.getBytes();
        k.fine("Writing header: " + string);
        if (bl) {
            byte[] byArray2 = hTTPMessage.getContent();
            this.w = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, this.w, 0, byArray.length);
            System.arraycopy(byArray2, 0, this.w, byArray.length, byArray2.length);
        } else {
            this.w = byArray;
        }
        this.q = 0;
        this.doWrite(n);
    }

    public void finishInterruptedWrite(int n) throws IOException, TimeoutException, InterruptedException {
        this.doWrite(n);
    }

    protected void doWrite(int n) throws IOException, TimeoutException, InterruptedException {
        if (this.w != null && this.q < this.w.length) {
            try {
                int n2 = this.w.length - this.q;
                this.b.write(this.w, this.q, n2, n);
                this.q += n2;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.q += socketTimeoutException.bytesTransferred;
                throw new TimeoutException(I18N.get("Timeout writing header"), socketTimeoutException);
            }
            catch (InterruptedIOException interruptedIOException) {
                this.q += interruptedIOException.bytesTransferred;
                throw (InterruptedException)new InterruptedException().initCause(interruptedIOException);
            }
        }
        this.w = null;
    }

    protected void writeRequestLine(HTTPMessage hTTPMessage, StringBuffer stringBuffer) {
        stringBuffer.append(hTTPMessage.getRequestMethod());
        stringBuffer.append(" ");
        stringBuffer.append(hTTPMessage.getRequestURI());
        stringBuffer.append(" HTTP/" + hTTPMessage.getHTTPVersion());
        stringBuffer.append(r);
    }

    protected void writeResponseLine(HTTPMessage hTTPMessage, StringBuffer stringBuffer) {
        stringBuffer.append("HTTP/" + hTTPMessage.getHTTPVersion());
        stringBuffer.append(" " + hTTPMessage.getResponseCode());
        stringBuffer.append(" " + hTTPMessage.getResponseText());
        stringBuffer.append(r);
    }

    protected void writeHeaders(HTTPMessage hTTPMessage, boolean bl, StringBuffer stringBuffer) {
        if (bl) {
            stringBuffer.append("Content-Length: " + hTTPMessage.getContent().length + r);
        }
        List list = hTTPMessage.getHeaderNames();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (string.equalsIgnoreCase("Content-Length")) continue;
            this.writeHeader(hTTPMessage, string, stringBuffer);
        }
    }

    protected void writeHeader(HTTPMessage hTTPMessage, String string, StringBuffer stringBuffer) {
        List list = hTTPMessage.getHeaderValues(string);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append(string + ": " + list.get(i) + r);
        }
    }

    public HTTPMessage readMessage(int n) throws DecodeException, ProtocolException, IOException, TimeoutException, InterruptedException {
        this.doRead(n);
        HTTPMessage hTTPMessage = null;
        if (this.t) {
            hTTPMessage = this.f;
        }
        this.setupRead();
        return hTTPMessage;
    }

    protected void doRead(int n) throws DecodeException, ProtocolException, IOException, TimeoutException, InterruptedException {
        if (!this.readRequestOrResponseLine(n)) {
            return;
        }
        this.readHeaders(n);
        boolean bl = false;
        if (this.f.getRequestMethod() != null && (this.f.getRequestMethod().equals("POST") || this.f.getRequestMethod().equals("PUT"))) {
            bl = true;
        } else {
            int n2 = this.f.getResponseCode();
            switch (n2) {
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 206: 
                case 300: 
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    bl = true;
                    break;
                }
                case -1: {
                    break;
                }
            }
            if (n2 >= 400 && n2 <= 499) {
                bl = true;
            }
            if (n2 >= 500 && n2 <= 599) {
                bl = true;
            }
        }
        if (bl) {
            this.readContent(n);
        } else {
            this.t = true;
        }
    }

    protected boolean readRequestOrResponseLine(int n) throws DecodeException, ProtocolException, IOException, TimeoutException, InterruptedException {
        if (this.g) {
            return true;
        }
        String string = this.readLine(n);
        if (string == null) {
            return false;
        }
        if (string.toUpperCase().startsWith("HTTP/")) {
            this.processResponse(string);
        } else if (string.startsWith("GET ") || string.startsWith("POST ") || string.startsWith("OPTIONS ") || string.startsWith("HEAD ") || string.startsWith("PUT ") || string.startsWith("DELETE ") || string.startsWith("TRACE ") || string.startsWith("CONNECT ")) {
            this.processRequest(string);
        } else {
            throw new ProtocolException(I18N.get("Invalid input when looking for HTTP message start: ", string));
        }
        this.g = true;
        return true;
    }

    protected void processRequest(String string) throws DecodeException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() != 3) {
            throw new DecodeException(I18N.get("Bad HTTP request: {0}", string));
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        if (!string4.toUpperCase().startsWith("HTTP/")) {
            throw new DecodeException(I18N.get("Bad HTTP/version in request: {0}", string));
        }
        if (!(string4 = string4.substring(5)).equals("1.0") && !string4.equals("1.1")) {
            throw new DecodeException(I18N.get("HTTP version must be 1.0 or 1.1: {0}", string));
        }
        this.f.setHTTPVersion(string4);
        this.f.setRequest(string2, string3);
    }

    protected void processResponse(String string) throws DecodeException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        if (!(string2 = string2.substring(5)).equals("1.0") && !string2.equals("1.1")) {
            throw new DecodeException(I18N.get("HTTP version must be 1.0 or 1.1: {0}", string));
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new DecodeException(I18N.get("Bad HTTP response (no status code): {0}", string));
        }
        String string3 = stringTokenizer.nextToken();
        int n = -1;
        n = HTTPMessageCodec.b(string3, 10, "integer status code", string);
        int n2 = string.indexOf(string3, 8);
        String string4 = string.substring(n2 + string3.length());
        this.f.setHTTPVersion(string2);
        this.f.setResponse(n, string4);
    }

    private static int b(String string, int n, String string2, String string3) throws DecodeException {
        try {
            return Integer.parseInt(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DecodeException(I18N.get("Bad {0}: {1}", (Object)string2, (Object)string3));
        }
    }

    protected void readHeaders(int n) throws DecodeException, ProtocolException, IOException, TimeoutException, InterruptedException {
        if (this.p) {
            return;
        }
        this.readHeadersUntilEmptyLine(n);
        this.p = true;
        this.d = null;
    }

    protected void readHeadersUntilEmptyLine(int n) throws DecodeException, ProtocolException, IOException, TimeoutException, InterruptedException {
        while (true) {
            String string;
            if ((string = this.readLine(n)) == null) {
                throw new ProtocolException(I18N.get("Unexpected EOF while reading HTTP headers"));
            }
            if (string.length() == 0) break;
            if (string.charAt(0) == ' ' || string.charAt(0) == '\t') {
                if (this.d == null) {
                    throw new DecodeException(I18N.get("Missing HTTP header name: {0}", string));
                }
                this.c = this.c + " " + string.trim();
                continue;
            }
            int n2 = string.indexOf(":");
            if (n2 == -1) {
                throw new DecodeException(I18N.get("Unable to parse HTTP header: {0}", string));
            }
            if (this.d != null) {
                this.addHeader(this.d, this.c);
            }
            this.d = string.substring(0, n2).trim();
            this.c = string.substring(n2 + 1).trim();
        }
        if (this.d != null) {
            this.addHeader(this.d, this.c);
        }
    }

    protected void addHeader(String string, String string2) throws DecodeException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            try {
                this.f.addHeader(string, string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DecodeException(illegalArgumentException.getMessage());
            }
        }
    }

    protected void readContent(int n) throws DecodeException, ProtocolException, IOException, TimeoutException, InterruptedException {
        int n2;
        String string;
        if (this.i) {
            return;
        }
        if (this.h == null && !this.l) {
            string = this.f.getSingleHeaderValue("Transfer-Encoding");
            if (string != null) {
                if (!string.equalsIgnoreCase("chunked")) {
                    throw new ProtocolException(I18N.get("Unsupported Transfer-Encoding: {0}", string));
                }
                this.l = true;
                this.n = 1;
                this.f.removeHeader("Transfer-Encoding");
            } else {
                String string2 = this.f.getSingleHeaderValue("Content-Length");
                if (string2 == null) {
                    this.readContentToEOF(n);
                    this.i = true;
                    this.t = true;
                    return;
                }
                n2 = HTTPMessageCodec.b(string2, 10, "HTTP Content-Length header", string2);
                if (n2 < 0) {
                    throw new DecodeException(I18N.get("Bad HTTP Content-Length header: {0}", string2));
                }
                this.f.setContentLength(n2);
                this.h = this.f.getContent();
                this.x = 0;
            }
        }
        if (this.h != null) {
            int n3 = this.h.length - this.x;
            int n4 = this.b(this.h, n3, n, false);
            this.i = true;
            this.t = true;
            return;
        }
        block6: while (this.l) {
            switch (this.n) {
                case 1: {
                    string = this.readLine(n).trim();
                    if (string == null) {
                        throw new ProtocolException(I18N.get("Unexpected EOF while reading chunk length"));
                    }
                    int n5 = string.indexOf(";");
                    if (n5 != -1) {
                        string = string.substring(0, n5);
                    }
                    if ((n2 = HTTPMessageCodec.b(string, 16, "chunk size", string)) < 0) {
                        throw new DecodeException(I18N.get("Negative chunk size: {0}", string));
                    }
                    if (n2 == 0) {
                        this.n = 4;
                        continue block6;
                    }
                    this.s = new byte[n2];
                    this.x = 0;
                    this.n = 2;
                    continue block6;
                }
                case 2: {
                    int n6 = this.s.length - this.x;
                    int n7 = this.b(this.s, n6, n, false);
                    this.j.write(this.s, 0, this.x);
                    this.s = null;
                    this.n = 3;
                    continue block6;
                }
                case 3: {
                    if (this.readLine(n) == null) {
                        throw new ProtocolException(I18N.get("Unexpected EOF while reading chunk data crlf"));
                    }
                    this.n = 1;
                    continue block6;
                }
                case 4: {
                    this.readHeadersUntilEmptyLine(n);
                    this.b();
                    this.l = false;
                    this.i = true;
                    this.t = true;
                    continue block6;
                }
            }
            throw new IllegalStateException(I18N.get("Unknown state: {0}", this.n));
        }
    }

    private void b() {
        byte[] byArray = this.j.toByteArray();
        this.f.setContentLength(byArray.length);
        System.arraycopy(byArray, 0, this.f.getContent(), 0, byArray.length);
    }

    private int b(byte[] byArray, int n, int n2, boolean bl) throws IOException, ProtocolException, TimeoutException, InterruptedException {
        int n3 = 0;
        try {
            if (n > 0) {
                n3 = this.b.read(byArray, this.x, n, n2);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.x += socketTimeoutException.bytesTransferred;
            throw new TimeoutException(I18N.get("Timeout reading HTTP message content"), socketTimeoutException);
        }
        catch (InterruptedIOException interruptedIOException) {
            this.x += interruptedIOException.bytesTransferred;
            throw (InterruptedException)new InterruptedException().initCause(interruptedIOException);
        }
        this.x += n3;
        if (n3 < n && !bl) {
            throw new ProtocolException(I18N.get("Unexpected EOF while processing message content"));
        }
        return n3;
    }

    protected void readContentToEOF(int n) throws IOException, ProtocolException, TimeoutException, InterruptedException {
        int n2;
        int n3;
        if (this.s == null) {
            this.s = new byte[4096];
            this.x = 0;
        }
        do {
            n2 = this.s.length - this.x;
            n3 = this.b(this.s, n2, n, true);
            this.j.write(this.s, 0, this.x);
            this.x = 0;
        } while (n3 >= n2);
        this.b();
        this.s = null;
    }

    protected String readLine(int n) throws ProtocolException, IOException, TimeoutException, InterruptedException {
        byte[] byArray = new byte[1];
        while (true) {
            try {
                if (this.b.read(byArray, 0, 1, n) == 0) {
                    if (this.v.length() == 0) {
                        return null;
                    }
                    throw new ProtocolException(I18N.get("Unexpected EOF while reading HTTP header line"));
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw new TimeoutException(I18N.get("Timeout reading HTTP header"), socketTimeoutException);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw (InterruptedException)new InterruptedException().initCause(interruptedIOException);
            }
            char c = (char)byArray[0];
            if (c == '\r') continue;
            if (c == '\n') break;
            this.v.append(c);
        }
        String string = this.v.toString();
        this.v.setLength(0);
        return string;
    }
}

