/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.httpMessage;

import com.connecterra.httpMessage.ProtocolException;
import com.connecterra.i18n.I18N;
import com.connecterra.util.ByteDisplay;
import com.connecterra.util.CaseInsensitiveString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HTTPMessage {
    private String c = "1.1";
    private String b = null;
    private String e = null;
    private int h = -1;
    private String d = null;
    private Map g = new HashMap();
    private byte[] f = new byte[0];

    public String getHTTPVersion() {
        return this.c;
    }

    public void setHTTPVersion(String string) {
        if (!"1.0".equals(string) && !"1.1".equals(string)) {
            throw new IllegalArgumentException(I18N.get("Bad HTTP version: {0}", string));
        }
        this.c = string;
    }

    public String getRequestMethod() {
        return this.b;
    }

    public String getRequestURI() {
        return this.e;
    }

    public void setRequest(String string, String string2) {
        if (string == null) {
            throw new NullPointerException(I18N.get("Null method arg."));
        }
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException(I18N.get("Must supply URI with request method: {0}", string));
        }
        this.b = string;
        this.e = string2;
        this.h = -1;
        this.d = null;
    }

    public int getResponseCode() {
        return this.h;
    }

    public String getResponseText() {
        return this.d;
    }

    public void setResponse(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException(I18N.get("Invalid response code: {0}", n));
        }
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Got null response text"));
        }
        if ((string = string.trim()).indexOf("\n") != -1) {
            throw new IllegalArgumentException(I18N.get("Response text contains embedded newline: {0}", string));
        }
        this.h = n;
        this.d = string;
        this.b = null;
        this.e = null;
    }

    public List getHeaderValues(String string) {
        return (List)this.g.get(new CaseInsensitiveString(string));
    }

    public String getSingleHeaderValue(String string) throws ProtocolException {
        List list = this.getHeaderValues(string);
        if (list == null) {
            return null;
        }
        if (list.size() != 1) {
            throw new ProtocolException(I18N.get("Header has {0} values", list.size()));
        }
        return (String)list.get(0);
    }

    public boolean hasHeaderValue(String string, String string2) {
        string2 = string2.trim();
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        List list = (List)this.g.get(caseInsensitiveString);
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string3 = (String)list.get(i);
            if (!string3.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public List getHeaderNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.g.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((CaseInsensitiveString)iterator.next()).toString());
        }
        return arrayList;
    }

    public void setHeader(String string, String string2) {
        HTTPMessage.d(string);
        HTTPMessage.b(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2.trim());
        this.g.put(new CaseInsensitiveString(string), arrayList);
    }

    public void addHeader(String string, String string2) {
        HTTPMessage.d(string);
        HTTPMessage.b(string2);
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        ArrayList<String> arrayList = (ArrayList<String>)this.g.get(caseInsensitiveString);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.add(string2.trim());
        this.g.put(caseInsensitiveString, arrayList);
    }

    public void removeHeaderValue(String string, String string2) {
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        List list = (List)this.g.get(caseInsensitiveString);
        if (list == null) {
            return;
        }
        string2 = string2.trim();
        int n = 0;
        while (n < list.size()) {
            String string3 = (String)list.get(n);
            if (string3.equalsIgnoreCase(string2)) {
                list.remove(n);
                continue;
            }
            ++n;
        }
        if (list.size() == 0) {
            this.g.remove(caseInsensitiveString);
        }
    }

    public void removeHeader(String string) {
        this.g.remove(new CaseInsensitiveString(string));
    }

    public void setBasicAuthorizationHeader(String string, String string2, String string3) {
        if (!string.equalsIgnoreCase("Proxy-Authorization") && !string.equalsIgnoreCase("Authorization")) {
            throw new IllegalArgumentException(I18N.get("Bad headerName: {0}", string));
        }
        this.setHeader(string, "Basic " + this.c(string2 + ":" + string3));
    }

    private String c(String string) {
        throw new UnsupportedOperationException(I18N.get("No base64 support"));
    }

    private static void d(String string) {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Null headerName"));
        }
        if (string.equals("")) {
            throw new IllegalArgumentException(I18N.get("Empty headerName"));
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isISOControl(c)) {
                throw new IllegalArgumentException(I18N.get("Invalid control character '{0}' (decimal) in headerName: {1}", (int)c, (Object)string));
            }
            if ("()<>@,;:\\\"/[]?={} \n".indexOf(c) == -1) continue;
            throw new IllegalArgumentException(I18N.get("Invalid character '{0}' in headerName: {1}", (int)c, (Object)string));
        }
    }

    private static void b(String string) {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Null headerValue"));
        }
        if (string.indexOf("\n") != -1) {
            throw new IllegalArgumentException(I18N.get("Header value contains embedded newline: {0}", string));
        }
    }

    public byte[] getContent() {
        return this.f;
    }

    public void setContentLength(int n) {
        this.f = new byte[n];
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("httpVersion: " + this.c);
        stringBuffer.append("; requestMethod: " + this.b);
        stringBuffer.append("; requestURI: " + this.e);
        stringBuffer.append("; responseCode: " + this.h);
        stringBuffer.append("; responseText: " + this.d);
        stringBuffer.append("; headers: " + this.g);
        if (n != 0) {
            if (this.f.length <= n || n == -1) {
                stringBuffer.append("; content: " + ByteDisplay.displayBytes(this.f));
            } else {
                stringBuffer.append("; content: " + ByteDisplay.displayBytes(this.f, 0, n));
                stringBuffer.append(" [truncated]");
            }
        }
        return stringBuffer.toString();
    }
}

