/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.httpMessage;

import com.connecterra.httpMessage.DecodeException;
import com.connecterra.httpMessage.HTTPMessage;
import com.connecterra.httpMessage.HTTPMessageCodec;
import com.connecterra.httpMessage.ProtocolException;
import com.connecterra.httpMessage.TimeoutException;
import com.connecterra.i18n.I18N;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class HTTPConnection {
    private static Logger d = Logger.getLogger("com.connecterra.httpMessage.HTTPConnection");
    private HTTPMessageCodec b = null;
    private boolean c = false;
    private long e = System.currentTimeMillis();

    protected HTTPConnection(HTTPMessageCodec hTTPMessageCodec) {
        if (hTTPMessageCodec == null) {
            throw new NullPointerException(I18N.get("Null msgCodec arg."));
        }
        this.b = hTTPMessageCodec;
    }

    public HTTPMessageCodec getCodec() {
        return this.b;
    }

    public long getTimeLastActive() {
        return this.e;
    }

    protected void sendHTTP(HTTPMessage hTTPMessage, int n) throws IOException, TimeoutException, InterruptedException {
        if (this.isClosed()) {
            throw new IllegalStateException(I18N.get("HTTP connection has been closed"));
        }
        try {
            this.b.writeMessage(hTTPMessage, n);
            this.e = System.currentTimeMillis();
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.close();
            throw runtimeException;
        }
        catch (TimeoutException timeoutException) {
            throw timeoutException;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
    }

    protected void finishInterrupted(int n) throws IOException, TimeoutException, InterruptedException {
        try {
            this.b.finishInterruptedWrite(n);
            this.e = System.currentTimeMillis();
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.close();
            throw runtimeException;
        }
        catch (TimeoutException timeoutException) {
            throw timeoutException;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
    }

    protected HTTPMessage receiveHTTP(int n) throws DecodeException, ProtocolException, IOException, TimeoutException, InterruptedException {
        if (this.isClosed()) {
            throw new IllegalStateException(I18N.get("Client has been closed"));
        }
        HTTPMessage hTTPMessage = null;
        try {
            hTTPMessage = this.b.readMessage(n);
            this.e = System.currentTimeMillis();
            if (hTTPMessage == null) {
                this.close();
            }
            return hTTPMessage;
        }
        catch (DecodeException decodeException) {
            this.close();
            throw decodeException;
        }
        catch (ProtocolException protocolException) {
            this.close();
            throw protocolException;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.close();
            throw runtimeException;
        }
        catch (TimeoutException timeoutException) {
            throw timeoutException;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
    }

    protected boolean isRequestingPersistent(HTTPMessage hTTPMessage) {
        if (hTTPMessage.getHTTPVersion().equals("1.1")) {
            return !hTTPMessage.hasHeaderValue("Connection", "close");
        }
        return hTTPMessage.hasHeaderValue("Connection", "Keep-Alive");
    }

    protected void clearRequestPersistent(HTTPMessage hTTPMessage) {
        hTTPMessage.removeHeader("Keep-Alive");
        hTTPMessage.removeHeaderValue("Connection", "Keep-Alive");
        hTTPMessage.removeHeaderValue("Connection", "close");
        if (hTTPMessage.getHTTPVersion().equals("1.1")) {
            hTTPMessage.addHeader("Connection", "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.c) {
            return;
        }
        try {
            d.fine("Closing connection");
            this.b.getStream().close();
        }
        finally {
            this.c = true;
        }
    }

    public boolean isClosed() {
        return this.c;
    }
}

