/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.alepc.client;

import com.connecterra.ale.api.DuplicateNameException;
import com.connecterra.ale.api.EngineException;
import com.connecterra.ale.api.NoSuchSubscriberException;
import com.connecterra.alepc.api.ALEPC;
import com.connecterra.alepc.api.ALEPCFactory;
import com.connecterra.alepc.api.CacheInUseException;
import com.connecterra.alepc.api.EPCCacheSpec;
import com.connecterra.alepc.api.EPCPatterns;
import com.connecterra.alepc.api.PCSpec;
import com.connecterra.alepc.api.PCSpecValidationException;
import com.connecterra.alepc.api.PCSubscriptionControls;
import com.connecterra.alepc.api.PCSubscriptionInfo;
import com.connecterra.alepc.api.PCWriteReport;
import com.connecterra.alepc.axis.AxisALEPCFactory;
import com.connecterra.alepc.axis.adapters.EPCCacheSpecAdapter;
import com.connecterra.alepc.axis.adapters.EPCCacheSpecInfoAdapter;
import com.connecterra.alepc.axis.adapters.EPCPatternsAdapter;
import com.connecterra.alepc.axis.adapters.PCSpecAdapter;
import com.connecterra.alepc.axis.adapters.PCSpecInfoAdapter;
import com.connecterra.alepc.axis.adapters.PCSubscriptionControlsAdapter;
import com.connecterra.alepc.axis.adapters.PCSubscriptionInfoAdapter;
import com.connecterra.alepc.axis.adapters.PCWriteReportAdapter;
import com.connecterra.alepc.axis.schema.EPCCacheSpecInfo;
import com.connecterra.alepc.axis.schema.PCSpecInfo;
import com.connecterra.alepc.axis.service.ALEPCServiceBindingStub;
import com.connecterra.alepc.axis.service.ALEPCServiceLocator;
import com.connecterra.alepc.axis.service.ALEPCServicePortType;
import com.connecterra.alepc.axis.service.ArrayOfString;
import com.connecterra.alepc.axis.service.CacheSpecValidationException;
import com.connecterra.alepc.axis.service.Define;
import com.connecterra.alepc.axis.service.DefineEPCCache;
import com.connecterra.alepc.axis.service.DepleteEPCCache;
import com.connecterra.alepc.axis.service.EmptyParms;
import com.connecterra.alepc.axis.service.Get;
import com.connecterra.alepc.axis.service.GetEPCCache;
import com.connecterra.alepc.axis.service.GetEPCCacheSpecInfo;
import com.connecterra.alepc.axis.service.GetEPCCacheSubscriptionInfo;
import com.connecterra.alepc.axis.service.GetPCSpecInfo;
import com.connecterra.alepc.axis.service.GetPCSubscriptionInfo;
import com.connecterra.alepc.axis.service.Immediate;
import com.connecterra.alepc.axis.service.ImmediateWithParams;
import com.connecterra.alepc.axis.service.InvalidPatternsException;
import com.connecterra.alepc.axis.service.InvalidURIException;
import com.connecterra.alepc.axis.service.ListEPCCacheSubscribers;
import com.connecterra.alepc.axis.service.ListSubscribers;
import com.connecterra.alepc.axis.service.NoSuchCacheException;
import com.connecterra.alepc.axis.service.NoSuchSpecException;
import com.connecterra.alepc.axis.service.Parameter;
import com.connecterra.alepc.axis.service.ParameterMap;
import com.connecterra.alepc.axis.service.Poll;
import com.connecterra.alepc.axis.service.PollWithParams;
import com.connecterra.alepc.axis.service.Redefine;
import com.connecterra.alepc.axis.service.RedefineEPCCache;
import com.connecterra.alepc.axis.service.ReplenishEPCCache;
import com.connecterra.alepc.axis.service.Subscribe;
import com.connecterra.alepc.axis.service.SubscribeEPCCache;
import com.connecterra.alepc.axis.service.Suspend;
import com.connecterra.alepc.axis.service.Undefine;
import com.connecterra.alepc.axis.service.UndefineEPCCache;
import com.connecterra.alepc.axis.service.Unsubscribe;
import com.connecterra.alepc.axis.service.UnsubscribeEPCCache;
import com.connecterra.alepc.axis.service.Unsuspend;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.ServiceException;

public class AxisALEPCClient
implements ALEPC {
    private static Logger b = Logger.getLogger("com.connecterra.alepc.client.AxisALEPCClient");
    private ALEPCServicePortType c;

    public AxisALEPCClient(URL uRL) throws RemoteException {
        if (uRL == null) {
            throw new IllegalArgumentException(I18N.get("Specified ALE EPC Programming Service URL is null"));
        }
        Logger logger = Logger.getLogger("org.apache.axis");
        logger.setLevel(Level.OFF);
        b.fine("Instantiating locator");
        ALEPCServiceLocator aLEPCServiceLocator = new ALEPCServiceLocator();
        b.fine("Connecting to ALEPCService at " + uRL + "...");
        try {
            this.c = aLEPCServiceLocator.getALEPCService(uRL);
        }
        catch (ServiceException serviceException) {
            throw new RemoteException(serviceException.getMessage(), serviceException);
        }
        this.setTimeout(600000L);
        b.fine("Connection established to ALEPCService.");
    }

    public void setTimeout(long l) {
        ((ALEPCServiceBindingStub)this.c).setTimeout((int)l);
    }

    public long getTimeout() {
        return ((ALEPCServiceBindingStub)this.c).getTimeout();
    }

    public ALEPCFactory getALEPCFactory() {
        return AxisALEPCFactory.getInstance();
    }

    public String getALEID() throws RemoteException, EngineException {
        try {
            b.fine("Invoking ALEPCService.getALEID...");
            return this.c.getALEID(new EmptyParms()).getALEID();
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void define(String string, PCSpec pCSpec) throws DuplicateNameException, PCSpecValidationException, com.connecterra.alepc.api.NoSuchCacheException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        if (pCSpec == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec is null."));
        }
        Define define = new Define();
        define.setSpecName(string);
        define.setSpec(PCSpecAdapter.aleToAxis(pCSpec));
        try {
            b.fine("Invoking ALEPCService.define...");
            this.c.define(define);
            b.fine("Returned from ALEPCService.define.");
        }
        catch (com.connecterra.alepc.axis.service.DuplicateNameException duplicateNameException) {
            throw new DuplicateNameException(duplicateNameException.getReason(), duplicateNameException);
        }
        catch (com.connecterra.alepc.axis.service.PCSpecValidationException pCSpecValidationException) {
            throw new PCSpecValidationException(pCSpecValidationException.getReason(), pCSpecValidationException);
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void redefine(String string, PCSpec pCSpec) throws com.connecterra.alepc.api.NoSuchSpecException, PCSpecValidationException, com.connecterra.alepc.api.NoSuchCacheException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        if (pCSpec == null) {
            throw new IllegalArgumentException("Specified PCSpec is null.");
        }
        Redefine redefine = new Redefine();
        redefine.setSpecName(string);
        redefine.setNewSpec(PCSpecAdapter.aleToAxis(pCSpec));
        try {
            b.fine("Invoking ALEPCService.redefine...");
            this.c.redefine(redefine);
            b.fine("Returned from ALEPCService.redefine.");
        }
        catch (NoSuchSpecException noSuchSpecException) {
            throw new com.connecterra.alepc.api.NoSuchSpecException(noSuchSpecException.getReason(), noSuchSpecException);
        }
        catch (com.connecterra.alepc.axis.service.PCSpecValidationException pCSpecValidationException) {
            throw new PCSpecValidationException(pCSpecValidationException.getReason(), pCSpecValidationException);
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void suspend(String string) throws com.connecterra.alepc.api.NoSuchSpecException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        Suspend suspend = new Suspend();
        suspend.setSpecName(string);
        try {
            b.fine("Invoking ALEPCService.suspend...");
            this.c.suspend(suspend);
            b.fine("Returned from ALEPCService.suspend.");
        }
        catch (NoSuchSpecException noSuchSpecException) {
            throw new com.connecterra.alepc.api.NoSuchSpecException(noSuchSpecException.getReason(), noSuchSpecException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void unsuspend(String string) throws com.connecterra.alepc.api.NoSuchSpecException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified PCSpec name is null.");
        }
        Unsuspend unsuspend = new Unsuspend();
        unsuspend.setSpecName(string);
        try {
            b.fine("Invoking ALEPCService.unsuspend...");
            this.c.unsuspend(unsuspend);
            b.fine("Returned from ALEPCService.unsuspend.");
        }
        catch (NoSuchSpecException noSuchSpecException) {
            throw new com.connecterra.alepc.api.NoSuchSpecException(noSuchSpecException.getReason(), noSuchSpecException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void undefine(String string) throws com.connecterra.alepc.api.NoSuchSpecException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        Undefine undefine = new Undefine();
        undefine.setSpecName(string);
        try {
            b.fine("Invoking ALEPCService.undefine...");
            this.c.undefine(undefine);
            b.fine("Returned from ALEPCService.undefine.");
        }
        catch (NoSuchSpecException noSuchSpecException) {
            throw new com.connecterra.alepc.api.NoSuchSpecException(noSuchSpecException.getReason(), noSuchSpecException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public PCSpec get(String string) throws RemoteException, EngineException {
        com.connecterra.alepc.axis.schema.PCSpec pCSpec;
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        Get get = new Get();
        get.setSpecName(string);
        try {
            b.fine("Invoking ALEPCService.get...");
            pCSpec = this.c.get(get);
            b.fine("Returned from ALEPCService.get.");
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        if (pCSpec == null) {
            return null;
        }
        try {
            return PCSpecAdapter.axisToALE(pCSpec);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
        catch (PCSpecValidationException pCSpecValidationException) {
            throw new RemoteException(pCSpecValidationException.getMessage(), pCSpecValidationException);
        }
    }

    public com.connecterra.alepc.api.PCSpecInfo getPCSpecInfo(String string) throws com.connecterra.alepc.api.NoSuchSpecException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        GetPCSpecInfo getPCSpecInfo = new GetPCSpecInfo();
        getPCSpecInfo.setSpecName(string);
        PCSpecInfo pCSpecInfo = null;
        try {
            b.fine("Invoking ALEPCService.getPCSpecInfo...");
            pCSpecInfo = this.c.getPCSpecInfo(getPCSpecInfo);
            b.fine("Returned from ALEPCService.getPCSpecInfo.");
        }
        catch (NoSuchSpecException noSuchSpecException) {
            throw new com.connecterra.alepc.api.NoSuchSpecException(noSuchSpecException.getReason(), noSuchSpecException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        return PCSpecInfoAdapter.axisToALE(pCSpecInfo);
    }

    public List listPCSpecNames() throws RemoteException, EngineException {
        ArrayOfString arrayOfString;
        try {
            b.fine("Calling ALEPCService.listPCSpecNames...");
            arrayOfString = this.c.listPCSpecNames(new EmptyParms());
            b.fine("Returned from ALEPCService.listPCSpecNames.");
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        return AxisALEPCClient.c(arrayOfString);
    }

    public void subscribe(String string, URI uRI, PCSubscriptionControls pCSubscriptionControls) throws com.connecterra.alepc.api.NoSuchSpecException, com.connecterra.ale.api.InvalidURIException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified URI is null."));
        }
        Subscribe subscribe = new Subscribe();
        subscribe.setSpecName(string);
        subscribe.setNotificationURI(uRI.toString());
        subscribe.setControls(PCSubscriptionControlsAdapter.aleToAxis(pCSubscriptionControls));
        try {
            b.fine("Invoking ALEPCService.subscribe...");
            this.c.subscribe(subscribe);
            b.fine("Returned from ALEPCService.subscribe.");
        }
        catch (NoSuchSpecException noSuchSpecException) {
            throw new com.connecterra.alepc.api.NoSuchSpecException(noSuchSpecException.getReason(), noSuchSpecException);
        }
        catch (InvalidURIException invalidURIException) {
            throw new com.connecterra.ale.api.InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void unsubscribe(String string, URI uRI) throws com.connecterra.alepc.api.NoSuchSpecException, NoSuchSubscriberException, com.connecterra.ale.api.InvalidURIException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified URI is null."));
        }
        Unsubscribe unsubscribe = new Unsubscribe();
        unsubscribe.setSpecName(string);
        unsubscribe.setNotificationURI(uRI.toString());
        try {
            b.fine("Invoking ALEPCService.unsubscribe...");
            this.c.unsubscribe(unsubscribe);
            b.fine("Returned from ALEPCService.unsubscribe.");
        }
        catch (NoSuchSpecException noSuchSpecException) {
            throw new com.connecterra.alepc.api.NoSuchSpecException(noSuchSpecException.getReason(), noSuchSpecException);
        }
        catch (com.connecterra.alepc.axis.service.NoSuchSubscriberException noSuchSubscriberException) {
            throw new NoSuchSubscriberException(noSuchSubscriberException.getReason(), noSuchSubscriberException);
        }
        catch (InvalidURIException invalidURIException) {
            throw new com.connecterra.ale.api.InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public List listSubscribers(String string) throws com.connecterra.alepc.api.NoSuchSpecException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        ListSubscribers listSubscribers = new ListSubscribers();
        listSubscribers.setSpecName(string);
        ArrayOfString arrayOfString = null;
        try {
            b.fine("Calling ALEPCService.listSubscribers...");
            arrayOfString = this.c.listSubscribers(listSubscribers);
            b.fine("Returned from ALEPCService.listSubscribers.");
        }
        catch (NoSuchSpecException noSuchSpecException) {
            throw new com.connecterra.alepc.api.NoSuchSpecException(noSuchSpecException.getReason(), noSuchSpecException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        try {
            return AxisALEPCClient.b(arrayOfString);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public PCSubscriptionInfo getPCSubscriptionInfo(String string, URI uRI) throws com.connecterra.alepc.api.NoSuchSpecException, NoSuchSubscriberException, com.connecterra.ale.api.InvalidURIException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified subscriber URI is null."));
        }
        GetPCSubscriptionInfo getPCSubscriptionInfo = new GetPCSubscriptionInfo();
        getPCSubscriptionInfo.setSpecName(string);
        getPCSubscriptionInfo.setSubscriber(uRI.toString());
        com.connecterra.alepc.axis.schema.PCSubscriptionInfo pCSubscriptionInfo = null;
        try {
            b.fine("Invoking ALEPCService.getPCSubscriptionInfo...");
            pCSubscriptionInfo = this.c.getPCSubscriptionInfo(getPCSubscriptionInfo);
            b.fine("Returned from ALEPCService.getPCSubscriptionInfo.");
        }
        catch (NoSuchSpecException noSuchSpecException) {
            throw new com.connecterra.alepc.api.NoSuchSpecException(noSuchSpecException.getReason(), noSuchSpecException);
        }
        catch (com.connecterra.alepc.axis.service.NoSuchSubscriberException noSuchSubscriberException) {
            throw new NoSuchSubscriberException(noSuchSubscriberException.getReason(), noSuchSubscriberException);
        }
        catch (InvalidURIException invalidURIException) {
            throw new com.connecterra.ale.api.InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        return PCSubscriptionInfoAdapter.axisToALE(pCSubscriptionInfo);
    }

    public PCWriteReport poll(String string) throws com.connecterra.ale.api.InvalidURIException, InterruptedException, com.connecterra.alepc.api.NoSuchSpecException, com.connecterra.alepc.api.NoSuchCacheException, RemoteException, EngineException {
        return this.poll(string, (URI)null);
    }

    public PCWriteReport poll(String string, URI uRI) throws com.connecterra.ale.api.InvalidURIException, InterruptedException, com.connecterra.alepc.api.NoSuchSpecException, com.connecterra.alepc.api.NoSuchCacheException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        Poll poll = new Poll();
        poll.setSpecName(string);
        poll.setEpcVal(uRI == null ? null : uRI.toString());
        com.connecterra.alepc.axis.schema.PCWriteReport pCWriteReport = null;
        try {
            b.fine("Invoking ALEPCService.poll...");
            pCWriteReport = this.c.poll(poll);
            b.fine("Returned from ALEPCService.poll.");
        }
        catch (InvalidURIException invalidURIException) {
            throw new com.connecterra.ale.api.InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (NoSuchSpecException noSuchSpecException) {
            throw new com.connecterra.alepc.api.NoSuchSpecException(noSuchSpecException.getReason(), noSuchSpecException);
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        try {
            return PCWriteReportAdapter.axisToALE(pCWriteReport);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public PCWriteReport poll(String string, Map map) throws com.connecterra.ale.api.InvalidURIException, InterruptedException, com.connecterra.alepc.api.NoSuchSpecException, com.connecterra.alepc.api.NoSuchCacheException, RemoteException, EngineException {
        Parameter[] parameterArray;
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        PollWithParams pollWithParams = new PollWithParams();
        pollWithParams.setSpecName(string);
        if (map != null) {
            parameterArray = new Parameter[map.size()];
            int n = 0;
            for (String string2 : map.keySet()) {
                Parameter parameter = new Parameter(string2, (String)map.get(string2));
                parameterArray[n++] = parameter;
            }
            ParameterMap parameterMap = new ParameterMap(parameterArray);
            pollWithParams.setParams(parameterMap);
        }
        parameterArray = null;
        try {
            b.fine("Invoking ALEPCService.poll...");
            parameterArray = this.c.pollWithParams(pollWithParams);
            b.fine("Returned from ALEPCService.poll.");
        }
        catch (InvalidURIException invalidURIException) {
            throw new com.connecterra.ale.api.InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (NoSuchSpecException noSuchSpecException) {
            throw new com.connecterra.alepc.api.NoSuchSpecException(noSuchSpecException.getReason(), noSuchSpecException);
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        try {
            return PCWriteReportAdapter.axisToALE((com.connecterra.alepc.axis.schema.PCWriteReport)parameterArray);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public PCWriteReport immediate(PCSpec pCSpec) throws com.connecterra.ale.api.InvalidURIException, InterruptedException, PCSpecValidationException, com.connecterra.alepc.api.NoSuchCacheException, RemoteException, EngineException {
        return this.immediate(pCSpec, (URI)null);
    }

    public PCWriteReport immediate(PCSpec pCSpec, URI uRI) throws com.connecterra.ale.api.InvalidURIException, InterruptedException, PCSpecValidationException, com.connecterra.alepc.api.NoSuchCacheException, RemoteException, EngineException {
        if (pCSpec == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        Immediate immediate = new Immediate();
        immediate.setSpec(PCSpecAdapter.aleToAxis(pCSpec));
        immediate.setEpcVal(uRI == null ? null : uRI.toString());
        com.connecterra.alepc.axis.schema.PCWriteReport pCWriteReport = null;
        try {
            b.fine("Invoking ALEPCService.immediate...");
            pCWriteReport = this.c.immediate(immediate);
            b.fine("Returned from ALEPCService.immediate.");
        }
        catch (InvalidURIException invalidURIException) {
            throw new com.connecterra.ale.api.InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (com.connecterra.alepc.axis.service.PCSpecValidationException pCSpecValidationException) {
            throw new PCSpecValidationException(pCSpecValidationException.getReason(), pCSpecValidationException);
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        try {
            return PCWriteReportAdapter.axisToALE(pCWriteReport);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public PCWriteReport immediate(PCSpec pCSpec, Map map) throws com.connecterra.ale.api.InvalidURIException, InterruptedException, PCSpecValidationException, com.connecterra.alepc.api.NoSuchCacheException, RemoteException, EngineException {
        Parameter[] parameterArray;
        if (pCSpec == null) {
            throw new IllegalArgumentException(I18N.get("Specified PCSpec name is null."));
        }
        ImmediateWithParams immediateWithParams = new ImmediateWithParams();
        immediateWithParams.setSpec(PCSpecAdapter.aleToAxis(pCSpec));
        if (map != null) {
            parameterArray = new Parameter[map.size()];
            int n = 0;
            for (String string : map.keySet()) {
                Parameter parameter = new Parameter(string, (String)map.get(string));
                parameterArray[n++] = parameter;
            }
            ParameterMap parameterMap = new ParameterMap(parameterArray);
            immediateWithParams.setParams(parameterMap);
        }
        parameterArray = null;
        try {
            b.fine("Invoking ALEPCService.immediate...");
            parameterArray = this.c.immediateWithParams(immediateWithParams);
            b.fine("Returned from ALEPCService.immediate.");
        }
        catch (InvalidURIException invalidURIException) {
            throw new com.connecterra.ale.api.InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (com.connecterra.alepc.axis.service.PCSpecValidationException pCSpecValidationException) {
            throw new PCSpecValidationException(pCSpecValidationException.getReason(), pCSpecValidationException);
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        try {
            return PCWriteReportAdapter.axisToALE((com.connecterra.alepc.axis.schema.PCWriteReport)parameterArray);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public void defineEPCCache(String string, EPCCacheSpec ePCCacheSpec, EPCPatterns ePCPatterns) throws DuplicateNameException, com.connecterra.alepc.api.CacheSpecValidationException, com.connecterra.alepc.api.InvalidPatternsException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified cache name is null."));
        }
        if (ePCCacheSpec == null) {
            throw new IllegalArgumentException(I18N.get("Specified EPCCacheSpec is null."));
        }
        DefineEPCCache defineEPCCache = new DefineEPCCache();
        defineEPCCache.setCacheName(string);
        defineEPCCache.setSpec(EPCCacheSpecAdapter.aleToAxis(ePCCacheSpec));
        defineEPCCache.setReplenishment(EPCPatternsAdapter.aleToAxis(ePCPatterns));
        try {
            b.fine("Invoking ALEPCService.defineEPCCache...");
            this.c.defineEPCCache(defineEPCCache);
            b.fine("Returned from ALEPCService.defineEPCCache.");
        }
        catch (com.connecterra.alepc.axis.service.DuplicateNameException duplicateNameException) {
            throw new DuplicateNameException(duplicateNameException.getReason(), duplicateNameException);
        }
        catch (CacheSpecValidationException cacheSpecValidationException) {
            throw new com.connecterra.alepc.api.CacheSpecValidationException(cacheSpecValidationException.getReason(), cacheSpecValidationException);
        }
        catch (InvalidPatternsException invalidPatternsException) {
            throw new com.connecterra.alepc.api.InvalidPatternsException(invalidPatternsException.getReason(), invalidPatternsException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void redefineEPCCache(String string, EPCCacheSpec ePCCacheSpec) throws com.connecterra.alepc.api.NoSuchCacheException, com.connecterra.alepc.api.CacheSpecValidationException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified cache name is null."));
        }
        if (ePCCacheSpec == null) {
            throw new IllegalArgumentException(I18N.get("Specified EPCCacheSpec is null."));
        }
        RedefineEPCCache redefineEPCCache = new RedefineEPCCache();
        redefineEPCCache.setCacheName(string);
        redefineEPCCache.setNewSpec(EPCCacheSpecAdapter.aleToAxis(ePCCacheSpec));
        try {
            b.fine("Invoking ALEPCService.redefineEPCCache...");
            this.c.redefineEPCCache(redefineEPCCache);
            b.fine("Returned from ALEPCService.redefineEPCCache.");
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (CacheSpecValidationException cacheSpecValidationException) {
            throw new com.connecterra.alepc.api.CacheSpecValidationException(cacheSpecValidationException.getReason(), cacheSpecValidationException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public EPCPatterns undefineEPCCache(String string) throws com.connecterra.alepc.api.NoSuchCacheException, CacheInUseException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified cache name is null."));
        }
        UndefineEPCCache undefineEPCCache = new UndefineEPCCache();
        undefineEPCCache.setCacheName(string);
        com.connecterra.alepc.axis.schema.EPCPatterns ePCPatterns = null;
        try {
            b.fine("Invoking ALEPCService.undefineEPCCache...");
            ePCPatterns = this.c.undefineEPCCache(undefineEPCCache);
            b.fine("Returned from ALEPCService.undefineEPCCache.");
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        try {
            return EPCPatternsAdapter.axisToALE(ePCPatterns);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public EPCCacheSpec getEPCCache(String string) throws RemoteException, EngineException {
        com.connecterra.alepc.axis.schema.EPCCacheSpec ePCCacheSpec;
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified cache name is null."));
        }
        GetEPCCache getEPCCache = new GetEPCCache();
        getEPCCache.setCacheName(string);
        try {
            b.fine("Invoking ALEPCService.getEPCCache...");
            ePCCacheSpec = this.c.getEPCCache(getEPCCache);
            b.fine("Returned from ALEPCService.getEPCCache.");
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        return EPCCacheSpecAdapter.axisToALE(ePCCacheSpec);
    }

    public com.connecterra.alepc.api.EPCCacheSpecInfo getEPCCacheSpecInfo(String string, boolean bl) throws com.connecterra.alepc.api.NoSuchCacheException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified cache name is null."));
        }
        GetEPCCacheSpecInfo getEPCCacheSpecInfo = new GetEPCCacheSpecInfo();
        getEPCCacheSpecInfo.setCacheName(string);
        getEPCCacheSpecInfo.setIncludeCacheContent(bl);
        EPCCacheSpecInfo ePCCacheSpecInfo = null;
        try {
            b.fine("Invoking ALEPCService.getEPCCacheSpecInfo...");
            ePCCacheSpecInfo = this.c.getEPCCacheSpecInfo(getEPCCacheSpecInfo);
            b.fine("Returned from ALEPCService.getEPCCacheSpecInfo.");
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        try {
            return EPCCacheSpecInfoAdapter.axisToALE(ePCCacheSpecInfo);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public List listEPCCacheSpecNames() throws RemoteException, EngineException {
        ArrayOfString arrayOfString;
        try {
            b.fine("Calling ALEPCService.listEPCCacheSpecNames...");
            arrayOfString = this.c.listEPCCacheSpecNames(new EmptyParms());
            b.fine("Returned from ALEPCService.listEPCCacheSpecNames.");
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        return AxisALEPCClient.c(arrayOfString);
    }

    public void replenishEPCCache(String string, EPCPatterns ePCPatterns) throws com.connecterra.alepc.api.NoSuchCacheException, com.connecterra.alepc.api.InvalidPatternsException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified cache name is null."));
        }
        if (ePCPatterns == null) {
            throw new IllegalArgumentException(I18N.get("Specified replenishment is null."));
        }
        ReplenishEPCCache replenishEPCCache = new ReplenishEPCCache();
        replenishEPCCache.setCacheName(string);
        replenishEPCCache.setReplenishment(EPCPatternsAdapter.aleToAxis(ePCPatterns));
        try {
            b.fine("Invoking ALEPCService.replenishEPCCache...");
            this.c.replenishEPCCache(replenishEPCCache);
            b.fine("Returned from ALEPCService.replenishEPCCache.");
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (InvalidPatternsException invalidPatternsException) {
            throw new com.connecterra.alepc.api.InvalidPatternsException(invalidPatternsException.getReason(), invalidPatternsException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public EPCPatterns depleteEPCCache(String string) throws com.connecterra.alepc.api.NoSuchCacheException, RemoteException, EngineException {
        com.connecterra.alepc.axis.schema.EPCPatterns ePCPatterns;
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified cache name is null."));
        }
        DepleteEPCCache depleteEPCCache = new DepleteEPCCache();
        depleteEPCCache.setCacheName(string);
        try {
            b.fine("Invoking ALEPCService.depleteEPCCache...");
            ePCPatterns = this.c.depleteEPCCache(depleteEPCCache);
            b.fine("Returned from ALEPCService.depleteEPCCache.");
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        try {
            return EPCPatternsAdapter.axisToALE(ePCPatterns);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public void subscribeEPCCache(String string, URI uRI, PCSubscriptionControls pCSubscriptionControls) throws com.connecterra.alepc.api.NoSuchCacheException, com.connecterra.ale.api.InvalidURIException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified cache name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified URI is null."));
        }
        SubscribeEPCCache subscribeEPCCache = new SubscribeEPCCache();
        subscribeEPCCache.setCacheName(string);
        subscribeEPCCache.setNotificationURI(uRI.toString());
        subscribeEPCCache.setControls(PCSubscriptionControlsAdapter.aleToAxis(pCSubscriptionControls));
        try {
            b.fine("Invoking ALEPCService.subscribeEPCCache...");
            this.c.subscribeEPCCache(subscribeEPCCache);
            b.fine("Returned from ALEPCService.subscribeEPCCache.");
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (InvalidURIException invalidURIException) {
            throw new com.connecterra.ale.api.InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void unsubscribeEPCCache(String string, URI uRI) throws com.connecterra.alepc.api.NoSuchCacheException, NoSuchSubscriberException, com.connecterra.ale.api.InvalidURIException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified cache name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified URI is null."));
        }
        UnsubscribeEPCCache unsubscribeEPCCache = new UnsubscribeEPCCache();
        unsubscribeEPCCache.setCacheName(string);
        unsubscribeEPCCache.setNotificationURI(uRI.toString());
        try {
            b.fine("Invoking ALEPCService.unsubscribeEPCCache...");
            this.c.unsubscribeEPCCache(unsubscribeEPCCache);
            b.fine("Returned from ALEPCService.unsubscribeEPCCache.");
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (com.connecterra.alepc.axis.service.NoSuchSubscriberException noSuchSubscriberException) {
            throw new NoSuchSubscriberException(noSuchSubscriberException.getReason(), noSuchSubscriberException);
        }
        catch (InvalidURIException invalidURIException) {
            throw new com.connecterra.ale.api.InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public List listEPCCacheSubscribers(String string) throws com.connecterra.alepc.api.NoSuchCacheException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified cache name is null."));
        }
        ListEPCCacheSubscribers listEPCCacheSubscribers = new ListEPCCacheSubscribers();
        listEPCCacheSubscribers.setCacheName(string);
        ArrayOfString arrayOfString = null;
        try {
            b.fine("Calling ALEPCService.listEPCCacheSubscribers...");
            arrayOfString = this.c.listEPCCacheSubscribers(listEPCCacheSubscribers);
            b.fine("Returned from ALEPCService.listEPCCacheSubscribers.");
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        try {
            return AxisALEPCClient.b(arrayOfString);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public PCSubscriptionInfo getEPCCacheSubscriptionInfo(String string, URI uRI) throws com.connecterra.alepc.api.NoSuchCacheException, NoSuchSubscriberException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified cache name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified subscriber URI is null."));
        }
        GetEPCCacheSubscriptionInfo getEPCCacheSubscriptionInfo = new GetEPCCacheSubscriptionInfo();
        getEPCCacheSubscriptionInfo.setCacheName(string);
        getEPCCacheSubscriptionInfo.setSubscriber(uRI.toString());
        com.connecterra.alepc.axis.schema.PCSubscriptionInfo pCSubscriptionInfo = null;
        try {
            b.fine("Invoking ALEPCService.getEPCCacheSubscriptionInfo...");
            pCSubscriptionInfo = this.c.getEPCCacheSubscriptionInfo(getEPCCacheSubscriptionInfo);
            b.fine("Returned from ALEPCService.getEPCCacheSubscriptionInfo.");
        }
        catch (NoSuchCacheException noSuchCacheException) {
            throw new com.connecterra.alepc.api.NoSuchCacheException(noSuchCacheException.getReason(), noSuchCacheException);
        }
        catch (com.connecterra.alepc.axis.service.NoSuchSubscriberException noSuchSubscriberException) {
            throw new NoSuchSubscriberException(noSuchSubscriberException.getReason(), noSuchSubscriberException);
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        return PCSubscriptionInfoAdapter.axisToALE(pCSubscriptionInfo);
    }

    public List listLogicalReaderNames() throws RemoteException, EngineException {
        ArrayOfString arrayOfString;
        try {
            b.fine("Calling ALEPCService.listLogicalReaderNames...");
            arrayOfString = this.c.listLogicalReaderNames(new EmptyParms());
            b.fine("Returned from ALEPCService.listLogicalReaderNames.");
        }
        catch (com.connecterra.alepc.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        return AxisALEPCClient.c(arrayOfString);
    }

    private static List c(ArrayOfString arrayOfString) {
        if (arrayOfString == null) {
            return Collections.EMPTY_LIST;
        }
        String[] stringArray = arrayOfString.getString();
        if (stringArray == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(stringArray);
    }

    private static List b(ArrayOfString arrayOfString) throws URISyntaxException {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        if (arrayOfString == null) {
            return arrayList;
        }
        String[] stringArray = arrayOfString.getString();
        if (stringArray == null) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            arrayList.add(new URI(string));
        }
        return arrayList;
    }
}

