/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.alepc.axis.adapters;

import com.connecterra.alepc.api.DataSpec;
import com.connecterra.alepc.api.EPCCacheDataSpec;
import com.connecterra.alepc.api.KillOpSpec;
import com.connecterra.alepc.api.LiteralDataSpec;
import com.connecterra.alepc.api.PCSpecValidationException;
import com.connecterra.alepc.api.ParamDataSpec;
import com.connecterra.alepc.axis.adapters.DataSpecAdapter;
import com.connecterra.alepc.axis.adapters.OpSpecAdapter;
import com.connecterra.alepc.axis.schema.KillOperationSpec;
import java.net.URISyntaxException;

public class KillOpSpecAdapter
implements KillOpSpec,
OpSpecAdapter {
    private KillOperationSpec d;
    private DataSpec c;

    public static KillOperationSpec aleToAxis(KillOpSpec killOpSpec) {
        if (killOpSpec == null) {
            return null;
        }
        if (killOpSpec instanceof KillOpSpecAdapter) {
            return ((KillOpSpecAdapter)killOpSpec).c();
        }
        return new KillOpSpecAdapter(killOpSpec).c();
    }

    public static KillOpSpec axisToALE(KillOperationSpec killOperationSpec) throws URISyntaxException, PCSpecValidationException {
        return killOperationSpec == null ? null : new KillOpSpecAdapter(killOperationSpec);
    }

    public KillOpSpecAdapter(DataSpec dataSpec) {
        this.d = new KillOperationSpec();
        this.c = dataSpec;
        if (dataSpec instanceof LiteralDataSpec) {
            this.d.setLiteral(((LiteralDataSpec)dataSpec).getValue().toString());
        } else if (dataSpec instanceof ParamDataSpec) {
            this.d.setParam(((ParamDataSpec)dataSpec).getParamName());
        } else if (dataSpec instanceof EPCCacheDataSpec) {
            this.d.setEpcCache(((EPCCacheDataSpec)dataSpec).getEPCCache());
        }
    }

    KillOpSpecAdapter(KillOpSpec killOpSpec) {
        this(killOpSpec.getDataSpec());
    }

    private KillOpSpecAdapter(KillOperationSpec killOperationSpec) throws URISyntaxException, PCSpecValidationException {
        this.d = killOperationSpec;
        this.c = killOperationSpec.getLiteral() != null ? DataSpecAdapter.createLiteral(killOperationSpec.getLiteral()) : DataSpecAdapter.createOther(killOperationSpec.getEpcCache(), killOperationSpec.getParam());
    }

    public DataSpec getDataSpec() {
        return this.c;
    }

    private KillOperationSpec c() {
        return this.d;
    }
}

