/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.alepc.axis;

import com.connecterra.alepc.api.ALEPCFactory;
import com.connecterra.alepc.api.AccessSpec;
import com.connecterra.alepc.api.DataSpec;
import com.connecterra.alepc.api.EPCCacheSpec;
import com.connecterra.alepc.api.EPCPatterns;
import com.connecterra.alepc.api.KillOpSpec;
import com.connecterra.alepc.api.LockOpSpec;
import com.connecterra.alepc.api.PCSpec;
import com.connecterra.alepc.api.PCSubscriptionControls;
import com.connecterra.alepc.api.PasswordOpSpec;
import com.connecterra.alepc.api.ReadOpSpec;
import com.connecterra.alepc.api.WriteOpSpec;
import com.connecterra.alepc.axis.adapters.AccessSpecAdapter;
import com.connecterra.alepc.axis.adapters.EPCCacheDataSpecAdapter;
import com.connecterra.alepc.axis.adapters.EPCCacheSpecAdapter;
import com.connecterra.alepc.axis.adapters.EPCPatternsAdapter;
import com.connecterra.alepc.axis.adapters.KillOpSpecAdapter;
import com.connecterra.alepc.axis.adapters.LiteralDataSpecAdapter;
import com.connecterra.alepc.axis.adapters.LockOpSpecAdapter;
import com.connecterra.alepc.axis.adapters.PCSpecAdapter;
import com.connecterra.alepc.axis.adapters.PCSubscriptionControlsAdapter;
import com.connecterra.alepc.axis.adapters.ParamDataSpecAdapter;
import com.connecterra.alepc.axis.adapters.PasswordOpSpecAdapter;
import com.connecterra.alepc.axis.adapters.ReadOpSpecAdapter;
import com.connecterra.alepc.axis.adapters.WriteOpSpecAdapter;
import java.net.URI;

public class AxisALEPCFactory
implements ALEPCFactory {
    private static ALEPCFactory b = new AxisALEPCFactory();
    public static final PCSubscriptionControls ZERO_CONTROLS = new PCSubscriptionControlsAdapter(0, 0L);

    private AxisALEPCFactory() {
    }

    public static ALEPCFactory getInstance() {
        return b;
    }

    public PCSpec createPCSpec() {
        return new PCSpecAdapter();
    }

    public EPCCacheSpec createEPCCacheSpec() {
        return new EPCCacheSpecAdapter();
    }

    public EPCPatterns createEPCPatterns() {
        return new EPCPatternsAdapter();
    }

    public PCSubscriptionControls createPCSubscriptionControls() {
        return ZERO_CONTROLS;
    }

    public PCSubscriptionControls createPCSubscriptionControls(int n, long l) {
        return new PCSubscriptionControlsAdapter(n, l);
    }

    public AccessSpec createAccessSpec(String string) {
        return new AccessSpecAdapter(string);
    }

    public DataSpec createEPCCacheDataSpec(String string) {
        return new EPCCacheDataSpecAdapter(string);
    }

    public KillOpSpec createKillOpSpec(DataSpec dataSpec) {
        return new KillOpSpecAdapter(dataSpec);
    }

    public DataSpec createLiteralDataSpec(URI uRI) {
        return new LiteralDataSpecAdapter(uRI);
    }

    public LockOpSpec createLockOpSpec(URI uRI, URI uRI2) {
        return new LockOpSpecAdapter(uRI, uRI2);
    }

    public DataSpec createParamDataSpec(String string) {
        return new ParamDataSpecAdapter(string);
    }

    public PasswordOpSpec createPasswordOpSpec(DataSpec dataSpec) {
        return new PasswordOpSpecAdapter(dataSpec);
    }

    public ReadOpSpec createReadOpSpec(URI uRI) {
        return new ReadOpSpecAdapter(uRI);
    }

    public WriteOpSpec createWriteOpSpec(URI uRI, DataSpec dataSpec) {
        return new WriteOpSpecAdapter(uRI, dataSpec);
    }
}

