/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.uri;

import com.connecterra.ale.uri.TagMemoryBank;
import com.connecterra.ale.uri.TagMemoryURIException;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class TagMemoryURI {
    private static final String g = "tagmem";
    private static final String c = "connecterra";
    private static final String i = "urn";
    public static final String EPC_SYMBOLIC_NAME = "epc";
    public static final String URI_PREFIX = "urn:connecterra:tagmem:";
    private static TagMemoryURI b;
    private URI k;
    private boolean j;
    private String e;
    private TagMemoryBank h;
    private int d;
    private int f;

    public TagMemoryURI(URI uRI) throws TagMemoryURIException {
        this.k = uRI;
        this.b();
        this.c();
    }

    public TagMemoryURI(String string) throws TagMemoryURIException {
        try {
            this.k = new URI(URI_PREFIX + string);
            this.j = true;
            this.e = string.toLowerCase();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new TagMemoryURIException(uRISyntaxException.getLocalizedMessage(), uRISyntaxException);
        }
        this.c();
    }

    public TagMemoryURI(TagMemoryBank tagMemoryBank, int n) throws TagMemoryURIException {
        this(tagMemoryBank, n, 0);
    }

    public TagMemoryURI(TagMemoryBank tagMemoryBank, int n, int n2) throws TagMemoryURIException {
        this.h = tagMemoryBank;
        this.d = n;
        this.f = n2;
        this.j = false;
        String string = "urn:connecterra:tagmem:@" + tagMemoryBank + "." + n;
        if (n2 != 0) {
            string = string + "." + n2;
        }
        try {
            this.k = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new TagMemoryURIException(uRISyntaxException.getLocalizedMessage(), uRISyntaxException);
        }
        this.c();
    }

    public static TagMemoryURI getEPCTagMemoryURI() {
        if (b == null) {
            try {
                b = new TagMemoryURI(EPC_SYMBOLIC_NAME);
            }
            catch (TagMemoryURIException tagMemoryURIException) {
                throw new RuntimeException("Error creating EPC field URI", tagMemoryURIException);
            }
        }
        return b;
    }

    public static URI getEPCURI() {
        return TagMemoryURI.getEPCTagMemoryURI().getURI();
    }

    public static URI getURI(String string) throws TagMemoryURIException {
        return new TagMemoryURI(string).getURI();
    }

    public static URI getURI(TagMemoryBank tagMemoryBank, int n) throws TagMemoryURIException {
        return new TagMemoryURI(tagMemoryBank, n).getURI();
    }

    public static URI getURI(TagMemoryBank tagMemoryBank, int n, int n2) throws TagMemoryURIException {
        return new TagMemoryURI(tagMemoryBank, n, n2).getURI();
    }

    public URI getURI() {
        return this.k;
    }

    public boolean isSymbolic() {
        return this.j;
    }

    public String getName() {
        if (this.isSymbolic()) {
            return this.e;
        }
        return null;
    }

    public TagMemoryBank getBank() {
        if (!this.isSymbolic()) {
            return this.h;
        }
        return null;
    }

    public int getLength() {
        if (!this.isSymbolic()) {
            return this.d;
        }
        return 0;
    }

    public int getOffset() {
        if (!this.isSymbolic()) {
            return this.f;
        }
        return 0;
    }

    public boolean isNamedField(String string) {
        if (!this.isSymbolic()) {
            return false;
        }
        if (this.e == null) {
            return false;
        }
        return this.e.equals(string);
    }

    private void b() throws TagMemoryURIException {
        String string;
        String string2;
        String string3;
        if (!i.equals(this.k.getScheme())) {
            throw new TagMemoryURIException(I18N.get("Scheme for tag memory URI must be \"urn\""));
        }
        if (!this.k.isOpaque()) {
            throw new TagMemoryURIException(I18N.get("Tag memory URI must be opaque"));
        }
        String string4 = this.k.getSchemeSpecificPart();
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
        try {
            string3 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            string3 = null;
        }
        if (!c.equalsIgnoreCase(string3)) {
            throw new TagMemoryURIException(I18N.get("Tag memory URI must be URN with namespace ID \"connecterra\""));
        }
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = null;
        }
        if (!g.equalsIgnoreCase(string2)) {
            throw new TagMemoryURIException(I18N.get("Tag memory URI must start \"urn:connecterra:tagmem:\""));
        }
        try {
            string = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new TagMemoryURIException(I18N.get("Tag memory URI must specify a symbolic name or bank reference."));
        }
        if (string.startsWith("@")) {
            String string5 = string.substring(1);
            this.j = false;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ".");
            this.h = TagMemoryBank.fromString(stringTokenizer2.nextToken());
            try {
                this.d = Integer.parseInt(stringTokenizer2.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new TagMemoryURIException(I18N.get("Error parsing length in tag memory URI: {0}", numberFormatException.getLocalizedMessage()), numberFormatException);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new TagMemoryURIException(I18N.get("Length must be specified in tag memory URI."), noSuchElementException);
            }
            try {
                this.f = 0;
                this.f = Integer.parseInt(stringTokenizer2.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new TagMemoryURIException(I18N.get("Error parsing offset in tag memory URI: {0}", numberFormatException.getLocalizedMessage()), numberFormatException);
            }
            catch (NoSuchElementException noSuchElementException) {}
        } else {
            this.j = true;
            this.e = string.toLowerCase();
        }
    }

    private void c() throws TagMemoryURIException {
        if (this.j) {
            this.e.trim();
            if (this.e.equals("")) {
                throw new TagMemoryURIException(I18N.get("Cannot specify empty symbolic name for tag memory URI"));
            }
            if (this.e.indexOf(58) != -1) {
                throw new TagMemoryURIException(I18N.get("Symbolic name cannot contain ':' for tag memory URI"));
            }
        } else {
            if (this.h == null) {
                throw new TagMemoryURIException(I18N.get("Tag memory URI needs memory bank"));
            }
            if (this.d == 0) {
                throw new TagMemoryURIException(I18N.get("Field length must be nonzero in tag memory URI"));
            }
        }
    }

    public int hashCode() {
        int n = this.isSymbolic() ? this.e.hashCode() : this.h.hashCode();
        return n + (this.d << 8) + this.f;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TagMemoryURI)) {
            return false;
        }
        TagMemoryURI tagMemoryURI = (TagMemoryURI)object;
        return (this.isSymbolic() && this.e.equals(tagMemoryURI.e) || !this.isSymbolic() && this.h == tagMemoryURI.h) && this.d == tagMemoryURI.d && this.f == tagMemoryURI.f;
    }

    public String toString() {
        return this.getURI().toASCIIString();
    }
}

