/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.BarcodeScheme;
import com.connecterra.ale.epc.DOD64Scheme;
import com.connecterra.ale.epc.DOD96Scheme;
import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldConstraint;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternField;
import com.connecterra.ale.epc.EPCPatternFieldNumeric;
import com.connecterra.ale.epc.EPCPatternFieldString;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.EPCPatternValidationException;
import com.connecterra.ale.epc.EPCRawEncoder;
import com.connecterra.ale.epc.EPCValidationException;
import com.connecterra.ale.epc.GIAI64Scheme;
import com.connecterra.ale.epc.GIAI96Scheme;
import com.connecterra.ale.epc.GID64IScheme;
import com.connecterra.ale.epc.GID96Scheme;
import com.connecterra.ale.epc.GRAI64Scheme;
import com.connecterra.ale.epc.GRAI96Scheme;
import com.connecterra.ale.epc.NumberUtil;
import com.connecterra.ale.epc.SGLN64Scheme;
import com.connecterra.ale.epc.SGLN96Scheme;
import com.connecterra.ale.epc.SGTIN64Scheme;
import com.connecterra.ale.epc.SGTIN96Scheme;
import com.connecterra.ale.epc.SSCC64Scheme;
import com.connecterra.ale.epc.SSCC96Scheme;
import com.connecterra.ale.epc.StackLightScheme;
import com.connecterra.ale.epc.Unknown128Scheme;
import com.connecterra.ale.epc.Unknown64Scheme;
import com.connecterra.ale.epc.Unknown96Scheme;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public abstract class Scheme {
    private EPCDescriptor l;
    static final String e = ".";
    private static HashMap c = new HashMap();
    private static HashMap o = new HashMap();
    private static HashMap g = new HashMap();
    private static HashMap i = new HashMap();
    private static EPCEncoder k;
    private static EPCEncoder n;
    private EPCEncoder f;
    private EPCEncoder h;
    private EPCBinaryEncoder j;
    private EPCPatternEncoder m;
    private EPCPatternEncoder d;
    private final String b;
    public static final Scheme Unknown64Scheme;
    public static final Scheme Unknown96Scheme;
    public static final Scheme Unknown128Scheme;
    public static final SGTIN64Scheme SGTIN_64;
    public static final SGTIN96Scheme SGTIN_96;
    public static final SSCC64Scheme SSCC_64;
    public static final SSCC96Scheme SSCC_96;
    public static final SGLN64Scheme SGLN_64;
    public static final SGLN96Scheme SGLN_96;
    public static final GRAI64Scheme GRAI_64;
    public static final GRAI96Scheme GRAI_96;
    public static final GIAI64Scheme GIAI_64;
    public static final GIAI96Scheme GIAI_96;
    public static final DOD64Scheme DOD_64;
    public static final DOD96Scheme DOD_96;
    public static final GID64IScheme GID_64_I;
    public static final GID96Scheme GID_96;
    public static final BarcodeScheme BARCODE_128;
    public static final StackLightScheme STACKLIGHT_128;

    protected Scheme(String string) {
        this.b = string;
        this.getPureIdentityURIEncoder();
        this.getTagURIEncoder();
        this.getBinaryEncoder();
        this.getPatternEncoder();
        this.getPureIdentityPatternEncoder();
        this.getRawHexEncoder();
        this.getRawDecimalEncoder();
        i.put(this.b, this);
    }

    public String getTypeString() {
        return this.b;
    }

    public boolean equals(Scheme scheme) {
        return this == scheme;
    }

    private static String b(URI uRI) {
        String string = uRI.toASCIIString();
        int n = string.lastIndexOf(":");
        return string.substring(0, n + 1);
    }

    protected static void registerURIEncoder(String string, EPCEncoder ePCEncoder) {
        c.put(string, ePCEncoder);
    }

    protected static EPCEncoder selectEncoder(URI uRI) throws EPCException {
        EPCEncoder ePCEncoder = null;
        String string = Scheme.b(uRI);
        ePCEncoder = (EPCEncoder)c.get(string);
        if (ePCEncoder == null) {
            throw new EPCException(I18N.get("no encoder available for EPC with prefix: {0}", string));
        }
        return ePCEncoder;
    }

    protected static void registerURIPatternEncoder(String string, EPCPatternEncoder ePCPatternEncoder) {
        o.put(string, ePCPatternEncoder);
    }

    protected static EPCPatternEncoder selectPatternEncoder(URI uRI) throws EPCPatternException {
        EPCPatternEncoder ePCPatternEncoder = null;
        String string = Scheme.b(uRI);
        ePCPatternEncoder = (EPCPatternEncoder)o.get(string);
        if (ePCPatternEncoder == null) {
            throw new EPCPatternException(I18N.get("no encoder available for EPC Pattern prefix: {0}", string));
        }
        return ePCPatternEncoder;
    }

    protected static void registerBinaryEncoder(int n, int n2, EPCBinaryEncoder ePCBinaryEncoder) {
        g.put(Scheme.b(n, n2), ePCBinaryEncoder);
    }

    private static final String b(int n, int n2) {
        return n2 + ":" + n;
    }

    protected static EPCBinaryEncoder selectBinaryEncoder(int n, int n2) throws EPCException {
        EPCBinaryEncoder ePCBinaryEncoder = null;
        ePCBinaryEncoder = (EPCBinaryEncoder)g.get(Scheme.b(n, n2));
        return ePCBinaryEncoder;
    }

    public static Scheme lookupSchemeByName(String string) throws EPCException {
        if (!i.containsKey(string)) {
            throw new EPCException(I18N.get("no such scheme name: {0}", string));
        }
        return (Scheme)i.get(string);
    }

    public List getTagURIFieldDescriptors() {
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>();
        EPCEncoder ePCEncoder = this.getTagURIEncoder();
        for (EPCFieldEncoder ePCFieldEncoder : ePCEncoder.getEncoderFieldList()) {
            int n = ePCFieldEncoder.getDescriptorIndex();
            EPCFieldDescriptor ePCFieldDescriptor = this.getEPCDescriptor().getFieldDescriptor(n);
            arrayList.add(ePCFieldDescriptor);
        }
        return arrayList;
    }

    protected abstract EPC createEPC(EPCImpl var1) throws EPCException;

    protected abstract EPCPattern createEPCPattern(EPCPatternImpl var1) throws EPCPatternException;

    public EPCDescriptor getEPCDescriptor() {
        if (this.l == null) {
            this.l = this.createEPCDescriptor();
        }
        return this.l;
    }

    protected abstract EPCDescriptor createEPCDescriptor();

    protected EPCEncoder getTagURIEncoder() {
        if (this.f == null) {
            this.f = this.createTagURIEncoder();
            Scheme.registerURIEncoder(this.f.getPrefix(), this.f);
        }
        return this.f;
    }

    protected abstract EPCEncoder createTagURIEncoder();

    protected EPCEncoder getPureIdentityURIEncoder() {
        if (this.h == null) {
            this.h = this.createPureIdentityURIEncoder();
            Scheme.registerURIEncoder(this.h.getPrefix(), this.h);
        }
        return this.h;
    }

    protected abstract EPCEncoder createPureIdentityURIEncoder();

    protected EPCEncoder getRawHexEncoder() {
        if (k == null) {
            k = this.createRawHexEncoder();
            Scheme.registerURIEncoder(k.getPrefix(), k);
        }
        return k;
    }

    protected EPCEncoder createRawHexEncoder() {
        return new EPCRawEncoder(this, "urn:epc:raw:", e, 16);
    }

    protected EPCEncoder getRawDecimalEncoder() {
        if (n == null) {
            n = this.createRawDecimalEncoder();
        }
        return n;
    }

    protected EPCEncoder createRawDecimalEncoder() {
        return new EPCRawEncoder(this, "urn:epc:raw:", e, 10);
    }

    protected int getHeaderBitSize() {
        return 8;
    }

    protected EPCBinaryEncoder getBinaryEncoder() {
        if (this.j == null) {
            this.j = this.createBinaryEncoder();
            Scheme.registerBinaryEncoder(this.j.getHeader(), this.getHeaderBitSize(), this.j);
        }
        return this.j;
    }

    protected abstract EPCBinaryEncoder createBinaryEncoder();

    protected EPCPatternEncoder getPatternEncoder() {
        if (this.m == null) {
            this.m = this.createPatternURIEncoder();
            Scheme.registerURIPatternEncoder(this.m.getPrefix(), this.m);
        }
        return this.m;
    }

    protected abstract EPCPatternEncoder createPatternURIEncoder();

    protected EPCPatternEncoder getPureIdentityPatternEncoder() {
        if (this.d == null) {
            this.d = this.createPureIdentityPatternURIEncoder();
            Scheme.registerURIPatternEncoder(this.d.getPrefix(), this.d);
        }
        return this.d;
    }

    protected abstract EPCPatternEncoder createPureIdentityPatternURIEncoder();

    public static EPCBinaryEncoder getBinaryEncoderForLongArray(long[] lArray) throws EPCException, EPCFieldDecodingException {
        EPCBinaryEncoder ePCBinaryEncoder = null;
        long l = 0L;
        int n = Scheme.getSizeForLongArray(lArray);
        switch (n) {
            case 64: {
                if (ePCBinaryEncoder == null && (l = NumberUtil.extractFromLongArray(lArray, 64, 2)) != 0L) {
                    ePCBinaryEncoder = Scheme.selectBinaryEncoder((int)l, 2);
                }
                if (ePCBinaryEncoder == null && (l = NumberUtil.extractFromLongArray(lArray, 64, 8)) != 0L) {
                    ePCBinaryEncoder = Scheme.selectBinaryEncoder((int)l, 8);
                }
                if (ePCBinaryEncoder != null) break;
                ePCBinaryEncoder = Unknown64Scheme.getBinaryEncoder();
                break;
            }
            case 96: {
                if (ePCBinaryEncoder == null && (l = NumberUtil.extractFromLongArray(lArray, 32, 8)) != 0L) {
                    ePCBinaryEncoder = Scheme.selectBinaryEncoder((int)l, 8);
                }
                if (ePCBinaryEncoder != null) break;
                ePCBinaryEncoder = Unknown96Scheme.getBinaryEncoder();
                break;
            }
            case 128: {
                if (ePCBinaryEncoder == null && (l = NumberUtil.extractFromLongArray(lArray, 0, 6)) != 0L) {
                    ePCBinaryEncoder = Scheme.selectBinaryEncoder((int)l, 6);
                }
                if (ePCBinaryEncoder != null) break;
                ePCBinaryEncoder = Unknown128Scheme.getBinaryEncoder();
            }
        }
        if (ePCBinaryEncoder == null) {
            throw new EPCFieldDecodingException(I18N.get("no encoder found for header: {0}", String.valueOf(l)));
        }
        return ePCBinaryEncoder;
    }

    public static int getSizeForLongArray(long[] lArray) {
        int n = 0;
        n = lArray[0] == 0L ? 64 : ((lArray[0] >> 32 & 0xFFFFFFFFFFFFFFFFL) == 0L ? 96 : 128);
        return n;
    }

    public static String[] getAllowedStringValues() {
        return i.keySet().toArray(new String[0]);
    }

    public static Set getAllowedStringValuesAsSet() {
        return i.keySet();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.b + "\n");
        stringBuffer.append(this.getEPCDescriptor());
        stringBuffer.append(this.getTagURIEncoder());
        stringBuffer.append(this.getPureIdentityURIEncoder());
        stringBuffer.append(this.getRawHexEncoder());
        stringBuffer.append(this.getRawDecimalEncoder());
        stringBuffer.append(this.getBinaryEncoder());
        return stringBuffer.toString();
    }

    protected void validate(EPCPattern ePCPattern) throws EPCPatternValidationException, EPCException {
        for (EPCFieldDescriptor ePCFieldDescriptor : this.getEPCDescriptor().getEPCFieldDescriptorList()) {
            EPCFieldConstraint ePCFieldConstraint = ePCFieldDescriptor.getEPCFieldConstraint();
            int n = ePCFieldDescriptor.getIndex();
            EPCPatternField ePCPatternField = ePCPattern.getEPCPatternField(n);
            if (ePCPatternField.isStar() || ePCPatternField.isX()) continue;
            if (ePCPatternField.isPoint()) {
                ePCFieldConstraint.validate(ePCPatternField.getEPCField());
                continue;
            }
            if (!ePCPatternField.isRange()) continue;
            if (ePCPatternField instanceof EPCPatternFieldNumeric) {
                ePCFieldConstraint.validate(((EPCPatternFieldNumeric)ePCPatternField).getEPCFieldNumericMin());
                ePCFieldConstraint.validate(((EPCPatternFieldNumeric)ePCPatternField).getEPCFieldNumericMax());
                continue;
            }
            if (!(ePCPatternField instanceof EPCPatternFieldString)) continue;
            throw new EPCValidationException(I18N.get("Range is not supported for type String"));
        }
        this.interFieldValidation(ePCPattern);
    }

    protected void validate(EPC ePC) throws EPCValidationException, EPCException {
        for (EPCFieldDescriptor ePCFieldDescriptor : this.getEPCDescriptor().getEPCFieldDescriptorList()) {
            EPCFieldConstraint ePCFieldConstraint = ePCFieldDescriptor.getEPCFieldConstraint();
            if (ePCFieldConstraint == null) continue;
            int n = ePCFieldDescriptor.getIndex();
            EPCField ePCField = ePC.getEPCField(n);
            ePCFieldConstraint.validate(ePCField);
        }
        this.interFieldValidation(ePC);
    }

    protected void interFieldValidation(EPC ePC) throws EPCValidationException, EPCException {
    }

    protected void interFieldValidation(EPCPattern ePCPattern) throws EPCValidationException, EPCException {
    }

    static {
        Unknown64Scheme = new Unknown64Scheme("unknown-64");
        Unknown96Scheme = new Unknown96Scheme("unknown-96");
        Unknown128Scheme = new Unknown128Scheme("unknown-128");
        SGTIN_64 = new SGTIN64Scheme("sgtin-64");
        SGTIN_96 = new SGTIN96Scheme("sgtin-96");
        SSCC_64 = new SSCC64Scheme("sscc-64");
        SSCC_96 = new SSCC96Scheme("sscc-96");
        SGLN_64 = new SGLN64Scheme("sgln-64");
        SGLN_96 = new SGLN96Scheme("sgln-96");
        GRAI_64 = new GRAI64Scheme("grai-64");
        GRAI_96 = new GRAI96Scheme("grai-96");
        GIAI_64 = new GIAI64Scheme("giai-64");
        GIAI_96 = new GIAI96Scheme("giai-96");
        DOD_64 = new DOD64Scheme("usdod-64");
        DOD_96 = new DOD96Scheme("usdod-96");
        GID_64_I = new GID64IScheme("gid-64-i");
        GID_96 = new GID96Scheme("gid-96");
        BARCODE_128 = new BarcodeScheme("connecterra-barcode");
        STACKLIGHT_128 = new StackLightScheme("connecterra-stacklight");
    }

    public static interface SchemeName {
        public static final String UNKNOWN_64_STRING = "unknown-64";
        public static final String UNKNOWN_96_STRING = "unknown-96";
        public static final String UNKNOWN_128_STRING = "unknown-128";
        public static final String SGTIN_64_STRING = "sgtin-64";
        public static final String SGTIN_96_STRING = "sgtin-96";
        public static final String SGLN_64_STRING = "sgln-64";
        public static final String SGLN_96_STRING = "sgln-96";
        public static final String SSCC_64_STRING = "sscc-64";
        public static final String SSCC_96_STRING = "sscc-96";
        public static final String GID_64_I_STRING = "gid-64-i";
        public static final String GID_96_STRING = "gid-96";
        public static final String GRAI_64_STRING = "grai-64";
        public static final String GRAI_96_STRING = "grai-96";
        public static final String GIAI_64_STRING = "giai-64";
        public static final String GIAI_96_STRING = "giai-96";
        public static final String DOD_64_STRING = "usdod-64";
        public static final String DOD_96_STRING = "usdod-96";
        public static final String BARCODE_STRING = "connecterra-barcode";
        public static final String STACKLIGHT_STRING = "connecterra-stacklight";
    }

    public static interface BitSize {
        public static final int BIT_SIZE_64 = 64;
        public static final int BIT_SIZE_96 = 96;
        public static final int BIT_SIZE_128 = 128;
    }
}

