/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.BinaryConverterForCompanyPrefixIndex;
import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldConstraintRegEx;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncoder64bitCompanyPrefix;
import com.connecterra.ale.epc.EPCFieldEncoder64bitCompanyPrefixCompliment;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.SSCC64;
import com.connecterra.ale.epc.SSCC64Pattern;
import com.connecterra.ale.epc.SSCCScheme;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

public class SSCC64Scheme
extends SSCCScheme {
    private final int tf = 8;
    private final int wf = 64;
    private static final int uf = 17;
    private static final String qf = "urn:epc:id:sscc:";
    private static final String of = "urn:epc:tag:sscc-64:";
    private final int nf = 8;
    private final int vf = 3;
    private final int zf = 14;
    private final int yf = 39;
    private final int xf = 64;
    private final int rf = 72;
    private final int sf = 75;
    private final int pf = 89;

    protected SSCC64Scheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new SSCC64(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new SSCC64Pattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(64, I18N.get("Serial Shipping Container Code (SSCC) 64 bit"), 8, Scheme.SSCC_64, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>(5);
        arrayList.add(new EPCFieldDescriptor(2, 8, I18N.get("Header"), I18N.get("SSCC-64 bit Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("SSCC-64 Header constraint"), 8L)));
        arrayList.add(new EPCFieldDescriptor(2, 3, I18N.get("Filter Value"), I18N.get("SSCC-64 Filter Value"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SSCC-64 Filter Value constraint"), 0L, 7L)));
        arrayList.add(new EPCFieldDescriptor(1, 14, I18N.get("Company Prefix"), I18N.get("SSCC-64 bit Company Prefix"), 2, false, ePCDescriptor, new EPCFieldConstraintRegEx(I18N.get("SSCC-64 Company Prefix constraint"), "[0-9]+", 6, 12)));
        arrayList.add(new EPCFieldDescriptor(2, 39, I18N.get("Serial Reference"), I18N.get("SSCC-64 Serial Reference"), 3, true, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SSCC-64 Serial Reference constraint"), 0L, 99999999999L)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10, false, 1));
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefix(this, 1, 2));
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefixCompliment(this, 2, 2, 3, 17));
        EPCEncoder ePCEncoder = new EPCEncoder(this, of, ".", arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefix(this, 0, 2));
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefixCompliment(this, 1, 2, 3, 17));
        EPCEncoder ePCEncoder = new EPCEncoder(this, qf, ".", arrayList);
        return ePCEncoder;
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:sscc-64:";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, ".", list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 64, 8));
        arrayList.add(new EPCBinaryFieldEncoder(1, 72, 3));
        arrayList.add(new EPCBinaryFieldEncoder(2, 75, 14, new BinaryConverterForCompanyPrefixIndex(this)));
        arrayList.add(new EPCBinaryFieldEncoder(3, 89, 39));
        return new EPCBinaryEncoder(this, 8, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
        SSCC64 sSCC64 = (SSCC64)ePC;
        String string = sSCC64.getCompanyPrefix();
        long l = sSCC64.getSerialReference();
        this.interFieldValidationForGS1_64(17, string, l);
    }
}

