/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCDecodingException;
import com.connecterra.ale.epc.EPCEncodingException;
import com.connecterra.i18n.I18N;
import java.math.BigInteger;

public class NumberUtil {
    public static final BigInteger MAX_64 = BigInteger.valueOf(1L).shiftLeft(64).subtract(BigInteger.valueOf(1L));
    public static final BigInteger MAX_96 = BigInteger.valueOf(1L).shiftLeft(96).subtract(BigInteger.valueOf(1L));
    public static final BigInteger MAX_128 = BigInteger.valueOf(1L).shiftLeft(128).subtract(BigInteger.valueOf(1L));
    public static final BigInteger MASK_64 = MAX_64;
    public static final BigInteger MASK_96 = MAX_96;
    public static final BigInteger MASK_128 = MAX_128;

    public static long extractFromLong(long l, int n, int n2) {
        int n3 = 64 - n - n2;
        int n4 = n2;
        if (n3 > 0) {
            l >>= n3;
        }
        if (n4 < 64) {
            l &= (1L << n4) - 1L;
        }
        return l;
    }

    public static long extractFromLongArray(long[] lArray, int n, int n2) throws EPCDecodingException {
        long l = 0L;
        int n3 = n + n2 - 1;
        if (n3 > 128) {
            throw new EPCDecodingException(I18N.get("max bit size of 128 exceeded: {0}", n3));
        }
        if (n3 < 64) {
            l = NumberUtil.extractFromLong(lArray[0], n, n2);
        } else if (n >= 64) {
            l = NumberUtil.extractFromLong(lArray[1], n - 64, n2);
        } else {
            int n4 = n;
            int n5 = 64 - n;
            int n6 = 0;
            int n7 = n2 - n5;
            long l2 = NumberUtil.extractFromLong(lArray[0], n4, n5);
            long l3 = NumberUtil.extractFromLong(lArray[1], n6, n7);
            l = l2 << n7 | l3;
        }
        return l;
    }

    public static long insertIntoLong(long l, int n, int n2, long l2) {
        long l3 = l;
        if (n == 0 && n2 == 64) {
            l3 = l2;
        } else {
            int n3 = 64 - n - n2;
            int n4 = n2;
            l3 &= (1L << n4) - 1L << n3 ^ 0xFFFFFFFFFFFFFFFFL;
            l3 |= (l2 & (1L << n4) - 1L) << n3;
        }
        return l3;
    }

    public static long[] insertIntoLongArray(long[] lArray, int n, int n2, long l) throws EPCEncodingException {
        int n3 = n + n2 - 1;
        if (n3 > 128) {
            throw new EPCEncodingException(I18N.get("max bit size of 128 exceeded: ", n3));
        }
        if (n3 < 64) {
            lArray[0] = NumberUtil.insertIntoLong(lArray[0], n, n2, l);
        } else if (n >= 64) {
            lArray[1] = NumberUtil.insertIntoLong(lArray[1], n - 64, n2, l);
        } else {
            int n4 = n;
            int n5 = 64 - n;
            int n6 = 0;
            int n7 = n2 - n5;
            long l2 = l >> n7 & (1L << n5) - 1L;
            long l3 = l & (1L << n7) - 1L;
            lArray[0] = NumberUtil.insertIntoLong(lArray[0], n4, n5, l2);
            lArray[1] = NumberUtil.insertIntoLong(lArray[1], n6, n7, l3);
        }
        return lArray;
    }
}

