/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternField;
import com.connecterra.ale.epc.EPCValidationException;
import com.connecterra.ale.epc.GS1Scheme;
import com.connecterra.i18n.I18N;

public abstract class GIAIScheme
extends GS1Scheme {
    protected GIAIScheme(String string) {
        super(string);
    }

    public EPCPatternEncoder createPureIdentityPatternURIEncoder() {
        String string = "urn:epc:idpat:giai:";
        return new EPCPatternEncoder(this, string, ".", this.getPureIdentityURIEncoder().getEncoderFieldList());
    }

    protected void interFieldValidation(EPCPattern ePCPattern) throws EPCValidationException, EPCException {
        EPCPatternField ePCPatternField;
        EPCPatternField ePCPatternField2 = ePCPattern.getEPCPatternField(2);
        if (!ePCPatternField2.isPoint() && (ePCPatternField = ePCPattern.getEPCPatternField(3)).isPoint()) {
            String string = this.getEPCDescriptor().getFieldDescriptor(2).getName();
            String string2 = this.getEPCDescriptor().getFieldDescriptor(3).getName();
            throw new EPCValidationException(I18N.get("{0} must be set to wild card if {1} is a wild card", (Object)string2, (Object)string));
        }
    }

    public static interface Encoding {

        public static interface TAG {
            public static final int FILTER = 0;
            public static final int COMPANY_PREFIX = 1;
            public static final int INDIVIDUAL_ASSET_REFERENCE = 2;
            public static final int SERIAL_NUMBER = 3;
        }

        public static interface PURE_IDENTITY {
            public static final int COMPANY_PREFIX = 0;
            public static final int INDIVIDUAL_ASSET_REFERENCE = 1;
            public static final int SERIAL_NUMBER = 2;
        }
    }

    public static interface DescriptorField {
        public static final int HEADER = 0;
        public static final int FILTER = 1;
        public static final int COMPANY_PREFIX = 2;
        public static final int INDIVIDUAL_ASSET_REFERENCE = 3;
        public static final int SERIAL_NUMBER = 4;
    }
}

