/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncodingException;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternField;
import com.connecterra.ale.epc.EPCPatternFieldNumeric;
import com.connecterra.ale.epc.EPCPatternFieldString;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.i18n.I18N;

public class EPCPatternFieldEncoder {
    private final EPCFieldEncoder b;

    public EPCPatternFieldEncoder(EPCFieldEncoder ePCFieldEncoder) {
        this.b = ePCFieldEncoder;
    }

    public EPCFieldEncoder getFieldEncoder() {
        return this.b;
    }

    public int getDescriptorIndex() {
        return this.getFieldEncoder().getDescriptorIndex();
    }

    public int getEncodingFieldIndex() {
        return this.getFieldEncoder().getEncodingFieldIndex();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String encode(EPCPatternImpl ePCPatternImpl) throws EPCException, EPCFieldEncodingException {
        String string = "";
        int n = this.getDescriptorIndex();
        EPCPatternField ePCPatternField = ePCPatternImpl.getPatternField(n);
        if (ePCPatternField.isStar()) {
            return "*";
        }
        if (ePCPatternField.isX()) {
            return "X";
        }
        if (ePCPatternField.isPoint()) {
            if (ePCPatternField instanceof EPCPatternFieldString) {
                EPCPatternFieldString ePCPatternFieldString = (EPCPatternFieldString)ePCPatternField;
                EPCFieldEncoder ePCFieldEncoder = this.getFieldEncoder();
                return ePCFieldEncoder.encode(ePCPatternImpl, ePCPatternFieldString.getEPCField());
            }
            if (!(ePCPatternField instanceof EPCPatternFieldNumeric)) throw new EPCException(I18N.get("unknown type"));
            EPCPatternFieldNumeric ePCPatternFieldNumeric = (EPCPatternFieldNumeric)ePCPatternField;
            EPCFieldEncoder ePCFieldEncoder = this.getFieldEncoder();
            return ePCFieldEncoder.encode(ePCPatternImpl, ePCPatternFieldNumeric.getEPCFieldNumericMin());
        }
        if (!ePCPatternField.isRange()) return string;
        EPCPatternFieldNumeric ePCPatternFieldNumeric = (EPCPatternFieldNumeric)ePCPatternField;
        EPCFieldEncoder ePCFieldEncoder = this.getFieldEncoder();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(ePCFieldEncoder.encode(ePCPatternImpl, ePCPatternFieldNumeric.getEPCFieldNumericMin()));
        stringBuffer.append("-");
        stringBuffer.append(ePCFieldEncoder.encode(ePCPatternImpl, ePCPatternFieldNumeric.getEPCFieldNumericMax()));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void decode(EPCPatternImpl ePCPatternImpl, String string) throws EPCException, EPCFieldDecodingException {
        int n = this.getDescriptorIndex();
        EPCPatternField ePCPatternField = ePCPatternImpl.getPatternField(n);
        if (string.equals("*")) {
            ePCPatternField.setStar();
        } else if (string.equals("X")) {
            ePCPatternField.setX();
        } else if (string.startsWith("[")) {
            long l;
            int n2 = string.indexOf("-");
            if (n2 < 1) {
                throw new EPCPatternException(I18N.get("incorrect range specification {0}", string));
            }
            String string2 = string.substring(1, n2);
            int n3 = string.indexOf("]");
            if (n3 < n2) {
                throw new EPCPatternException(I18N.get("incorrect range specification {0}", string));
            }
            if (!(ePCPatternField instanceof EPCPatternFieldNumeric)) {
                throw new EPCPatternException(I18N.get("{0} is a string value and can not be specified as range {1}", (Object)ePCPatternField.getEPCFieldDescriptor().getName(), (Object)string));
            }
            String string3 = string.substring(n2 + 1, n3);
            long l2 = Long.parseLong(string2);
            if (l2 > (l = Long.parseLong(string3))) {
                throw new EPCPatternException(I18N.get("min value {0} must be less than or equal to max value {1} for a range", (Object)string2, (Object)string3));
            }
            this.getFieldEncoder().decode(ePCPatternImpl, ((EPCPatternFieldNumeric)ePCPatternField).getEPCFieldNumericMin(), string2);
            this.getFieldEncoder().decode(ePCPatternImpl, ((EPCPatternFieldNumeric)ePCPatternField).getEPCFieldNumericMax(), string3);
            ePCPatternField.setRange();
        } else if (ePCPatternField instanceof EPCPatternFieldNumeric) {
            this.getFieldEncoder().decode(ePCPatternImpl, ((EPCPatternFieldNumeric)ePCPatternField).getEPCFieldNumericMax(), string);
            this.getFieldEncoder().decode(ePCPatternImpl, ((EPCPatternFieldNumeric)ePCPatternField).getEPCFieldNumericMin(), string);
            ePCPatternField.setPoint();
        } else if (ePCPatternField instanceof EPCPatternFieldString) {
            EPCFieldEncoder ePCFieldEncoder = this.getFieldEncoder();
            EPCField ePCField = null;
            if (ePCPatternField instanceof EPCPatternFieldNumeric) {
                ePCField = ePCPatternField.getEPCField();
            } else if (ePCPatternField instanceof EPCPatternFieldString) {
                ePCField = ePCPatternField.getEPCField();
            }
            this.getFieldEncoder().decode(ePCPatternImpl, ePCField, string);
            ePCPatternField.setPoint();
        }
    }
}

