/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.BarcodePattern;
import com.connecterra.ale.epc.DOD64Pattern;
import com.connecterra.ale.epc.DOD96Pattern;
import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternDecodingException;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternFieldNumeric;
import com.connecterra.ale.epc.EPCPatternFieldString;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.GIAI64Pattern;
import com.connecterra.ale.epc.GIAI96Pattern;
import com.connecterra.ale.epc.GID64IPattern;
import com.connecterra.ale.epc.GID96Pattern;
import com.connecterra.ale.epc.GRAI64Pattern;
import com.connecterra.ale.epc.GRAI96Pattern;
import com.connecterra.ale.epc.SGLN64Pattern;
import com.connecterra.ale.epc.SGLN96Pattern;
import com.connecterra.ale.epc.SGTIN64Pattern;
import com.connecterra.ale.epc.SGTIN96Pattern;
import com.connecterra.ale.epc.SSCC64Pattern;
import com.connecterra.ale.epc.SSCC96Pattern;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.StackLightPattern;
import com.connecterra.i18n.I18N;
import java.net.URI;

public class EPCPatternFactory {
    private static EPCPatternFactory b = null;

    public static EPCPatternFactory getInstance() {
        if (b == null) {
            b = new EPCPatternFactory();
        }
        return b;
    }

    public EPCPattern create(Scheme scheme) throws EPCException, EPCPatternException {
        if (scheme == null) {
            throw new EPCException(I18N.get("null scheme"));
        }
        EPCPattern ePCPattern = scheme.createEPCPattern(new EPCPatternImpl(scheme));
        ePCPattern.validate();
        return ePCPattern;
    }

    public EPCPattern create(URI uRI) throws EPCException, EPCPatternException, EPCPatternDecodingException, EPCFieldDecodingException {
        EPCPattern ePCPattern = null;
        EPCPatternEncoder ePCPatternEncoder = Scheme.selectPatternEncoder(uRI);
        ePCPattern = ePCPatternEncoder.decode(uRI);
        ePCPattern.validate();
        return ePCPattern;
    }

    public EPCPattern create(EPCPattern ePCPattern) throws EPCException, EPCPatternException, EPCPatternDecodingException, EPCFieldDecodingException {
        EPCPattern ePCPattern2 = (EPCPattern)ePCPattern.clone();
        if (ePCPattern2 == null) {
            throw new EPCPatternException(I18N.get("error cloning EPCPattern"));
        }
        ePCPattern.validate();
        return ePCPattern;
    }

    public EPCPattern create(EPC ePC) throws EPCException, EPCPatternException, EPCPatternDecodingException, EPCFieldDecodingException {
        EPCPattern ePCPattern = EPCPattern.createInstance(ePC);
        if (ePCPattern == null) {
            throw new EPCPatternException(I18N.get("error creating EPCPattern"));
        }
        ePCPattern.validate();
        return ePCPattern;
    }

    public SGTIN64Pattern createSGTIN64Pattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldString ePCPatternFieldString, EPCPatternFieldNumeric ePCPatternFieldNumeric2, EPCPatternFieldNumeric ePCPatternFieldNumeric3) throws EPCException {
        SGTIN64Pattern sGTIN64Pattern = new SGTIN64Pattern(ePCPatternFieldNumeric, ePCPatternFieldString, ePCPatternFieldNumeric2, ePCPatternFieldNumeric3);
        sGTIN64Pattern.validate();
        return sGTIN64Pattern;
    }

    public SGTIN64Pattern createSGTIN64Pattern() throws EPCException {
        SGTIN64Pattern sGTIN64Pattern = new SGTIN64Pattern();
        sGTIN64Pattern.validate();
        return sGTIN64Pattern;
    }

    public SGTIN96Pattern createSGTIN96Pattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldString ePCPatternFieldString, EPCPatternFieldNumeric ePCPatternFieldNumeric2, EPCPatternFieldNumeric ePCPatternFieldNumeric3) throws EPCException {
        SGTIN96Pattern sGTIN96Pattern = new SGTIN96Pattern(ePCPatternFieldNumeric, ePCPatternFieldString, ePCPatternFieldNumeric2, ePCPatternFieldNumeric3);
        sGTIN96Pattern.validate();
        return sGTIN96Pattern;
    }

    public SGTIN96Pattern createSGTIN96Pattern() throws EPCException {
        SGTIN96Pattern sGTIN96Pattern = new SGTIN96Pattern();
        sGTIN96Pattern.validate();
        return sGTIN96Pattern;
    }

    public SSCC64Pattern createSSCC64Pattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldString ePCPatternFieldString, EPCPatternFieldNumeric ePCPatternFieldNumeric2) throws EPCException {
        SSCC64Pattern sSCC64Pattern = new SSCC64Pattern(ePCPatternFieldNumeric, ePCPatternFieldString, ePCPatternFieldNumeric2);
        sSCC64Pattern.validate();
        return sSCC64Pattern;
    }

    public SSCC64Pattern createSSCC64Pattern() throws EPCException {
        SSCC64Pattern sSCC64Pattern = new SSCC64Pattern();
        sSCC64Pattern.validate();
        return sSCC64Pattern;
    }

    public SSCC96Pattern createSSCC96Pattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldString ePCPatternFieldString, EPCPatternFieldNumeric ePCPatternFieldNumeric2) throws EPCException {
        SSCC96Pattern sSCC96Pattern = new SSCC96Pattern(ePCPatternFieldNumeric, ePCPatternFieldString, ePCPatternFieldNumeric2);
        sSCC96Pattern.validate();
        return sSCC96Pattern;
    }

    public SSCC96Pattern createSSCC96Pattern() throws EPCException {
        SSCC96Pattern sSCC96Pattern = new SSCC96Pattern();
        sSCC96Pattern.validate();
        return sSCC96Pattern;
    }

    public SGLN64Pattern createSGLN64Pattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldString ePCPatternFieldString, EPCPatternFieldNumeric ePCPatternFieldNumeric2, EPCPatternFieldNumeric ePCPatternFieldNumeric3) throws EPCException {
        SGLN64Pattern sGLN64Pattern = new SGLN64Pattern(ePCPatternFieldNumeric, ePCPatternFieldString, ePCPatternFieldNumeric2, ePCPatternFieldNumeric3);
        sGLN64Pattern.validate();
        return sGLN64Pattern;
    }

    public SGLN64Pattern createSGLN64Pattern() throws EPCException {
        SGLN64Pattern sGLN64Pattern = new SGLN64Pattern();
        sGLN64Pattern.validate();
        return sGLN64Pattern;
    }

    public SGLN96Pattern createSGLN96Pattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldString ePCPatternFieldString, EPCPatternFieldNumeric ePCPatternFieldNumeric2, EPCPatternFieldNumeric ePCPatternFieldNumeric3) throws EPCException {
        SGLN96Pattern sGLN96Pattern = new SGLN96Pattern(ePCPatternFieldNumeric, ePCPatternFieldString, ePCPatternFieldNumeric2, ePCPatternFieldNumeric3);
        sGLN96Pattern.validate();
        return sGLN96Pattern;
    }

    public SGLN96Pattern createSGLN96Pattern() throws EPCException {
        SGLN96Pattern sGLN96Pattern = new SGLN96Pattern();
        sGLN96Pattern.validate();
        return sGLN96Pattern;
    }

    public GRAI64Pattern createGRAI64Pattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldString ePCPatternFieldString, EPCPatternFieldNumeric ePCPatternFieldNumeric2, EPCPatternFieldNumeric ePCPatternFieldNumeric3) throws EPCException {
        GRAI64Pattern gRAI64Pattern = new GRAI64Pattern(ePCPatternFieldNumeric, ePCPatternFieldString, ePCPatternFieldNumeric2, ePCPatternFieldNumeric3);
        gRAI64Pattern.validate();
        return gRAI64Pattern;
    }

    public GRAI64Pattern createGRAI64Pattern() throws EPCException {
        GRAI64Pattern gRAI64Pattern = new GRAI64Pattern();
        gRAI64Pattern.validate();
        return gRAI64Pattern;
    }

    public GRAI96Pattern createGRAI96Pattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldString ePCPatternFieldString, EPCPatternFieldNumeric ePCPatternFieldNumeric2, EPCPatternFieldNumeric ePCPatternFieldNumeric3) throws EPCException {
        GRAI96Pattern gRAI96Pattern = new GRAI96Pattern(ePCPatternFieldNumeric, ePCPatternFieldString, ePCPatternFieldNumeric2, ePCPatternFieldNumeric3);
        gRAI96Pattern.validate();
        return gRAI96Pattern;
    }

    public GRAI96Pattern createGRAI96Pattern() throws EPCException {
        GRAI96Pattern gRAI96Pattern = new GRAI96Pattern();
        gRAI96Pattern.validate();
        return gRAI96Pattern;
    }

    public GIAI64Pattern createGIAI64(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldString ePCPatternFieldString, EPCPatternFieldNumeric ePCPatternFieldNumeric2) throws EPCException {
        GIAI64Pattern gIAI64Pattern = new GIAI64Pattern(ePCPatternFieldNumeric, ePCPatternFieldString, ePCPatternFieldNumeric2);
        gIAI64Pattern.validate();
        return gIAI64Pattern;
    }

    public GIAI64Pattern createGIAI64Pattern() throws EPCException {
        GIAI64Pattern gIAI64Pattern = new GIAI64Pattern();
        gIAI64Pattern.validate();
        return gIAI64Pattern;
    }

    public GIAI96Pattern createGIAI96Pattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldString ePCPatternFieldString, EPCPatternFieldNumeric ePCPatternFieldNumeric2) throws EPCException {
        GIAI96Pattern gIAI96Pattern = new GIAI96Pattern(ePCPatternFieldNumeric, ePCPatternFieldString, ePCPatternFieldNumeric2);
        gIAI96Pattern.validate();
        return gIAI96Pattern;
    }

    public GIAI96Pattern createGIAI96Pattern() throws EPCException {
        GIAI96Pattern gIAI96Pattern = new GIAI96Pattern();
        gIAI96Pattern.validate();
        return gIAI96Pattern;
    }

    public GID64IPattern createGID64IPattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldNumeric ePCPatternFieldNumeric2, EPCPatternFieldNumeric ePCPatternFieldNumeric3) throws EPCException {
        GID64IPattern gID64IPattern = new GID64IPattern(ePCPatternFieldNumeric, ePCPatternFieldNumeric2, ePCPatternFieldNumeric3);
        gID64IPattern.validate();
        return gID64IPattern;
    }

    public GID64IPattern createGID64IPattern() throws EPCException {
        GID64IPattern gID64IPattern = new GID64IPattern();
        gID64IPattern.validate();
        return gID64IPattern;
    }

    public GID96Pattern createGID96Pattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldNumeric ePCPatternFieldNumeric2, EPCPatternFieldNumeric ePCPatternFieldNumeric3) throws EPCException {
        GID96Pattern gID96Pattern = new GID96Pattern(ePCPatternFieldNumeric, ePCPatternFieldNumeric2, ePCPatternFieldNumeric3);
        gID96Pattern.validate();
        return gID96Pattern;
    }

    public GID96Pattern createGID96Pattern() throws EPCException {
        GID96Pattern gID96Pattern = new GID96Pattern();
        gID96Pattern.validate();
        return gID96Pattern;
    }

    public DOD64Pattern createDOD64Pattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldString ePCPatternFieldString, EPCPatternFieldNumeric ePCPatternFieldNumeric2) throws EPCException {
        DOD64Pattern dOD64Pattern = new DOD64Pattern(ePCPatternFieldNumeric, ePCPatternFieldString, ePCPatternFieldNumeric2);
        dOD64Pattern.validate();
        return dOD64Pattern;
    }

    public DOD64Pattern createDOD64Pattern() throws EPCException {
        DOD64Pattern dOD64Pattern = new DOD64Pattern();
        dOD64Pattern.validate();
        return dOD64Pattern;
    }

    public DOD96Pattern createDOD96Pattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldString ePCPatternFieldString, EPCPatternFieldNumeric ePCPatternFieldNumeric2) throws EPCException {
        DOD96Pattern dOD96Pattern = new DOD96Pattern(ePCPatternFieldNumeric, ePCPatternFieldString, ePCPatternFieldNumeric2);
        dOD96Pattern.validate();
        return dOD96Pattern;
    }

    public DOD96Pattern createDOD96Pattern() throws EPCException {
        DOD96Pattern dOD96Pattern = new DOD96Pattern();
        dOD96Pattern.validate();
        return dOD96Pattern;
    }

    public BarcodePattern createBarcodePattern(EPCPatternFieldNumeric ePCPatternFieldNumeric, EPCPatternFieldNumeric ePCPatternFieldNumeric2) throws EPCException {
        BarcodePattern barcodePattern = new BarcodePattern(ePCPatternFieldNumeric, ePCPatternFieldNumeric2);
        barcodePattern.validate();
        return barcodePattern;
    }

    public BarcodePattern createBarcodePattern() throws EPCException {
        BarcodePattern barcodePattern = new BarcodePattern();
        barcodePattern.validate();
        return barcodePattern;
    }

    public StackLightPattern createStackLightPattern() throws EPCException {
        StackLightPattern stackLightPattern = new StackLightPattern();
        stackLightPattern.validate();
        return stackLightPattern;
    }
}

