/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncodingException;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCFieldString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.i18n.I18N;

public class EPCFieldEncoderNumeric
extends EPCFieldEncoder {
    private int g;
    private boolean h;
    private int i;
    public static String PAD_FILLER = "000000000000000000000000000000000000000000000000000000000000000000000000";

    public EPCFieldEncoderNumeric(int n, int n2, int n3) {
        super(n, n2);
        this.g = n3;
        this.h = false;
        this.i = -1;
    }

    public EPCFieldEncoderNumeric(int n, int n2, int n3, boolean bl, int n4) {
        super(n, n2);
        this.g = n3;
        this.h = bl;
        this.i = n4;
    }

    protected void setRadix(int n) {
        this.g = n;
    }

    public int getRadix() {
        return this.g;
    }

    private void b(boolean bl) {
        this.h = bl;
    }

    public boolean isPadded() {
        return this.h;
    }

    protected void setSize(int n) {
        this.i = n;
    }

    public int getSize() {
        return this.i;
    }

    public String encode(EPCImpl ePCImpl, EPCField ePCField) throws EPCFieldEncodingException, EPCException {
        String string = "";
        if (ePCField instanceof EPCFieldString) {
            String string2 = ((EPCFieldString)ePCField).getValue();
        } else if (ePCField instanceof EPCFieldNumeric) {
            long l = ((EPCFieldNumeric)ePCField).getValue();
            int n = -1;
            boolean bl = false;
            if (((EPCFieldNumeric)ePCField).isPadded()) {
                bl = true;
                n = ((EPCFieldNumeric)ePCField).getSize();
            } else if (this.isPadded()) {
                bl = true;
                n = this.getSize();
            }
            string = l == 0L && n == 0 ? "" : Long.toString(l, this.getRadix());
            if (bl && string.length() > n) {
                String string3 = I18N.get("{0} has value {1} with length {2} that is greater than allowed filed size {3}", new String[]{ePCField.getEPCFieldDescriptor().getName(), string, String.valueOf(string.length()), String.valueOf(n)});
                throw new EPCFieldEncodingException(string3);
            }
            if (bl) {
                string = PAD_FILLER.substring(0, n - string.length()) + string;
            }
        } else {
            throw new EPCFieldEncodingException(I18N.get("unknown type for epcField"));
        }
        return string;
    }

    public void decode(EPCImpl ePCImpl, EPCField ePCField, String string) throws EPCFieldDecodingException, EPCException {
        if (ePCField instanceof EPCFieldNumeric) {
            int n;
            if (((EPCFieldNumeric)ePCField).isPadded()) {
                n = ((EPCFieldNumeric)ePCField).getSize();
                if (string.length() != n) {
                    throw new EPCFieldDecodingException(I18N.get("invalid length for {0} with value {1} and length {2}, expecting length of {3}", new String[]{this.getFieldName(ePCImpl), string, String.valueOf(string.length()), String.valueOf(n)}));
                }
            } else if (this.isPadded()) {
                n = this.getSize();
                if (string.length() != n) {
                    throw new EPCFieldDecodingException(I18N.get("invalid length for {0} with value {1} and length {2}, expecting length of {3}", new String[]{this.getFieldName(ePCImpl), string, String.valueOf(string.length()), String.valueOf(this.getSize())}));
                }
            }
            long l = 0L;
            if (string.length() > 0) {
                try {
                    l = Long.parseLong(string, this.getRadix());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new EPCFieldDecodingException(numberFormatException.getLocalizedMessage(), numberFormatException);
                }
            }
            ((EPCFieldNumeric)ePCField).setValue(l);
        } else {
            ((EPCFieldString)ePCField).setValue(string);
        }
    }
}

