/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCFieldEncodingException;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCFieldString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.GS1Scheme;
import com.connecterra.i18n.I18N;

public class EPCFieldEncoder64bitCompanyPrefixCompliment
extends EPCFieldEncoderNumeric {
    private final GS1Scheme q;
    private final int p;
    private final int o;

    public EPCFieldEncoder64bitCompanyPrefixCompliment(GS1Scheme gS1Scheme, int n, int n2, int n3, int n4) {
        super(n, n3, 10);
        this.q = gS1Scheme;
        this.p = n2;
        this.o = n4;
    }

    public void setComplimentSize(EPCImpl ePCImpl, EPCFieldNumeric ePCFieldNumeric) throws EPCException {
        EPCField ePCField = ePCImpl.getField(this.p);
        String string = ((EPCFieldString)ePCField).getValue();
        if (string == null) {
            String string2 = I18N.get("{0} must be set to a wild card if Company Prefix is a wild card", this.getFieldName(ePCImpl));
            throw new EPCException(string2);
        }
        int n = string.length();
        int n2 = this.o - n;
        ePCFieldNumeric.setSize(n2);
    }

    public String encode(EPCImpl ePCImpl, EPCField ePCField) throws EPCFieldEncodingException, EPCException {
        this.setComplimentSize(ePCImpl, (EPCFieldNumeric)ePCField);
        return super.encode(ePCImpl, ePCField);
    }

    public void decode(EPCImpl ePCImpl, EPCField ePCField, String string) throws EPCFieldDecodingException, EPCException {
        this.setComplimentSize(ePCImpl, (EPCFieldNumeric)ePCField);
        super.decode(ePCImpl, ePCField, string);
    }
}

