/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncodingException;
import com.connecterra.ale.epc.EPCImpl;

public abstract class EPCFieldEncoder {
    private final int b;
    private final int c;

    public EPCFieldEncoder(int n, int n2) {
        this.c = n;
        this.b = n2;
    }

    public int getDescriptorIndex() {
        return this.b;
    }

    public int getEncodingFieldIndex() {
        return this.c;
    }

    protected String getFieldName(EPCImpl ePCImpl) {
        int n = this.getDescriptorIndex();
        EPCFieldDescriptor ePCFieldDescriptor = ePCImpl.getEPCDescriptor().getFieldDescriptor(n);
        return ePCFieldDescriptor.getName();
    }

    public String encode(EPCImpl ePCImpl) throws EPCException, EPCFieldEncodingException {
        String string = "";
        EPCField ePCField = ePCImpl.getField(this.getDescriptorIndex()).getEPCField();
        return this.encode(ePCImpl, ePCField);
    }

    public abstract String encode(EPCImpl var1, EPCField var2) throws EPCFieldEncodingException, EPCException;

    public void decode(EPCImpl ePCImpl, String string) throws EPCFieldDecodingException, EPCException {
        this.decode(ePCImpl, ePCImpl.getField(this.getDescriptorIndex()).getEPCField(), string);
    }

    public abstract void decode(EPCImpl var1, EPCField var2, String var3) throws EPCFieldDecodingException, EPCException;
}

