/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldConstraint;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCFieldString;
import com.connecterra.ale.epc.EPCValidationException;
import com.connecterra.i18n.I18N;
import java.util.regex.Pattern;

public class EPCFieldConstraintRegEx
extends EPCFieldConstraint {
    private final String k;
    private final int j;
    private final int i;

    public EPCFieldConstraintRegEx(String string, String string2, int n, int n2) {
        super(string);
        this.k = string2;
        this.j = n;
        this.i = n2;
    }

    public String getRegularExpression() {
        return this.k;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\n  RegEx:      " + this.getRegularExpression());
        stringBuffer.append("\n  min length: " + this.getMinLength());
        stringBuffer.append("\n  max length: " + this.getMaxLength());
        return stringBuffer.toString();
    }

    protected void validate(EPCField ePCField) throws EPCValidationException {
        boolean bl = false;
        String string = "";
        switch (ePCField.getEPCFieldDescriptor().getType()) {
            case 2: {
                string = String.valueOf(((EPCFieldNumeric)ePCField).getValue());
                break;
            }
            case 1: {
                string = ((EPCFieldString)ePCField).getValue();
                break;
            }
            default: {
                throw new EPCValidationException(I18N.get("unsupported type {0} for regular expression constraint {1} for field {2} with value {3}", new String[]{String.valueOf(ePCField.getEPCFieldDescriptor().getType()), this.getRegularExpression(), ePCField.getEPCFieldDescriptor().getName(), string}));
            }
        }
        if (string == null) {
            System.out.println("Value is null");
        }
        if (string.length() > this.i || string.length() < this.j) {
            throw new EPCValidationException(I18N.get("length constraint ( {0}, {1} ) not satisfied for field {2} with value {3} and length {4}", new String[]{String.valueOf(this.j), String.valueOf(this.i), ePCField.getEPCFieldDescriptor().getName(), string, String.valueOf(string.length())}));
        }
        bl = Pattern.matches(this.getRegularExpression(), string);
        if (!bl) {
            throw new EPCValidationException(I18N.get("regular expression constraint of {0} not satisfied for field {1} with value {2}", (Object)this.getRegularExpression(), (Object)ePCField.getEPCFieldDescriptor().getName(), (Object)string));
        }
    }

    public int getMaxLength() {
        return this.i;
    }

    public int getMinLength() {
        return this.j;
    }
}

