/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldConstraint;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCFieldString;
import com.connecterra.ale.epc.EPCValidationException;
import com.connecterra.i18n.I18N;

public class EPCFieldConstraintPoint
extends EPCFieldConstraint {
    private final long g;

    public EPCFieldConstraintPoint(String string, long l) {
        super(string);
        this.g = l;
    }

    public long getPointValue() {
        return this.g;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\n  value: " + this.getPointValue());
        return stringBuffer.toString();
    }

    protected void validate(EPCField ePCField) throws EPCValidationException {
        if (ePCField.getEPCFieldDescriptor().getType() == 2) {
            long l = ((EPCFieldNumeric)ePCField).getValue();
            if (l != this.getPointValue()) {
                throw new EPCValidationException(I18N.get("point constraint of {0} not satisfied by value {1} for field {2}", (Object)String.valueOf(this.getPointValue()), (Object)Long.toString(l), (Object)ePCField.getEPCFieldDescriptor().getName()));
            }
        } else if (ePCField.getEPCFieldDescriptor().getType() == 1) {
            String string = ((EPCFieldString)ePCField).getValue();
            if (string.equals(Long.toString(this.getPointValue()))) {
                throw new EPCValidationException(I18N.get("point constraint of {0} not satisfied by value {1} for field {2}", (Object)String.valueOf(this.getPointValue()), (Object)string, (Object)ePCField.getEPCFieldDescriptor().getName()));
            }
        } else {
            throw new EPCValidationException(I18N.get("point constraint of {0} not satisfied by unknown type for field {1}", (Object)String.valueOf(this.getPointValue()), (Object)ePCField.getEPCFieldDescriptor().getName()));
        }
    }
}

