/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCDecodingException;
import com.connecterra.ale.epc.EPCEncodingException;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncodingException;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EPCEncoder {
    private final String c;
    private final String b;
    private final Scheme e;
    private final ArrayList d;

    public EPCEncoder(Scheme scheme, String string, String string2, List list) {
        this.e = scheme;
        this.c = string;
        this.b = string2;
        this.d = new ArrayList(list);
    }

    protected List getEncoderFieldList() {
        return Collections.unmodifiableList(this.d);
    }

    EPCFieldEncoder b(int n) {
        return (EPCFieldEncoder)this.d.get(n);
    }

    public URI encode(EPC ePC) throws EPCEncodingException, EPCException {
        URI uRI = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.c);
            for (int i = 0; i < this.d.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(this.b);
                }
                stringBuffer.append(this.getField(ePC, (EPCFieldEncoder)this.d.get(i)));
            }
            uRI = new URI(stringBuffer.toString());
        }
        catch (Exception exception) {
            throw new EPCEncodingException(exception.getLocalizedMessage(), exception);
        }
        return uRI;
    }

    public String getField(EPC ePC, EPCFieldEncoder ePCFieldEncoder) throws EPCException, EPCFieldEncodingException {
        return ePCFieldEncoder.encode(ePC.getEPCImpl());
    }

    public EPC decode(URI uRI) throws EPCException, EPCFieldDecodingException {
        EPC ePC = null;
        String string = uRI.toASCIIString();
        if (string.indexOf(this.c) != 0) {
            throw new EPCDecodingException(I18N.get("Prefix not found {0}", this.c));
        }
        EPCImpl ePCImpl = new EPCImpl(this.e);
        string = string.substring(this.c.length());
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.d.size(); ++i) {
            if (n == -1) {
                throw new EPCDecodingException(I18N.get("error parsing field {0} in EPC {1}", (Object)this.b(i).getFieldName(ePCImpl), (Object)uRI.toASCIIString()));
            }
            String string2 = null;
            if (i == this.d.size() - 1) {
                string2 = string.substring(n);
            } else {
                n2 = string.substring(n).indexOf(this.b);
                try {
                    string2 = string.substring(n, n + n2);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    throw new EPCException(I18N.get("error parsing field {0} in EPC {1}", (Object)this.b(i).getFieldName(ePCImpl), (Object)uRI.toASCIIString()));
                }
            }
            n += n2 + 1;
            EPCFieldEncoder ePCFieldEncoder = this.b(i);
            ePCFieldEncoder.decode(ePCImpl, string2);
        }
        ePC = this.e.createEPC(ePCImpl);
        return ePC;
    }

    public String getPrefix() {
        return this.c;
    }

    public String getDelimiter() {
        return this.b;
    }
}

