/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.BinaryConverter;
import com.connecterra.ale.epc.EPCEncodingException;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCFieldString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.NumberUtil;
import com.connecterra.i18n.I18N;

public class EPCBinaryFieldEncoder {
    private final int b;
    private final int d;
    private final int c;
    private final BinaryConverter e;

    public EPCBinaryFieldEncoder(int n, int n2, int n3) {
        this.b = n;
        this.d = n2;
        this.c = n3;
        this.e = null;
    }

    public EPCBinaryFieldEncoder(int n, int n2, int n3, BinaryConverter binaryConverter) {
        this.b = n;
        this.d = n2;
        this.c = n3;
        this.e = binaryConverter;
    }

    public int getDescriptorIndex() {
        return this.b;
    }

    public int getStartIndex() {
        return this.d;
    }

    public int getLength() {
        return this.c;
    }

    public void decode(EPCImpl ePCImpl, long[] lArray) throws EPCException {
        EPCField ePCField = ePCImpl.getField(this.getDescriptorIndex());
        switch (ePCField.getEPCFieldDescriptor().getType()) {
            case 2: {
                long l = NumberUtil.extractFromLongArray(lArray, this.getStartIndex(), this.getLength());
                ((EPCFieldNumeric)ePCField).setValue(l);
                break;
            }
            case 1: {
                if (this.e != null) {
                    long l = NumberUtil.extractFromLongArray(lArray, this.getStartIndex(), this.getLength());
                    String string = this.e.longToString(l);
                    ((EPCFieldString)ePCField).setValue(string);
                    break;
                }
                throw new EPCEncodingException(I18N.get("no BinaryConverter specificed for String value"));
            }
            default: {
                throw new EPCEncodingException(I18N.get("unknown type: {0} for field: {1}", ePCField.getEPCFieldDescriptor().getType(), (Object)ePCField.getEPCFieldDescriptor().getName()));
            }
        }
    }

    public long[] encode(EPCImpl ePCImpl, long[] lArray) throws EPCException {
        EPCField ePCField = ePCImpl.getField(this.getDescriptorIndex());
        switch (ePCField.getEPCFieldDescriptor().getType()) {
            case 2: {
                long l = ((EPCFieldNumeric)ePCField).getValue();
                lArray = NumberUtil.insertIntoLongArray(lArray, this.getStartIndex(), this.getLength(), l);
                break;
            }
            case 1: {
                String string = ((EPCFieldString)ePCField).getValue();
                if (this.e != null) {
                    long l = this.e.stringToLong(string);
                    lArray = NumberUtil.insertIntoLongArray(lArray, this.getStartIndex(), this.getLength(), l);
                    break;
                }
                throw new EPCEncodingException(I18N.get("no binary converter specified for String value"));
            }
            default: {
                throw new EPCEncodingException(I18N.get("unknown type: {0} for field: {1}", ePCField.getEPCFieldDescriptor().getType(), (Object)ePCField.getEPCFieldDescriptor().getName()));
            }
        }
        return lArray;
    }
}

