/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDecodingException;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCFieldString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.NumberUtil;
import com.connecterra.ale.epc.PartitionTable;
import com.connecterra.i18n.I18N;

public class EPCBinaryCompanyPrefixAndComplimentFieldEncoder
extends EPCBinaryFieldEncoder {
    private final int j;
    private final int l;
    private final int f;
    private final int g;
    private final int i;
    private final PartitionTable h;
    private static final String k = "0000000000000000000000000000000000000";

    public EPCBinaryCompanyPrefixAndComplimentFieldEncoder(int n, int n2, int n3, int n4, int n5, PartitionTable partitionTable) {
        super(n, n3, n4 + n5);
        this.j = n;
        this.l = n2;
        this.f = n3;
        this.g = n4;
        this.i = n5;
        this.h = partitionTable;
    }

    public void decode(EPCImpl ePCImpl, long[] lArray) throws EPCException {
        int n;
        long l = NumberUtil.extractFromLongArray(lArray, this.f, this.g);
        int n2 = -1;
        for (n = 0; n2 < 0 && n < this.h.getRows(); ++n) {
            if ((long)this.h.getPartionValue(n) != l) continue;
            n2 = n;
        }
        if (n2 < 0) {
            throw new EPCDecodingException(I18N.get("invalid Partition value, {0}", String.valueOf(l)));
        }
        n = this.h.getCompanyPrefixBits(n2);
        int n3 = this.h.getComplimentBits(n2);
        int n4 = this.h.getCompanyPrefixDigits(n2);
        long l2 = NumberUtil.extractFromLongArray(lArray, this.f + this.g, n);
        long l3 = NumberUtil.extractFromLongArray(lArray, this.f + this.g + n, n3);
        EPCFieldString ePCFieldString = (EPCFieldString)ePCImpl.getField(this.j);
        EPCFieldNumeric ePCFieldNumeric = (EPCFieldNumeric)ePCImpl.getField(this.l);
        String string = Long.toString(l2);
        try {
            string = k.substring(0, n4 - string.length()) + string;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new EPCFieldDecodingException(I18N.get("error extracting Company Prefix, {0}", indexOutOfBoundsException.getLocalizedMessage()), indexOutOfBoundsException);
        }
        ePCFieldString.setValue(string);
        ePCFieldNumeric.setValue(l3);
    }

    public long[] encode(EPCImpl ePCImpl, long[] lArray) throws EPCException {
        int n;
        EPCFieldString ePCFieldString = (EPCFieldString)ePCImpl.getField(this.j);
        EPCFieldNumeric ePCFieldNumeric = (EPCFieldNumeric)ePCImpl.getField(this.l);
        String string = ePCFieldString.getValue();
        long l = ePCFieldNumeric.getValue();
        int n2 = string.length();
        long l2 = Long.parseLong(string);
        int n3 = -1;
        for (n = 0; n3 < 0 && n < this.h.getRows(); ++n) {
            if (this.h.getCompanyPrefixDigits(n) != n2) continue;
            n3 = n;
        }
        if (n3 < 0) {
            throw new EPCDecodingException(I18N.get("invalid Company Prefix length of {0} for Company Prefix {1}", n2, (Object)string));
        }
        n = this.h.getPartionValue(n3);
        int n4 = this.h.getCompanyPrefixBits(n3);
        int n5 = this.h.getComplimentBits(n3);
        lArray = NumberUtil.insertIntoLongArray(lArray, this.f, this.g, n);
        lArray = NumberUtil.insertIntoLongArray(lArray, this.f + this.g, n4, l2);
        lArray = NumberUtil.insertIntoLongArray(lArray, this.f + this.g + n4, n5, l);
        return lArray;
    }
}

