/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.BinaryConverterForCageCode64;
import com.connecterra.ale.epc.DOD64;
import com.connecterra.ale.epc.DOD64Pattern;
import com.connecterra.ale.epc.DODScheme;
import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldConstraintRegEx;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCFieldEncoderString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

public class DOD64Scheme
extends DODScheme {
    private final int sc = 206;
    private final int nc = 8;
    private final int tc = 2;
    private final int oc = 30;
    private final int rc = 24;
    private final int vc = 64;
    private final int pc = 72;
    private final int qc = 74;
    private final int uc = 104;

    protected DOD64Scheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new DOD64(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new DOD64Pattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(64, I18N.get("Department of Defense (DOD-64)"), 206, Scheme.DOD_64, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>(5);
        arrayList.add(new EPCFieldDescriptor(2, 8, I18N.get("Header"), I18N.get("DOD-64 bit Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("DOD-64 Header constraint"), 206L)));
        arrayList.add(new EPCFieldDescriptor(2, 2, I18N.get("Filter Value"), I18N.get("DOD-64 Filter Value"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("DOD-64 Filter Value constraint"), 0L, (long)Math.pow(2.0, 2.0) - 1L)));
        arrayList.add(new EPCFieldDescriptor(1, 30, I18N.get("CAGE Code"), I18N.get("DOD-64 bit CAGE Code"), 2, false, ePCDescriptor, new EPCFieldConstraintRegEx(I18N.get("DOD-64 CAGE Code constraint"), "[ 0-9A-HJ-NP-Z]+", 5, 5)));
        arrayList.add(new EPCFieldDescriptor(2, 24, I18N.get("Serial Number"), I18N.get("DOD-64 Serial Number"), 3, true, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("DOD-64 Serial Number constraint"), 0L, (long)Math.pow(2.0, 24.0) - 1L)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:epc:tag:usdod-64:";
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10));
        arrayList.add(new EPCFieldEncoderString(1, 2, 5, 5));
        arrayList.add(new EPCFieldEncoderNumeric(2, 3, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, ".", arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        String string = "urn:epc:id:usdod:";
        Object var2_2 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderString(0, 2, 5, 5));
        arrayList.add(new EPCFieldEncoderNumeric(1, 3, 10, false, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, ".", arrayList);
        return ePCEncoder;
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:usdod-64:";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, ".", list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 64, 8));
        arrayList.add(new EPCBinaryFieldEncoder(1, 72, 2));
        arrayList.add(new EPCBinaryFieldEncoder(2, 74, 30, new BinaryConverterForCageCode64()));
        arrayList.add(new EPCBinaryFieldEncoder(3, 104, 24));
        return new EPCBinaryEncoder(this, 206, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
    }
}

