/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.dynamicconfig.client;

import com.connecterra.ale.dynamicconfig.api.DynamicConfig;
import com.connecterra.ale.dynamicconfig.api.DynamicConfigFactory;
import com.connecterra.ale.dynamicconfig.api.PluginConfig;
import com.connecterra.ale.dynamicconfig.api.PluginException;
import com.connecterra.ale.dynamicconfig.api.PluginMeta;
import com.connecterra.ale.dynamicconfig.axis.AxisDynamicConfigFactory;
import com.connecterra.ale.dynamicconfig.axis.adapters.PluginConfigMapper;
import com.connecterra.ale.dynamicconfig.axis.adapters.PluginMetaMapper;
import com.connecterra.ale.dynamicconfig.axis.schema.ArrayOfString;
import com.connecterra.ale.dynamicconfig.axis.schema.PluginConfigList;
import com.connecterra.ale.dynamicconfig.axis.schema.PluginMetaList;
import com.connecterra.ale.dynamicconfig.axis.service.DuplicateNameException;
import com.connecterra.ale.dynamicconfig.axis.service.DynamicPluginConfigLocator;
import com.connecterra.ale.dynamicconfig.axis.service.DynamicPluginConfigSoap;
import com.connecterra.ale.dynamicconfig.axis.service.DynamicPluginConfigSoapStub;
import com.connecterra.ale.dynamicconfig.axis.service.NoSuchNameException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.rpc.ServiceException;

public class AxisDynamicConfigClient
implements DynamicConfig {
    private DynamicPluginConfigSoap b;

    public AxisDynamicConfigClient(URL uRL) throws RemoteException {
        if (uRL == null) {
            throw new IllegalArgumentException("Specified ALE Config Service URL is null");
        }
        DynamicPluginConfigLocator dynamicPluginConfigLocator = new DynamicPluginConfigLocator();
        try {
            this.b = dynamicPluginConfigLocator.getDynamicPluginConfigSoap(uRL);
        }
        catch (ServiceException serviceException) {
            throw new RemoteException(serviceException.getMessage());
        }
        this.setTimeout(600000L);
    }

    public void setTimeout(long l) {
        ((DynamicPluginConfigSoapStub)this.b).setTimeout((int)l);
    }

    public long getTimeout() {
        return ((DynamicPluginConfigSoapStub)this.b).getTimeout();
    }

    public DynamicConfigFactory getConfigFactory() {
        return AxisDynamicConfigFactory.getInstance();
    }

    public PluginMeta getPluginMeta(String string, String string2) throws PluginException, RemoteException {
        PluginMeta pluginMeta = null;
        try {
            com.connecterra.ale.dynamicconfig.axis.schema.PluginMeta pluginMeta2 = this.b.getPluginMeta(string, string2);
            pluginMeta = PluginMetaMapper.axisToALE(pluginMeta2);
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.dynamicconfig.api.NoSuchNameException(noSuchNameException.getReason());
        }
        catch (com.connecterra.ale.dynamicconfig.axis.service.PluginException pluginException) {
            throw new PluginException(pluginException.getReason());
        }
        return pluginMeta;
    }

    public List listPluginMeta(String string) throws PluginException, RemoteException {
        ArrayList<PluginMeta> arrayList = new ArrayList<PluginMeta>();
        try {
            PluginMetaList pluginMetaList = this.b.listPluginMeta(string);
            com.connecterra.ale.dynamicconfig.axis.schema.PluginMeta[] pluginMetaArray = pluginMetaList.getPluginMeta();
            if (pluginMetaArray == null) {
                return arrayList;
            }
            for (int i = 0; i < pluginMetaArray.length; ++i) {
                arrayList.add(PluginMetaMapper.axisToALE(pluginMetaArray[i]));
            }
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.dynamicconfig.api.NoSuchNameException(noSuchNameException.getReason());
        }
        catch (com.connecterra.ale.dynamicconfig.axis.service.PluginException pluginException) {
            throw new PluginException(pluginException.getReason());
        }
        return arrayList;
    }

    public List listPluginMetaNames(String string) throws PluginException, RemoteException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ArrayOfString arrayOfString = this.b.listPluginMetaNames(string);
            String[] stringArray = arrayOfString.getString();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.dynamicconfig.api.NoSuchNameException(noSuchNameException.getReason());
        }
        catch (com.connecterra.ale.dynamicconfig.axis.service.PluginException pluginException) {
            throw new PluginException(pluginException.getReason());
        }
        return arrayList;
    }

    public List listPlugins(String string) throws PluginException, RemoteException {
        ArrayList<PluginConfig> arrayList = new ArrayList<PluginConfig>();
        try {
            PluginConfigList pluginConfigList = this.b.listPlugins(string);
            com.connecterra.ale.dynamicconfig.axis.schema.PluginConfig[] pluginConfigArray = pluginConfigList.getPluginConfig();
            for (int i = 0; pluginConfigArray != null && i < pluginConfigArray.length; ++i) {
                arrayList.add(PluginConfigMapper.axisToALE(pluginConfigArray[i]));
            }
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.dynamicconfig.api.NoSuchNameException(noSuchNameException.getReason());
        }
        catch (com.connecterra.ale.dynamicconfig.axis.service.PluginException pluginException) {
            throw new PluginException(pluginException.getReason());
        }
        return arrayList;
    }

    public List listPluginNames(String string) throws PluginException, RemoteException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ArrayOfString arrayOfString = this.b.listPluginNames(string);
            String[] stringArray = arrayOfString.getString();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.dynamicconfig.api.NoSuchNameException(noSuchNameException.getReason());
        }
        catch (com.connecterra.ale.dynamicconfig.axis.service.PluginException pluginException) {
            throw new PluginException(pluginException.getReason());
        }
        return arrayList;
    }

    public void definePlugin(String string, String string2, PluginConfig pluginConfig) throws PluginException, RemoteException {
        try {
            com.connecterra.ale.dynamicconfig.axis.schema.PluginConfig pluginConfig2 = PluginConfigMapper.aleToAxis(pluginConfig);
            this.b.definePlugin(string, string2, pluginConfig2);
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.dynamicconfig.api.NoSuchNameException(noSuchNameException.getReason());
        }
        catch (DuplicateNameException duplicateNameException) {
            throw new com.connecterra.ale.dynamicconfig.api.DuplicateNameException(duplicateNameException.getReason());
        }
        catch (com.connecterra.ale.dynamicconfig.axis.service.PluginException pluginException) {
            throw new PluginException(pluginException.getReason());
        }
    }

    public void redefinePlugin(String string, String string2, PluginConfig pluginConfig) throws PluginException, RemoteException {
        try {
            com.connecterra.ale.dynamicconfig.axis.schema.PluginConfig pluginConfig2 = PluginConfigMapper.aleToAxis(pluginConfig);
            this.b.redefinePlugin(string, string2, pluginConfig2);
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.dynamicconfig.api.NoSuchNameException(noSuchNameException.getReason());
        }
        catch (com.connecterra.ale.dynamicconfig.axis.service.PluginException pluginException) {
            throw new PluginException(pluginException.getReason());
        }
    }

    public void undefinePlugin(String string, String string2) throws PluginException, RemoteException {
        try {
            this.b.undefinePlugin(string, string2);
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.dynamicconfig.api.NoSuchNameException(noSuchNameException.getReason());
        }
        catch (com.connecterra.ale.dynamicconfig.axis.service.PluginException pluginException) {
            throw new PluginException(pluginException.getReason());
        }
    }

    public PluginConfig getPlugin(String string, String string2) throws PluginException, RemoteException {
        PluginConfig pluginConfig = null;
        try {
            com.connecterra.ale.dynamicconfig.axis.schema.PluginConfig pluginConfig2 = this.b.getPlugin(string, string2);
            pluginConfig = PluginConfigMapper.axisToALE(pluginConfig2);
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.dynamicconfig.api.NoSuchNameException(noSuchNameException.getReason());
        }
        catch (com.connecterra.ale.dynamicconfig.axis.service.PluginException pluginException) {
            throw new PluginException(pluginException.getReason());
        }
        return pluginConfig;
    }

    public List listRoles() throws PluginException, RemoteException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ArrayOfString arrayOfString = this.b.listRoles();
            String[] stringArray = arrayOfString.getString();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        catch (com.connecterra.ale.dynamicconfig.axis.service.PluginException pluginException) {
            throw new PluginException(pluginException.getReason());
        }
        return arrayList;
    }

    public boolean isDynamicConfigEnabled() throws PluginException, RemoteException {
        try {
            return this.b.isDynamicConfigEnabled();
        }
        catch (com.connecterra.ale.dynamicconfig.axis.service.PluginException pluginException) {
            throw new PluginException(pluginException.getReason());
        }
    }
}

