/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.config.client;

import com.connecterra.ale.config.api.Config;
import com.connecterra.ale.config.api.ConfigFactory;
import com.connecterra.ale.config.api.CyclicDefinitionException;
import com.connecterra.ale.config.api.DuplicateFilterNameException;
import com.connecterra.ale.config.api.DuplicateLogicalReaderNameException;
import com.connecterra.ale.config.api.DuplicatePhysicalReaderNameException;
import com.connecterra.ale.config.api.NoSuchClientReaderException;
import com.connecterra.ale.config.api.NoSuchCompositeReaderException;
import com.connecterra.ale.config.api.NoSuchLogicalReaderException;
import com.connecterra.ale.config.axis.AxisConfigFactory;
import com.connecterra.ale.config.axis.adapters.EntitySpecAdapter;
import com.connecterra.ale.config.axis.schema.EntitySpec;
import com.connecterra.ale.config.axis.schema.ReferentialIntegrity;
import com.connecterra.ale.config.axis.service.ALEConfigServiceBindingStub;
import com.connecterra.ale.config.axis.service.ALEConfigServiceLocator;
import com.connecterra.ale.config.axis.service.ALEConfigServicePortType;
import com.connecterra.ale.config.axis.service.AddReaderToComposite;
import com.connecterra.ale.config.axis.service.AddReadersToComposite;
import com.connecterra.ale.config.axis.service.AppendFilterToChain;
import com.connecterra.ale.config.axis.service.ArrayOfString;
import com.connecterra.ale.config.axis.service.ConfigEngineException;
import com.connecterra.ale.config.axis.service.DefineCompositeReader;
import com.connecterra.ale.config.axis.service.DefineCompositeReaderWithControl;
import com.connecterra.ale.config.axis.service.DefineFilter;
import com.connecterra.ale.config.axis.service.DefinePhysicalReader;
import com.connecterra.ale.config.axis.service.DefineTrigger;
import com.connecterra.ale.config.axis.service.DuplicateCompositeReaderNameException;
import com.connecterra.ale.config.axis.service.DuplicateTriggerNameException;
import com.connecterra.ale.config.axis.service.EmptyParms;
import com.connecterra.ale.config.axis.service.EntitySpecValidationException;
import com.connecterra.ale.config.axis.service.GetClientReaderNames;
import com.connecterra.ale.config.axis.service.GetCompositeReaderNamesUsingReader;
import com.connecterra.ale.config.axis.service.GetFilterChain;
import com.connecterra.ale.config.axis.service.GetFilterSpec;
import com.connecterra.ale.config.axis.service.GetLogicalReaderNames;
import com.connecterra.ale.config.axis.service.GetLogicalReaderNamesUsingFilter;
import com.connecterra.ale.config.axis.service.GetPhysicalReaderName;
import com.connecterra.ale.config.axis.service.GetPhysicalReaderSpec;
import com.connecterra.ale.config.axis.service.GetReportFailedMembers;
import com.connecterra.ale.config.axis.service.GetTriggerSpec;
import com.connecterra.ale.config.axis.service.InUseException;
import com.connecterra.ale.config.axis.service.NoSuchDriverException;
import com.connecterra.ale.config.axis.service.NoSuchFilterException;
import com.connecterra.ale.config.axis.service.NoSuchPhysicalReaderException;
import com.connecterra.ale.config.axis.service.NoSuchTriggerException;
import com.connecterra.ale.config.axis.service.PrependFilterToChain;
import com.connecterra.ale.config.axis.service.RedefineCompositeReader;
import com.connecterra.ale.config.axis.service.RedefineCompositeReaderWithControl;
import com.connecterra.ale.config.axis.service.RedefineFilter;
import com.connecterra.ale.config.axis.service.RedefinePhysicalReader;
import com.connecterra.ale.config.axis.service.RedefinePhysicalReaderWithControl;
import com.connecterra.ale.config.axis.service.RedefineTrigger;
import com.connecterra.ale.config.axis.service.RemoveFilterFromChain;
import com.connecterra.ale.config.axis.service.RemoveReaderFromComposite;
import com.connecterra.ale.config.axis.service.SetFilterChain;
import com.connecterra.ale.config.axis.service.SupportsReading;
import com.connecterra.ale.config.axis.service.SupportsWriting;
import com.connecterra.ale.config.axis.service.UndefineCompositeReader;
import com.connecterra.ale.config.axis.service.UndefineCompositeReaderWithControl;
import com.connecterra.ale.config.axis.service.UndefineFilter;
import com.connecterra.ale.config.axis.service.UndefineFilterWithControl;
import com.connecterra.ale.config.axis.service.UndefinePhysicalReader;
import com.connecterra.ale.config.axis.service.UndefinePhysicalReaderWithControl;
import com.connecterra.ale.config.axis.service.UndefineTrigger;
import com.connecterra.ale.config.axis.service.UndefineTriggerWithControl;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.ServiceException;

public class AxisConfigClient
implements Config {
    private ALEConfigServicePortType b;

    public AxisConfigClient(URL uRL) throws RemoteException {
        if (uRL == null) {
            throw new IllegalArgumentException("Specified ALE Config Service URL is null");
        }
        Logger logger = Logger.getLogger("org.apache.axis");
        logger.setLevel(Level.OFF);
        ALEConfigServiceLocator aLEConfigServiceLocator = new ALEConfigServiceLocator();
        try {
            this.b = aLEConfigServiceLocator.getALEConfigService(uRL);
        }
        catch (ServiceException serviceException) {
            throw new RemoteException(serviceException.getMessage(), serviceException);
        }
        this.setTimeout(600000L);
    }

    public void setTimeout(long l) {
        ((ALEConfigServiceBindingStub)this.b).setTimeout((int)l);
    }

    public long getTimeout() {
        return ((ALEConfigServiceBindingStub)this.b).getTimeout();
    }

    public ConfigFactory getConfigFactory() {
        return AxisConfigFactory.getInstance();
    }

    public List getAllPhysicalReaderNames() throws RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        try {
            ArrayOfString arrayOfString = this.b.getAllPhysicalReaderNames(new EmptyParms());
            return AxisConfigClient.b(arrayOfString);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void definePhysicalReader(String string, com.connecterra.ale.config.api.EntitySpec entitySpec) throws DuplicatePhysicalReaderNameException, DuplicateLogicalReaderNameException, com.connecterra.ale.config.api.EntitySpecValidationException, com.connecterra.ale.config.api.NoSuchDriverException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified physical reader name is null.");
        }
        if (entitySpec == null) {
            throw new IllegalArgumentException("Specified EntitySpec is null.");
        }
        DefinePhysicalReader definePhysicalReader = new DefinePhysicalReader();
        definePhysicalReader.setPhysicalReaderName(string);
        definePhysicalReader.setSpec(EntitySpecAdapter.aleToAxis(entitySpec));
        try {
            this.b.definePhysicalReader(definePhysicalReader);
        }
        catch (com.connecterra.ale.config.axis.service.DuplicatePhysicalReaderNameException duplicatePhysicalReaderNameException) {
            throw new DuplicatePhysicalReaderNameException(duplicatePhysicalReaderNameException.getMessage(), duplicatePhysicalReaderNameException);
        }
        catch (com.connecterra.ale.config.axis.service.DuplicateLogicalReaderNameException duplicateLogicalReaderNameException) {
            throw new DuplicateLogicalReaderNameException(duplicateLogicalReaderNameException.getMessage(), duplicateLogicalReaderNameException);
        }
        catch (EntitySpecValidationException entitySpecValidationException) {
            throw new com.connecterra.ale.config.api.EntitySpecValidationException(entitySpecValidationException.getMessage(), entitySpecValidationException);
        }
        catch (NoSuchDriverException noSuchDriverException) {
            throw new com.connecterra.ale.config.api.NoSuchDriverException(noSuchDriverException.getMessage(), noSuchDriverException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void undefinePhysicalReader(String string) throws com.connecterra.ale.config.api.NoSuchPhysicalReaderException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified physical reader name is null.");
        }
        UndefinePhysicalReader undefinePhysicalReader = new UndefinePhysicalReader();
        undefinePhysicalReader.setPhysicalReaderName(string);
        try {
            this.b.undefinePhysicalReader(undefinePhysicalReader);
        }
        catch (NoSuchPhysicalReaderException noSuchPhysicalReaderException) {
            throw new com.connecterra.ale.config.api.NoSuchPhysicalReaderException(noSuchPhysicalReaderException.getMessage(), noSuchPhysicalReaderException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void undefinePhysicalReader(String string, com.connecterra.ale.config.api.ReferentialIntegrity referentialIntegrity) throws com.connecterra.ale.config.api.NoSuchPhysicalReaderException, com.connecterra.ale.config.api.InUseException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified physical reader name is null.");
        }
        UndefinePhysicalReaderWithControl undefinePhysicalReaderWithControl = new UndefinePhysicalReaderWithControl();
        undefinePhysicalReaderWithControl.setPhysicalReaderName(string);
        undefinePhysicalReaderWithControl.setRiControl(AxisConfigClient.b(referentialIntegrity));
        try {
            this.b.undefinePhysicalReaderWithControl(undefinePhysicalReaderWithControl);
        }
        catch (NoSuchPhysicalReaderException noSuchPhysicalReaderException) {
            throw new com.connecterra.ale.config.api.NoSuchPhysicalReaderException(noSuchPhysicalReaderException.getMessage(), noSuchPhysicalReaderException);
        }
        catch (InUseException inUseException) {
            throw new com.connecterra.ale.config.api.InUseException(inUseException.getMessage(), inUseException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    private static ReferentialIntegrity b(com.connecterra.ale.config.api.ReferentialIntegrity referentialIntegrity) {
        if (referentialIntegrity == null) {
            referentialIntegrity = com.connecterra.ale.config.api.ReferentialIntegrity.RELAX;
        }
        return ReferentialIntegrity.fromValue(referentialIntegrity.toString());
    }

    public void redefinePhysicalReader(String string, com.connecterra.ale.config.api.EntitySpec entitySpec) throws com.connecterra.ale.config.api.NoSuchPhysicalReaderException, DuplicateLogicalReaderNameException, com.connecterra.ale.config.api.EntitySpecValidationException, com.connecterra.ale.config.api.NoSuchDriverException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified physical reader name is null.");
        }
        if (entitySpec == null) {
            throw new IllegalArgumentException("Specified EntitySpec is null.");
        }
        RedefinePhysicalReader redefinePhysicalReader = new RedefinePhysicalReader();
        redefinePhysicalReader.setPhysicalReaderName(string);
        redefinePhysicalReader.setSpec(EntitySpecAdapter.aleToAxis(entitySpec));
        try {
            this.b.redefinePhysicalReader(redefinePhysicalReader);
        }
        catch (NoSuchPhysicalReaderException noSuchPhysicalReaderException) {
            throw new com.connecterra.ale.config.api.NoSuchPhysicalReaderException(noSuchPhysicalReaderException.getMessage(), noSuchPhysicalReaderException);
        }
        catch (com.connecterra.ale.config.axis.service.DuplicateLogicalReaderNameException duplicateLogicalReaderNameException) {
            throw new DuplicateLogicalReaderNameException(duplicateLogicalReaderNameException.getMessage(), duplicateLogicalReaderNameException);
        }
        catch (EntitySpecValidationException entitySpecValidationException) {
            throw new com.connecterra.ale.config.api.EntitySpecValidationException(entitySpecValidationException.getMessage(), entitySpecValidationException);
        }
        catch (NoSuchDriverException noSuchDriverException) {
            throw new com.connecterra.ale.config.api.NoSuchDriverException(noSuchDriverException.getMessage(), noSuchDriverException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void redefinePhysicalReader(String string, com.connecterra.ale.config.api.EntitySpec entitySpec, com.connecterra.ale.config.api.ReferentialIntegrity referentialIntegrity) throws com.connecterra.ale.config.api.NoSuchPhysicalReaderException, DuplicateLogicalReaderNameException, com.connecterra.ale.config.api.EntitySpecValidationException, com.connecterra.ale.config.api.NoSuchDriverException, com.connecterra.ale.config.api.InUseException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified physical reader name is null.");
        }
        if (entitySpec == null) {
            throw new IllegalArgumentException("Specified EntitySpec is null.");
        }
        RedefinePhysicalReaderWithControl redefinePhysicalReaderWithControl = new RedefinePhysicalReaderWithControl();
        redefinePhysicalReaderWithControl.setPhysicalReaderName(string);
        redefinePhysicalReaderWithControl.setSpec(EntitySpecAdapter.aleToAxis(entitySpec));
        redefinePhysicalReaderWithControl.setRiControl(AxisConfigClient.b(referentialIntegrity));
        try {
            this.b.redefinePhysicalReaderWithControl(redefinePhysicalReaderWithControl);
        }
        catch (NoSuchPhysicalReaderException noSuchPhysicalReaderException) {
            throw new com.connecterra.ale.config.api.NoSuchPhysicalReaderException(noSuchPhysicalReaderException.getMessage(), noSuchPhysicalReaderException);
        }
        catch (com.connecterra.ale.config.axis.service.DuplicateLogicalReaderNameException duplicateLogicalReaderNameException) {
            throw new DuplicateLogicalReaderNameException(duplicateLogicalReaderNameException.getMessage(), duplicateLogicalReaderNameException);
        }
        catch (EntitySpecValidationException entitySpecValidationException) {
            throw new com.connecterra.ale.config.api.EntitySpecValidationException(entitySpecValidationException.getMessage(), entitySpecValidationException);
        }
        catch (NoSuchDriverException noSuchDriverException) {
            throw new com.connecterra.ale.config.api.NoSuchDriverException(noSuchDriverException.getMessage(), noSuchDriverException);
        }
        catch (InUseException inUseException) {
            throw new com.connecterra.ale.config.api.InUseException(inUseException.getMessage(), inUseException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public com.connecterra.ale.config.api.EntitySpec getPhysicalReaderSpec(String string) throws RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified physical reader name is null.");
        }
        GetPhysicalReaderSpec getPhysicalReaderSpec = new GetPhysicalReaderSpec();
        getPhysicalReaderSpec.setPhysicalReaderName(string);
        try {
            EntitySpec entitySpec = this.b.getPhysicalReaderSpec(getPhysicalReaderSpec);
            return EntitySpecAdapter.axisToALE(entitySpec);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public List getLogicalReaderNames(String string) throws com.connecterra.ale.config.api.NoSuchPhysicalReaderException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified physical reader name is null.");
        }
        GetLogicalReaderNames getLogicalReaderNames = new GetLogicalReaderNames();
        getLogicalReaderNames.setPhysicalReaderName(string);
        try {
            ArrayOfString arrayOfString = this.b.getLogicalReaderNames(getLogicalReaderNames);
            return AxisConfigClient.b(arrayOfString);
        }
        catch (NoSuchPhysicalReaderException noSuchPhysicalReaderException) {
            throw new com.connecterra.ale.config.api.NoSuchPhysicalReaderException(noSuchPhysicalReaderException.getMessage(), noSuchPhysicalReaderException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public List getPhysicalReaderDriverNames() throws RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        try {
            ArrayOfString arrayOfString = this.b.getPhysicalReaderDriverNames(new EmptyParms());
            return AxisConfigClient.b(arrayOfString);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public List getAllLogicalReaderNames() throws RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        try {
            ArrayOfString arrayOfString = this.b.getAllLogicalReaderNames(new EmptyParms());
            return AxisConfigClient.b(arrayOfString);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public boolean supportsReading(String string) throws NoSuchLogicalReaderException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified logical reader name is null.");
        }
        SupportsReading supportsReading = new SupportsReading();
        supportsReading.setLogicalReaderName(string);
        try {
            return this.b.supportsReading(supportsReading);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchLogicalReaderException noSuchLogicalReaderException) {
            throw new NoSuchLogicalReaderException(noSuchLogicalReaderException.getMessage(), noSuchLogicalReaderException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public boolean supportsWriting(String string) throws NoSuchLogicalReaderException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified logical reader name is null.");
        }
        SupportsWriting supportsWriting = new SupportsWriting();
        supportsWriting.setLogicalReaderName(string);
        try {
            return this.b.supportsWriting(supportsWriting);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchLogicalReaderException noSuchLogicalReaderException) {
            throw new NoSuchLogicalReaderException(noSuchLogicalReaderException.getMessage(), noSuchLogicalReaderException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public List getFilterChain(String string) throws NoSuchLogicalReaderException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified logical reader name is null.");
        }
        GetFilterChain getFilterChain = new GetFilterChain();
        getFilterChain.setLogicalReaderName(string);
        try {
            ArrayOfString arrayOfString = this.b.getFilterChain(getFilterChain);
            return AxisConfigClient.b(arrayOfString);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchLogicalReaderException noSuchLogicalReaderException) {
            throw new NoSuchLogicalReaderException(noSuchLogicalReaderException.getMessage(), noSuchLogicalReaderException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void setFilterChain(String string, List arrayList) throws NoSuchLogicalReaderException, com.connecterra.ale.config.api.NoSuchFilterException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified logical reader name is null.");
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        ArrayOfString arrayOfString = new ArrayOfString();
        arrayOfString.setString(arrayList.toArray(new String[arrayList.size()]));
        SetFilterChain setFilterChain = new SetFilterChain();
        setFilterChain.setLogicalReaderName(string);
        setFilterChain.setFilterNames(arrayOfString);
        try {
            this.b.setFilterChain(setFilterChain);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchLogicalReaderException noSuchLogicalReaderException) {
            throw new NoSuchLogicalReaderException(noSuchLogicalReaderException.getMessage(), noSuchLogicalReaderException);
        }
        catch (NoSuchFilterException noSuchFilterException) {
            throw new com.connecterra.ale.config.api.NoSuchFilterException(noSuchFilterException.getMessage(), noSuchFilterException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void prependFilterToChain(String string, String string2) throws NoSuchLogicalReaderException, com.connecterra.ale.config.api.NoSuchFilterException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified logical reader name is null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Specified filter name is null.");
        }
        PrependFilterToChain prependFilterToChain = new PrependFilterToChain();
        prependFilterToChain.setLogicalReaderName(string);
        prependFilterToChain.setFilterName(string2);
        try {
            this.b.prependFilterToChain(prependFilterToChain);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchLogicalReaderException noSuchLogicalReaderException) {
            throw new NoSuchLogicalReaderException(noSuchLogicalReaderException.getMessage(), noSuchLogicalReaderException);
        }
        catch (NoSuchFilterException noSuchFilterException) {
            throw new com.connecterra.ale.config.api.NoSuchFilterException(noSuchFilterException.getMessage(), noSuchFilterException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void appendFilterToChain(String string, String string2) throws NoSuchLogicalReaderException, com.connecterra.ale.config.api.NoSuchFilterException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified logical reader name is null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Specified filter name is null.");
        }
        AppendFilterToChain appendFilterToChain = new AppendFilterToChain();
        appendFilterToChain.setLogicalReaderName(string);
        appendFilterToChain.setFilterName(string2);
        try {
            this.b.appendFilterToChain(appendFilterToChain);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchLogicalReaderException noSuchLogicalReaderException) {
            throw new NoSuchLogicalReaderException(noSuchLogicalReaderException.getMessage(), noSuchLogicalReaderException);
        }
        catch (NoSuchFilterException noSuchFilterException) {
            throw new com.connecterra.ale.config.api.NoSuchFilterException(noSuchFilterException.getMessage(), noSuchFilterException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void removeFilterFromChain(String string, String string2) throws NoSuchLogicalReaderException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified logical reader name is null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Specified filter name is null.");
        }
        RemoveFilterFromChain removeFilterFromChain = new RemoveFilterFromChain();
        removeFilterFromChain.setLogicalReaderName(string);
        removeFilterFromChain.setFilterName(string2);
        try {
            this.b.removeFilterFromChain(removeFilterFromChain);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchLogicalReaderException noSuchLogicalReaderException) {
            throw new NoSuchLogicalReaderException(noSuchLogicalReaderException.getMessage(), noSuchLogicalReaderException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public String getPhysicalReaderName(String string) throws NoSuchLogicalReaderException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified logical reader name is null.");
        }
        GetPhysicalReaderName getPhysicalReaderName = new GetPhysicalReaderName();
        getPhysicalReaderName.setLogicalReaderName(string);
        try {
            return this.b.getPhysicalReaderName(getPhysicalReaderName);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchLogicalReaderException noSuchLogicalReaderException) {
            throw new NoSuchLogicalReaderException(noSuchLogicalReaderException.getMessage(), noSuchLogicalReaderException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public List getCompositeReaderNamesUsingReader(String string) throws NoSuchClientReaderException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified client reader name is null.");
        }
        GetCompositeReaderNamesUsingReader getCompositeReaderNamesUsingReader = new GetCompositeReaderNamesUsingReader();
        getCompositeReaderNamesUsingReader.setClientReaderName(string);
        try {
            ArrayOfString arrayOfString = this.b.getCompositeReaderNamesUsingReader(getCompositeReaderNamesUsingReader);
            return AxisConfigClient.b(arrayOfString);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchClientReaderException noSuchClientReaderException) {
            throw new NoSuchClientReaderException(noSuchClientReaderException.getMessage(), noSuchClientReaderException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public List getAllFilterNames() throws RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        try {
            ArrayOfString arrayOfString = this.b.getAllFilterNames(new EmptyParms());
            return AxisConfigClient.b(arrayOfString);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void defineFilter(String string, com.connecterra.ale.config.api.EntitySpec entitySpec) throws DuplicateFilterNameException, com.connecterra.ale.config.api.EntitySpecValidationException, com.connecterra.ale.config.api.NoSuchDriverException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified filter name is null.");
        }
        if (entitySpec == null) {
            throw new IllegalArgumentException("Specified EntitySpec is null.");
        }
        DefineFilter defineFilter = new DefineFilter();
        defineFilter.setFilterName(string);
        defineFilter.setSpec(EntitySpecAdapter.aleToAxis(entitySpec));
        try {
            this.b.defineFilter(defineFilter);
        }
        catch (com.connecterra.ale.config.axis.service.DuplicateFilterNameException duplicateFilterNameException) {
            throw new DuplicateFilterNameException(duplicateFilterNameException.getMessage(), duplicateFilterNameException);
        }
        catch (EntitySpecValidationException entitySpecValidationException) {
            throw new com.connecterra.ale.config.api.EntitySpecValidationException(entitySpecValidationException.getMessage(), entitySpecValidationException);
        }
        catch (NoSuchDriverException noSuchDriverException) {
            throw new com.connecterra.ale.config.api.NoSuchDriverException(noSuchDriverException.getMessage(), noSuchDriverException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void undefineFilter(String string) throws com.connecterra.ale.config.api.NoSuchFilterException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified filter name is null.");
        }
        UndefineFilter undefineFilter = new UndefineFilter();
        undefineFilter.setFilterName(string);
        try {
            this.b.undefineFilter(undefineFilter);
        }
        catch (NoSuchFilterException noSuchFilterException) {
            throw new com.connecterra.ale.config.api.NoSuchFilterException(noSuchFilterException.getMessage(), noSuchFilterException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void undefineFilter(String string, com.connecterra.ale.config.api.ReferentialIntegrity referentialIntegrity) throws com.connecterra.ale.config.api.NoSuchFilterException, com.connecterra.ale.config.api.InUseException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified filter name is null.");
        }
        UndefineFilterWithControl undefineFilterWithControl = new UndefineFilterWithControl();
        undefineFilterWithControl.setFilterName(string);
        undefineFilterWithControl.setRiControl(AxisConfigClient.b(referentialIntegrity));
        try {
            this.b.undefineFilterWithControl(undefineFilterWithControl);
        }
        catch (NoSuchFilterException noSuchFilterException) {
            throw new com.connecterra.ale.config.api.NoSuchFilterException(noSuchFilterException.getMessage(), noSuchFilterException);
        }
        catch (InUseException inUseException) {
            throw new com.connecterra.ale.config.api.InUseException(inUseException.getMessage(), inUseException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void redefineFilter(String string, com.connecterra.ale.config.api.EntitySpec entitySpec) throws com.connecterra.ale.config.api.NoSuchFilterException, com.connecterra.ale.config.api.EntitySpecValidationException, com.connecterra.ale.config.api.NoSuchDriverException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified filter name is null.");
        }
        if (entitySpec == null) {
            throw new IllegalArgumentException("Specified EntitySpec is null.");
        }
        RedefineFilter redefineFilter = new RedefineFilter();
        redefineFilter.setFilterName(string);
        redefineFilter.setSpec(EntitySpecAdapter.aleToAxis(entitySpec));
        try {
            this.b.redefineFilter(redefineFilter);
        }
        catch (NoSuchFilterException noSuchFilterException) {
            throw new com.connecterra.ale.config.api.NoSuchFilterException(noSuchFilterException.getMessage(), noSuchFilterException);
        }
        catch (EntitySpecValidationException entitySpecValidationException) {
            throw new com.connecterra.ale.config.api.EntitySpecValidationException(entitySpecValidationException.getMessage(), entitySpecValidationException);
        }
        catch (NoSuchDriverException noSuchDriverException) {
            throw new com.connecterra.ale.config.api.NoSuchDriverException(noSuchDriverException.getMessage(), noSuchDriverException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public com.connecterra.ale.config.api.EntitySpec getFilterSpec(String string) throws RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified filter name is null.");
        }
        GetFilterSpec getFilterSpec = new GetFilterSpec();
        getFilterSpec.setFilterName(string);
        try {
            EntitySpec entitySpec = this.b.getFilterSpec(getFilterSpec);
            return EntitySpecAdapter.axisToALE(entitySpec);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public List getLogicalReaderNamesUsingFilter(String string) throws com.connecterra.ale.config.api.NoSuchFilterException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified filter name is null.");
        }
        GetLogicalReaderNamesUsingFilter getLogicalReaderNamesUsingFilter = new GetLogicalReaderNamesUsingFilter();
        getLogicalReaderNamesUsingFilter.setFilterName(string);
        try {
            ArrayOfString arrayOfString = this.b.getLogicalReaderNamesUsingFilter(getLogicalReaderNamesUsingFilter);
            return AxisConfigClient.b(arrayOfString);
        }
        catch (NoSuchFilterException noSuchFilterException) {
            throw new com.connecterra.ale.config.api.NoSuchFilterException(noSuchFilterException.getMessage(), noSuchFilterException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public List getFilterDriverNames() throws RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        try {
            ArrayOfString arrayOfString = this.b.getFilterDriverNames(new EmptyParms());
            return AxisConfigClient.b(arrayOfString);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public List getAllCompositeReaderNames() throws RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        try {
            ArrayOfString arrayOfString = this.b.getAllCompositeReaderNames(new EmptyParms());
            return AxisConfigClient.b(arrayOfString);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void defineCompositeReader(String string, List list, boolean bl) throws com.connecterra.ale.config.api.DuplicateCompositeReaderNameException, CyclicDefinitionException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified composite reader name is null.");
        }
        if (list == null) {
            throw new IllegalArgumentException("Specified client reader list is null.");
        }
        ArrayOfString arrayOfString = new ArrayOfString();
        arrayOfString.setString(list.toArray(new String[list.size()]));
        DefineCompositeReader defineCompositeReader = new DefineCompositeReader();
        defineCompositeReader.setCompositeReaderName(string);
        defineCompositeReader.setClientReaderNames(arrayOfString);
        defineCompositeReader.setReportFailedMembers(bl);
        try {
            this.b.defineCompositeReader(defineCompositeReader);
        }
        catch (DuplicateCompositeReaderNameException duplicateCompositeReaderNameException) {
            throw new com.connecterra.ale.config.api.DuplicateCompositeReaderNameException(duplicateCompositeReaderNameException.getMessage(), duplicateCompositeReaderNameException);
        }
        catch (com.connecterra.ale.config.axis.service.CyclicDefinitionException cyclicDefinitionException) {
            throw new CyclicDefinitionException(cyclicDefinitionException.getMessage(), cyclicDefinitionException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void defineCompositeReader(String string, List list, boolean bl, com.connecterra.ale.config.api.ReferentialIntegrity referentialIntegrity) throws com.connecterra.ale.config.api.DuplicateCompositeReaderNameException, NoSuchClientReaderException, CyclicDefinitionException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified composite reader name is null.");
        }
        if (list == null) {
            throw new IllegalArgumentException("Specified client reader list is null.");
        }
        ArrayOfString arrayOfString = new ArrayOfString();
        arrayOfString.setString(list.toArray(new String[list.size()]));
        DefineCompositeReaderWithControl defineCompositeReaderWithControl = new DefineCompositeReaderWithControl();
        defineCompositeReaderWithControl.setCompositeReaderName(string);
        defineCompositeReaderWithControl.setClientReaderNames(arrayOfString);
        defineCompositeReaderWithControl.setReportFailedMembers(bl);
        defineCompositeReaderWithControl.setRiControl(AxisConfigClient.b(referentialIntegrity));
        try {
            this.b.defineCompositeReaderWithControl(defineCompositeReaderWithControl);
        }
        catch (DuplicateCompositeReaderNameException duplicateCompositeReaderNameException) {
            throw new com.connecterra.ale.config.api.DuplicateCompositeReaderNameException(duplicateCompositeReaderNameException.getMessage(), duplicateCompositeReaderNameException);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchClientReaderException noSuchClientReaderException) {
            throw new NoSuchClientReaderException(noSuchClientReaderException.getMessage(), noSuchClientReaderException);
        }
        catch (com.connecterra.ale.config.axis.service.CyclicDefinitionException cyclicDefinitionException) {
            throw new CyclicDefinitionException(cyclicDefinitionException.getMessage(), cyclicDefinitionException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void undefineCompositeReader(String string) throws NoSuchCompositeReaderException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified composite reader name is null.");
        }
        UndefineCompositeReader undefineCompositeReader = new UndefineCompositeReader();
        undefineCompositeReader.setCompositeReaderName(string);
        try {
            this.b.undefineCompositeReader(undefineCompositeReader);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchCompositeReaderException noSuchCompositeReaderException) {
            throw new NoSuchCompositeReaderException(noSuchCompositeReaderException.getMessage(), noSuchCompositeReaderException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void undefineCompositeReader(String string, com.connecterra.ale.config.api.ReferentialIntegrity referentialIntegrity) throws NoSuchCompositeReaderException, com.connecterra.ale.config.api.InUseException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified composite reader name is null.");
        }
        UndefineCompositeReaderWithControl undefineCompositeReaderWithControl = new UndefineCompositeReaderWithControl();
        undefineCompositeReaderWithControl.setCompositeReaderName(string);
        undefineCompositeReaderWithControl.setRiControl(AxisConfigClient.b(referentialIntegrity));
        try {
            this.b.undefineCompositeReaderWithControl(undefineCompositeReaderWithControl);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchCompositeReaderException noSuchCompositeReaderException) {
            throw new NoSuchCompositeReaderException(noSuchCompositeReaderException.getMessage(), noSuchCompositeReaderException);
        }
        catch (InUseException inUseException) {
            throw new com.connecterra.ale.config.api.InUseException(inUseException.getMessage(), inUseException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void redefineCompositeReader(String string, List list, boolean bl) throws NoSuchCompositeReaderException, CyclicDefinitionException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified composite reader name is null.");
        }
        if (list == null) {
            throw new IllegalArgumentException("Specified client reader list is null.");
        }
        ArrayOfString arrayOfString = new ArrayOfString();
        arrayOfString.setString(list.toArray(new String[list.size()]));
        RedefineCompositeReader redefineCompositeReader = new RedefineCompositeReader();
        redefineCompositeReader.setCompositeReaderName(string);
        redefineCompositeReader.setClientReaderNames(arrayOfString);
        redefineCompositeReader.setReportFailedMembers(bl);
        try {
            this.b.redefineCompositeReader(redefineCompositeReader);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchCompositeReaderException noSuchCompositeReaderException) {
            throw new NoSuchCompositeReaderException(noSuchCompositeReaderException.getMessage(), noSuchCompositeReaderException);
        }
        catch (com.connecterra.ale.config.axis.service.CyclicDefinitionException cyclicDefinitionException) {
            throw new CyclicDefinitionException(cyclicDefinitionException.getMessage(), cyclicDefinitionException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void redefineCompositeReader(String string, List list, boolean bl, com.connecterra.ale.config.api.ReferentialIntegrity referentialIntegrity) throws NoSuchCompositeReaderException, NoSuchClientReaderException, CyclicDefinitionException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified composite reader name is null.");
        }
        if (list == null) {
            throw new IllegalArgumentException("Specified client reader list is null.");
        }
        ArrayOfString arrayOfString = new ArrayOfString();
        arrayOfString.setString(list.toArray(new String[list.size()]));
        RedefineCompositeReaderWithControl redefineCompositeReaderWithControl = new RedefineCompositeReaderWithControl();
        redefineCompositeReaderWithControl.setCompositeReaderName(string);
        redefineCompositeReaderWithControl.setClientReaderNames(arrayOfString);
        redefineCompositeReaderWithControl.setReportFailedMembers(bl);
        redefineCompositeReaderWithControl.setRiControl(AxisConfigClient.b(referentialIntegrity));
        try {
            this.b.redefineCompositeReaderWithControl(redefineCompositeReaderWithControl);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchCompositeReaderException noSuchCompositeReaderException) {
            throw new NoSuchCompositeReaderException(noSuchCompositeReaderException.getMessage(), noSuchCompositeReaderException);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchClientReaderException noSuchClientReaderException) {
            throw new NoSuchClientReaderException(noSuchClientReaderException.getMessage(), noSuchClientReaderException);
        }
        catch (com.connecterra.ale.config.axis.service.CyclicDefinitionException cyclicDefinitionException) {
            throw new CyclicDefinitionException(cyclicDefinitionException.getMessage(), cyclicDefinitionException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void addReaderToComposite(String string, String string2) throws NoSuchCompositeReaderException, NoSuchClientReaderException, CyclicDefinitionException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified composite reader name is null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Specified client reader name is null.");
        }
        AddReaderToComposite addReaderToComposite = new AddReaderToComposite();
        addReaderToComposite.setCompositeReaderName(string);
        addReaderToComposite.setClientReaderName(string2);
        try {
            this.b.addReaderToComposite(addReaderToComposite);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchCompositeReaderException noSuchCompositeReaderException) {
            throw new NoSuchCompositeReaderException(noSuchCompositeReaderException.getMessage(), noSuchCompositeReaderException);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchClientReaderException noSuchClientReaderException) {
            throw new NoSuchClientReaderException(noSuchClientReaderException.getMessage(), noSuchClientReaderException);
        }
        catch (com.connecterra.ale.config.axis.service.CyclicDefinitionException cyclicDefinitionException) {
            throw new CyclicDefinitionException(cyclicDefinitionException.getMessage(), cyclicDefinitionException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void addReadersToComposite(String string, List list) throws NoSuchCompositeReaderException, NoSuchClientReaderException, CyclicDefinitionException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified composite reader name is null.");
        }
        if (list == null) {
            throw new IllegalArgumentException("Specified client reader list is null.");
        }
        ArrayOfString arrayOfString = new ArrayOfString();
        arrayOfString.setString(list.toArray(new String[list.size()]));
        AddReadersToComposite addReadersToComposite = new AddReadersToComposite();
        addReadersToComposite.setCompositeReaderName(string);
        addReadersToComposite.setClientReaderNames(arrayOfString);
        try {
            this.b.addReadersToComposite(addReadersToComposite);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchCompositeReaderException noSuchCompositeReaderException) {
            throw new NoSuchCompositeReaderException(noSuchCompositeReaderException.getMessage(), noSuchCompositeReaderException);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchClientReaderException noSuchClientReaderException) {
            throw new NoSuchClientReaderException(noSuchClientReaderException.getMessage(), noSuchClientReaderException);
        }
        catch (com.connecterra.ale.config.axis.service.CyclicDefinitionException cyclicDefinitionException) {
            throw new CyclicDefinitionException(cyclicDefinitionException.getMessage(), cyclicDefinitionException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void removeReaderFromComposite(String string, String string2) throws NoSuchCompositeReaderException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified composite reader name is null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Specified client reader name is null.");
        }
        RemoveReaderFromComposite removeReaderFromComposite = new RemoveReaderFromComposite();
        removeReaderFromComposite.setCompositeReaderName(string);
        removeReaderFromComposite.setClientReaderName(string2);
        try {
            this.b.removeReaderFromComposite(removeReaderFromComposite);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchCompositeReaderException noSuchCompositeReaderException) {
            throw new NoSuchCompositeReaderException(noSuchCompositeReaderException.getMessage(), noSuchCompositeReaderException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public List getClientReaderNames(String string) throws NoSuchCompositeReaderException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified composite reader name is null.");
        }
        GetClientReaderNames getClientReaderNames = new GetClientReaderNames();
        getClientReaderNames.setCompositeReaderName(string);
        try {
            ArrayOfString arrayOfString = this.b.getClientReaderNames(getClientReaderNames);
            return AxisConfigClient.b(arrayOfString);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchCompositeReaderException noSuchCompositeReaderException) {
            throw new NoSuchCompositeReaderException(noSuchCompositeReaderException.getMessage(), noSuchCompositeReaderException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public boolean getReportFailedMembers(String string) throws NoSuchCompositeReaderException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified composite reader name is null.");
        }
        GetReportFailedMembers getReportFailedMembers = new GetReportFailedMembers();
        getReportFailedMembers.setCompositeReaderName(string);
        try {
            return this.b.getReportFailedMembers(getReportFailedMembers);
        }
        catch (com.connecterra.ale.config.axis.service.NoSuchCompositeReaderException noSuchCompositeReaderException) {
            throw new NoSuchCompositeReaderException(noSuchCompositeReaderException.getMessage(), noSuchCompositeReaderException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public List getAllTriggerNames() throws RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        try {
            ArrayOfString arrayOfString = this.b.getAllTriggerNames(new EmptyParms());
            return AxisConfigClient.b(arrayOfString);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void defineTrigger(String string, com.connecterra.ale.config.api.EntitySpec entitySpec) throws com.connecterra.ale.config.api.DuplicateTriggerNameException, com.connecterra.ale.config.api.EntitySpecValidationException, com.connecterra.ale.config.api.NoSuchDriverException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified trigger name is null.");
        }
        if (entitySpec == null) {
            throw new IllegalArgumentException("Specified EntitySpec is null.");
        }
        DefineTrigger defineTrigger = new DefineTrigger();
        defineTrigger.setTriggerName(string);
        defineTrigger.setSpec(EntitySpecAdapter.aleToAxis(entitySpec));
        try {
            this.b.defineTrigger(defineTrigger);
        }
        catch (DuplicateTriggerNameException duplicateTriggerNameException) {
            throw new com.connecterra.ale.config.api.DuplicateTriggerNameException(duplicateTriggerNameException.getMessage(), duplicateTriggerNameException);
        }
        catch (EntitySpecValidationException entitySpecValidationException) {
            throw new com.connecterra.ale.config.api.EntitySpecValidationException(entitySpecValidationException.getMessage(), entitySpecValidationException);
        }
        catch (NoSuchDriverException noSuchDriverException) {
            throw new com.connecterra.ale.config.api.NoSuchDriverException(noSuchDriverException.getMessage(), noSuchDriverException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void undefineTrigger(String string) throws com.connecterra.ale.config.api.NoSuchTriggerException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified trigger name is null.");
        }
        UndefineTrigger undefineTrigger = new UndefineTrigger();
        undefineTrigger.setTriggerName(string);
        try {
            this.b.undefineTrigger(undefineTrigger);
        }
        catch (NoSuchTriggerException noSuchTriggerException) {
            throw new com.connecterra.ale.config.api.NoSuchTriggerException(noSuchTriggerException.getMessage(), noSuchTriggerException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void undefineTrigger(String string, com.connecterra.ale.config.api.ReferentialIntegrity referentialIntegrity) throws com.connecterra.ale.config.api.NoSuchTriggerException, com.connecterra.ale.config.api.InUseException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified trigger name is null.");
        }
        UndefineTriggerWithControl undefineTriggerWithControl = new UndefineTriggerWithControl();
        undefineTriggerWithControl.setTriggerName(string);
        undefineTriggerWithControl.setRiControl(AxisConfigClient.b(referentialIntegrity));
        try {
            this.b.undefineTriggerWithControl(undefineTriggerWithControl);
        }
        catch (NoSuchTriggerException noSuchTriggerException) {
            throw new com.connecterra.ale.config.api.NoSuchTriggerException(noSuchTriggerException.getMessage(), noSuchTriggerException);
        }
        catch (InUseException inUseException) {
            throw new com.connecterra.ale.config.api.InUseException(inUseException.getMessage(), inUseException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public void redefineTrigger(String string, com.connecterra.ale.config.api.EntitySpec entitySpec) throws com.connecterra.ale.config.api.NoSuchTriggerException, com.connecterra.ale.config.api.EntitySpecValidationException, com.connecterra.ale.config.api.NoSuchDriverException, RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified trigger name is null.");
        }
        if (entitySpec == null) {
            throw new IllegalArgumentException("Specified EntitySpec is null.");
        }
        RedefineTrigger redefineTrigger = new RedefineTrigger();
        redefineTrigger.setTriggerName(string);
        redefineTrigger.setSpec(EntitySpecAdapter.aleToAxis(entitySpec));
        try {
            this.b.redefineTrigger(redefineTrigger);
        }
        catch (NoSuchTriggerException noSuchTriggerException) {
            throw new com.connecterra.ale.config.api.NoSuchTriggerException(noSuchTriggerException.getMessage(), noSuchTriggerException);
        }
        catch (EntitySpecValidationException entitySpecValidationException) {
            throw new com.connecterra.ale.config.api.EntitySpecValidationException(entitySpecValidationException.getMessage(), entitySpecValidationException);
        }
        catch (NoSuchDriverException noSuchDriverException) {
            throw new com.connecterra.ale.config.api.NoSuchDriverException(noSuchDriverException.getMessage(), noSuchDriverException);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public com.connecterra.ale.config.api.EntitySpec getTriggerSpec(String string) throws RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        if (string == null) {
            throw new IllegalArgumentException("Specified trigger name is null.");
        }
        GetTriggerSpec getTriggerSpec = new GetTriggerSpec();
        getTriggerSpec.setTriggerName(string);
        try {
            EntitySpec entitySpec = this.b.getTriggerSpec(getTriggerSpec);
            return EntitySpecAdapter.axisToALE(entitySpec);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    public List getTriggerDriverNames() throws RemoteException, com.connecterra.ale.config.api.ConfigEngineException {
        try {
            ArrayOfString arrayOfString = this.b.getTriggerDriverNames(new EmptyParms());
            return AxisConfigClient.b(arrayOfString);
        }
        catch (ConfigEngineException configEngineException) {
            throw new com.connecterra.ale.config.api.ConfigEngineException(configEngineException.getMessage(), configEngineException);
        }
    }

    private static List b(ArrayOfString arrayOfString) {
        if (arrayOfString == null) {
            return Collections.EMPTY_LIST;
        }
        String[] stringArray = arrayOfString.getString();
        if (stringArray == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(stringArray);
    }
}

