/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.axis.adapters.epcglobal.ale;

import com.connecterra.ale.api.ECInterval;
import com.connecterra.ale.api.ECIntervalUnit;
import com.connecterra.ale.api.ECReportSpec;
import com.connecterra.ale.api.XMLSerializationSyntax;
import com.connecterra.ale.axis.AxisEPCglobalALEFactory;
import com.connecterra.ale.axis.adapters.epcglobal.ale.ECReportSpecAdapter;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECBoundarySpec;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECLogicalReaders;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECReportSpecs;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECSpec;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECTime;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECTimeUnit;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECTrigger;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ECSpecAdapter
implements com.connecterra.ale.api.ECSpec {
    private ECSpec k;
    private URI g;
    private URI j;
    private List i = new ArrayList();
    private XMLSerializationSyntax h = XMLSerializationSyntax.EPCGLOBAL_ALE_1_0;

    public static ECSpec aleToAxis(com.connecterra.ale.api.ECSpec eCSpec) {
        if (eCSpec instanceof ECSpecAdapter) {
            return ((ECSpecAdapter)eCSpec).getAxisECSpec();
        }
        return new ECSpecAdapter(eCSpec).getAxisECSpec();
    }

    ECSpecAdapter(com.connecterra.ale.api.ECSpec eCSpec) {
        this.k = new ECSpec();
        this.setLogicalReaderNames(eCSpec.getLogicalReaderNames());
        this.setRepeatPeriodMillis(eCSpec.getRepeatPeriodMillis());
        this.setStableSetIntervalMillis(eCSpec.getStableSetIntervalMillis());
        this.setStableSetIntervalReadCycles(eCSpec.getStableSetIntervalReadCycles());
        this.setDurationMillis(eCSpec.getDurationMillis());
        this.setDurationReadCycles(eCSpec.getDurationReadCycles());
        this.setReportSpecs(eCSpec.getReportSpecs());
        this.setApplicationData(eCSpec.getApplicationData());
        this.setIncludeSpecInReports(eCSpec.getIncludeSpecInReports());
        this.setStableCount(eCSpec.getStableCount());
        this.g = eCSpec.getStartTrigger();
        this.j = eCSpec.getStopTrigger();
    }

    public ECSpecAdapter(ECSpec eCSpec) throws URISyntaxException {
        this.k = eCSpec;
        this.e();
    }

    public ECSpec getAxisECSpec() {
        this.f();
        return this.k;
    }

    private void e() throws URISyntaxException {
        ECReportSpecs eCReportSpecs;
        com.connecterra.ale.axis.schema.epcglobal.ale.ECReportSpec[] eCReportSpecArray;
        ECBoundarySpec eCBoundarySpec = this.k.getBoundarySpec();
        if (eCBoundarySpec != null) {
            if (eCBoundarySpec.getStartTrigger() != null) {
                this.g = new URI(eCBoundarySpec.getStartTrigger().get_value());
            }
            if (eCBoundarySpec.getStopTrigger() != null) {
                this.j = new URI(eCBoundarySpec.getStopTrigger().get_value());
            }
        }
        if ((eCReportSpecArray = (eCReportSpecs = this.k.getReportSpecs()) == null ? null : eCReportSpecs.getReportSpec()) == null) {
            this.i = new ArrayList();
        } else {
            this.i = new ArrayList(eCReportSpecArray.length);
            for (int i = 0; i < eCReportSpecArray.length; ++i) {
                this.i.add(new ECReportSpecAdapter(eCReportSpecArray[i]));
            }
        }
    }

    private void f() {
        ECBoundarySpec eCBoundarySpec;
        if (this.k == null) {
            this.k = new ECSpec();
        }
        if ((eCBoundarySpec = this.k.getBoundarySpec()) == null) {
            eCBoundarySpec = new ECBoundarySpec();
            this.k.setBoundarySpec(eCBoundarySpec);
        }
        if (this.g != null) {
            eCBoundarySpec.setStartTrigger(new ECTrigger(this.g.toString()));
        }
        if (this.j != null) {
            eCBoundarySpec.setStopTrigger(new ECTrigger(this.j.toString()));
        }
        if (this.i.size() == 0) {
            this.k.setReportSpecs(null);
        } else {
            com.connecterra.ale.axis.schema.epcglobal.ale.ECReportSpec[] eCReportSpecArray = new com.connecterra.ale.axis.schema.epcglobal.ale.ECReportSpec[this.i.size()];
            Iterator iterator = this.i.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                eCReportSpecArray[n] = ECReportSpecAdapter.aleToAxis((ECReportSpec)iterator.next());
                ++n;
            }
            ECReportSpecs eCReportSpecs = new ECReportSpecs();
            eCReportSpecs.setReportSpec(eCReportSpecArray);
            this.k.setReportSpecs(eCReportSpecs);
        }
    }

    private ECBoundarySpec d() {
        ECBoundarySpec eCBoundarySpec = this.k.getBoundarySpec();
        if (eCBoundarySpec == null) {
            eCBoundarySpec = new ECBoundarySpec();
            this.k.setBoundarySpec(eCBoundarySpec);
        }
        return eCBoundarySpec;
    }

    public List getLogicalReaderNames() {
        ECLogicalReaders eCLogicalReaders = this.k.getLogicalReaders();
        if (eCLogicalReaders == null || eCLogicalReaders.getLogicalReader() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(Arrays.asList(eCLogicalReaders.getLogicalReader()));
    }

    public void setLogicalReaderNames(List list) {
        ECLogicalReaders eCLogicalReaders = new ECLogicalReaders();
        eCLogicalReaders.setLogicalReader(list.toArray(new String[0]));
        this.k.setLogicalReaders(eCLogicalReaders);
    }

    public void addLogicalReaderName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("illegal null argument"));
        }
        List list = this.getLogicalReaderNames();
        if (list.contains(string)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + 1);
        arrayList.addAll(list);
        arrayList.add(string);
        this.setLogicalReaderNames(arrayList);
    }

    public void addLogicalReaderNames(List list) {
        if (list == null) {
            return;
        }
        List list2 = this.getLogicalReaderNames();
        ArrayList<String> arrayList = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (list2.contains(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>(list2.size() + list.size());
                arrayList.addAll(list2);
            }
            arrayList.add(string);
        }
        if (arrayList != null) {
            this.setLogicalReaderNames(arrayList);
        }
    }

    public URI getStartTrigger() {
        return this.g;
    }

    public void setStartTrigger(URI uRI) {
        this.g = uRI;
    }

    public ECInterval getRepeatPeriod() {
        return AxisEPCglobalALEFactory.getInstance().createECInterval((int)this.getRepeatPeriodMillis(), ECIntervalUnit.MS);
    }

    public void setRepeatPeriod(ECInterval eCInterval) {
        if (eCInterval.getUnit() == ECIntervalUnit.MS) {
            this.setRepeatPeriodMillis(eCInterval.getValue());
        }
    }

    public URI getStopTrigger() {
        return this.j;
    }

    public void setStopTrigger(URI uRI) {
        this.j = uRI;
    }

    public ECInterval getStableFieldInterval() {
        long l = this.getStableSetIntervalMillis();
        int n = this.getStableSetIntervalReadCycles();
        ECInterval eCInterval = l != 0L || n == 0 ? AxisEPCglobalALEFactory.getInstance().createECInterval((int)l, ECIntervalUnit.MS) : AxisEPCglobalALEFactory.getInstance().createECInterval(n, ECIntervalUnit.READ_CYCLE);
        return eCInterval;
    }

    public void setStableFieldInterval(ECInterval eCInterval) {
        if (eCInterval.getUnit() == ECIntervalUnit.MS) {
            this.setStableSetIntervalMillis(eCInterval.getValue());
        } else if (eCInterval.getUnit() == ECIntervalUnit.READ_CYCLE) {
            this.setStableSetIntervalReadCycles(eCInterval.getValue());
        } else {
            throw new IllegalArgumentException(I18N.get("Invlaid interval unit"));
        }
    }

    public ECInterval getDuration() {
        ECInterval eCInterval = AxisEPCglobalALEFactory.ZERO_INTERVAL;
        long l = this.getDurationMillis();
        int n = this.getDurationReadCycles();
        eCInterval = l != 0L || n == 0 ? AxisEPCglobalALEFactory.getInstance().createECInterval((int)l, ECIntervalUnit.MS) : AxisEPCglobalALEFactory.getInstance().createECInterval(n, ECIntervalUnit.READ_CYCLE);
        return eCInterval;
    }

    public void setDuration(ECInterval eCInterval) {
        if (eCInterval.getUnit() == ECIntervalUnit.MS) {
            this.setDurationMillis(eCInterval.getValue());
        } else if (eCInterval.getUnit() == ECIntervalUnit.READ_CYCLE) {
            this.setDurationReadCycles(eCInterval.getValue());
        }
    }

    public List getReportSpecs() {
        if (this.i == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.i);
    }

    public ECReportSpec getReportSpec(String string) {
        Iterator iterator = this.i.iterator();
        while (iterator.hasNext()) {
            ECReportSpec eCReportSpec = (ECReportSpec)iterator.next();
            String string2 = eCReportSpec.getName();
            if ((string2 == null || !string2.equals(string)) && (string2 != null || string != null)) continue;
            return eCReportSpec;
        }
        return null;
    }

    public void setReportSpecs(List list) {
        this.i.clear();
        this.addReportSpecs(list);
    }

    public void addReportSpec(ECReportSpec eCReportSpec) {
        if (eCReportSpec == null) {
            throw new IllegalArgumentException(I18N.get("illegal null argument"));
        }
        this.i.add(eCReportSpec);
    }

    public void addReportSpecs(List list) {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addReportSpec((ECReportSpec)iterator.next());
        }
    }

    public String getApplicationData() {
        return this.k.getApplicationData();
    }

    public void setApplicationData(String string) {
        this.k.setApplicationData(string);
    }

    public boolean getIncludeSpecInReports() {
        return this.k.isIncludeSpecInReports();
    }

    public void setIncludeSpecInReports(boolean bl) {
        this.k.setIncludeSpecInReports(bl);
    }

    public long getDurationMillis() {
        ECTime eCTime;
        long l = 0L;
        ECBoundarySpec eCBoundarySpec = this.k.getBoundarySpec();
        if (eCBoundarySpec != null && (eCTime = eCBoundarySpec.getDuration()) != null && eCTime.getUnit() == ECTimeUnit.MS) {
            l = eCTime.get_value();
        }
        return l;
    }

    public void setDurationMillis(long l) {
        ECTime eCTime = new ECTime(l);
        eCTime.setUnit(ECTimeUnit.MS);
        this.d().setDuration(eCTime);
    }

    public int getDurationReadCycles() {
        int n = 0;
        ECBoundarySpec eCBoundarySpec = this.k.getBoundarySpec();
        if (eCBoundarySpec != null && eCBoundarySpec.getDurationReadCycles() != null) {
            n = eCBoundarySpec.getDurationReadCycles();
        }
        return n;
    }

    public void setDurationReadCycles(int n) {
        this.d().setDurationReadCycles(new Integer(n));
    }

    public long getStableSetIntervalMillis() {
        ECTime eCTime;
        long l = 0L;
        ECBoundarySpec eCBoundarySpec = this.k.getBoundarySpec();
        if (eCBoundarySpec != null && (eCTime = eCBoundarySpec.getStableSetInterval()) != null && eCTime.getUnit() == ECTimeUnit.MS) {
            l = eCTime.get_value();
        }
        return l;
    }

    public void setStableSetIntervalMillis(long l) {
        ECTime eCTime = new ECTime(l);
        eCTime.setUnit(ECTimeUnit.MS);
        this.d().setStableSetInterval(eCTime);
    }

    public int getStableSetIntervalReadCycles() {
        int n = 0;
        ECBoundarySpec eCBoundarySpec = this.k.getBoundarySpec();
        if (eCBoundarySpec != null && eCBoundarySpec.getStableSetIntervalReadCycles() != null) {
            n = eCBoundarySpec.getStableSetIntervalReadCycles();
        }
        return n;
    }

    public void setStableSetIntervalReadCycles(int n) {
        this.d().setStableSetIntervalReadCycles(new Integer(n));
    }

    public long getRepeatPeriodMillis() {
        ECTime eCTime;
        ECBoundarySpec eCBoundarySpec = this.k.getBoundarySpec();
        long l = 0L;
        if (eCBoundarySpec != null && (eCTime = eCBoundarySpec.getRepeatPeriod()) != null && eCTime.getUnit() == ECTimeUnit.MS) {
            l = eCTime.get_value();
        }
        return l;
    }

    public void setRepeatPeriodMillis(long l) {
        ECTime eCTime = new ECTime(l);
        eCTime.setUnit(ECTimeUnit.MS);
        this.d().setRepeatPeriod(eCTime);
    }

    public XMLSerializationSyntax getXMLSerializationSyntax() {
        return this.h;
    }

    public int getStableCount() {
        ECBoundarySpec eCBoundarySpec = this.k.getBoundarySpec();
        if (eCBoundarySpec == null || eCBoundarySpec.getStableCount() == null) {
            return 0;
        }
        return eCBoundarySpec.getStableCount();
    }

    public void setStableCount(int n) {
        if (n != 0) {
            this.d().setStableCount(new Integer(n));
        } else {
            this.d().setStableCount(null);
        }
    }
}

