/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.axis.adapters.epcglobal.ale;

import com.connecterra.ale.api.ECCountReport;
import com.connecterra.ale.api.ECListReport;
import com.connecterra.ale.axis.adapters.epcglobal.ale.ECReportAdapter;
import com.connecterra.ale.axis.adapters.epcglobal.ale.ECSpecAdapter;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECReport;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECReportList;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECReports;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECSpec;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECTerminationCondition;
import com.connecterra.ale.axis.schema.epcglobalExtensions.ale.FailedLogicalReaders;
import com.connecterra.ale.axis.schema.epcglobalExtensions.ale.PhysicalReaders;
import com.connecterra.i18n.I18N;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ECReportsAdapter
implements com.connecterra.ale.api.ECReports {
    private ECReports i;
    private List f = null;
    private List e = null;
    private List h = null;
    private com.connecterra.ale.api.ECTerminationCondition g;

    public static ECReports aleToAxis(com.connecterra.ale.api.ECReports eCReports) {
        if (eCReports instanceof ECReportsAdapter) {
            return ((ECReportsAdapter)eCReports).getAxisECReports();
        }
        return new ECReportsAdapter(eCReports).getAxisECReports();
    }

    ECReportsAdapter(com.connecterra.ale.api.ECReports eCReports) {
        this.i = new ECReports();
        PhysicalReaders physicalReaders = new PhysicalReaders();
        physicalReaders.setPhysicalReader(eCReports.getPhysicalReaderNames().toArray(new String[0]));
        this.i.setPhysicalReaders(physicalReaders);
        FailedLogicalReaders failedLogicalReaders = new FailedLogicalReaders();
        failedLogicalReaders.setLogicalReader(eCReports.getFailedLogicalReaderNames().toArray(new String[0]));
        this.i.setFailedLogicalReaders(failedLogicalReaders);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(eCReports.getDate());
        this.i.setDate(calendar);
        this.i.setCreationDate(calendar);
        this.i.setSpecName(eCReports.getSpecName());
        this.i.setALEID(eCReports.getALEID());
        this.i.setTotalMilliseconds((int)eCReports.getTotalMilliseconds());
        this.i.setTotalReadCycles(new Integer(eCReports.getTotalReadCycles()));
        this.i.setApplicationData(eCReports.getApplicationData());
        this.i.setSchemaURL(eCReports.getSchemaURL());
        this.i.setSchemaVersion(new BigDecimal(1.0));
        if (eCReports.getECSpec() != null) {
            this.i.setECSpec(ECSpecAdapter.aleToAxis(eCReports.getECSpec()));
        }
        this.g = eCReports.getTerminationCondition();
        this.f = eCReports.getReports();
        this.d();
    }

    public ECReportsAdapter(ECReports eCReports) throws URISyntaxException {
        this.i = eCReports;
        this.e();
    }

    public ECReports getAxisECReports() {
        return this.i;
    }

    private void e() throws URISyntaxException {
        ECTerminationCondition eCTerminationCondition = this.i.getTerminationCondition();
        if (eCTerminationCondition == ECTerminationCondition.TRIGGER) {
            this.g = com.connecterra.ale.api.ECTerminationCondition.TRIGGER;
        } else if (eCTerminationCondition == ECTerminationCondition.DURATION) {
            this.g = com.connecterra.ale.api.ECTerminationCondition.DURATION;
        } else if (eCTerminationCondition == ECTerminationCondition.UNREQUEST) {
            this.g = com.connecterra.ale.api.ECTerminationCondition.UNREQUEST;
        } else if (eCTerminationCondition == ECTerminationCondition.STABLE_SET) {
            this.g = com.connecterra.ale.api.ECTerminationCondition.STABLE_SET;
        } else {
            throw new IllegalArgumentException(I18N.get("unknown termination condition \"{0}\"", eCTerminationCondition));
        }
        ECReportList eCReportList = this.i.getReports();
        ECReport[] eCReportArray = eCReportList == null ? null : eCReportList.getReport();
        if (eCReportArray == null) {
            this.f = Collections.EMPTY_LIST;
        } else {
            this.f = new ArrayList(eCReportArray.length);
            for (int i = 0; i < eCReportArray.length; ++i) {
                this.f.add(new ECReportAdapter(eCReportArray[i]));
            }
        }
    }

    private void d() {
        ECTerminationCondition eCTerminationCondition = null;
        if (this.g == com.connecterra.ale.api.ECTerminationCondition.TRIGGER) {
            eCTerminationCondition = ECTerminationCondition.TRIGGER;
        } else if (this.g == com.connecterra.ale.api.ECTerminationCondition.DURATION) {
            eCTerminationCondition = ECTerminationCondition.DURATION;
        } else if (this.g == com.connecterra.ale.api.ECTerminationCondition.UNREQUEST) {
            eCTerminationCondition = ECTerminationCondition.UNREQUEST;
        } else if (this.g == com.connecterra.ale.api.ECTerminationCondition.STABLE_SET) {
            eCTerminationCondition = ECTerminationCondition.STABLE_SET;
        }
        this.i.setTerminationCondition(eCTerminationCondition);
        ECReport[] eCReportArray = new ECReport[this.f.size()];
        Iterator iterator = this.f.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            eCReportArray[n] = ECReportAdapter.aleToAxis((com.connecterra.ale.api.ECReport)iterator.next());
            ++n;
        }
        ECReportList eCReportList = new ECReportList();
        eCReportList.setReport(eCReportArray);
        this.i.setReports(eCReportList);
    }

    public List getPhysicalReaderNames() {
        if (this.i.getPhysicalReaders() == null || this.i.getPhysicalReaders().getPhysicalReader() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(Arrays.asList(this.i.getPhysicalReaders().getPhysicalReader()));
    }

    public List getFailedLogicalReaderNames() {
        if (this.i.getFailedLogicalReaders() == null || this.i.getFailedLogicalReaders().getLogicalReader() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(Arrays.asList(this.i.getFailedLogicalReaders().getLogicalReader()));
    }

    public long getDate() {
        return this.i.getDate().getTimeInMillis();
    }

    public String getSpecName() {
        return this.i.getSpecName();
    }

    public com.connecterra.ale.api.ECTerminationCondition getTerminationCondition() {
        return this.g;
    }

    public long getTotalMilliseconds() {
        return this.i.getTotalMilliseconds();
    }

    public int getTotalReadCycles() {
        Integer n = this.i.getTotalReadCycles();
        if (n == null) {
            return 0;
        }
        return n;
    }

    public List getReports() {
        if (this.f == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.f);
    }

    public com.connecterra.ale.api.ECReport getReport(String string) {
        Iterator iterator = this.f.iterator();
        while (iterator.hasNext()) {
            com.connecterra.ale.api.ECReport eCReport = (com.connecterra.ale.api.ECReport)iterator.next();
            if (!eCReport.getName().equals(string)) continue;
            return eCReport;
        }
        return null;
    }

    public String getApplicationData() {
        return this.i.getApplicationData();
    }

    public String getALEID() {
        return this.i.getALEID();
    }

    public com.connecterra.ale.api.ECSpec getECSpec() {
        ECSpecAdapter eCSpecAdapter = null;
        ECSpec eCSpec = this.i.getECSpec();
        try {
            if (eCSpec != null) {
                eCSpecAdapter = new ECSpecAdapter(eCSpec);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return eCSpecAdapter;
    }

    public String getSchemaURL() {
        return this.i.getSchemaURL();
    }

    public String getSavantID() {
        return this.getALEID();
    }

    public List getListReports() {
        if (this.e == null) {
            this.e = new ListReportList();
        }
        return this.e;
    }

    public ECListReport getListReport(String string) {
        return (ECListReport)((ListReportList)this.getListReports()).getReport(string);
    }

    public List getCountReports() {
        if (this.h == null) {
            this.h = new CountReportList();
        }
        return this.h;
    }

    public ECCountReport getCountReport(String string) {
        return (ECCountReport)((CountReportList)this.getCountReports()).getReport(string);
    }

    protected abstract class ListOrCountReportList
    extends AbstractList {
        protected ListOrCountReportList() {
        }

        protected abstract boolean includeItem(com.connecterra.ale.api.ECReport var1);

        public com.connecterra.ale.api.ECReport getReport(String string) {
            com.connecterra.ale.api.ECReport eCReport = null;
            for (int i = 0; i < this.size(); ++i) {
                if (!((com.connecterra.ale.api.ECReport)this.get(i)).getName().equals(string)) continue;
                eCReport = (com.connecterra.ale.api.ECReport)this.get(i);
                break;
            }
            return eCReport;
        }

        public Object get(int n) {
            Object var2_2 = null;
            int n2 = 0;
            for (int i = 0; i < ECReportsAdapter.this.f.size(); ++i) {
                if (!this.includeItem((com.connecterra.ale.api.ECReport)ECReportsAdapter.this.f.get(i))) continue;
                if (n2 == n) {
                    var2_2 = ECReportsAdapter.this.f.get(i);
                    break;
                }
                ++n2;
            }
            return var2_2;
        }

        public int size() {
            int n = 0;
            for (int i = 0; i < ECReportsAdapter.this.f.size(); ++i) {
                if (!this.includeItem((com.connecterra.ale.api.ECReport)ECReportsAdapter.this.f.get(i))) continue;
                ++n;
            }
            return n;
        }
    }

    protected class CountReportList
    extends ListOrCountReportList {
        protected CountReportList() {
        }

        protected boolean includeItem(com.connecterra.ale.api.ECReport eCReport) {
            boolean bl = eCReport.hasCount();
            return bl;
        }
    }

    protected class ListReportList
    extends ListOrCountReportList {
        protected ListReportList() {
        }

        protected boolean includeItem(com.connecterra.ale.api.ECReport eCReport) {
            boolean bl = eCReport.hasList();
            return bl;
        }
    }
}

