/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.axis.adapters;

import com.connecterra.ale.api.ECInterval;
import com.connecterra.ale.api.ECIntervalUnit;
import com.connecterra.ale.api.ECReportSpec;
import com.connecterra.ale.api.ECSpec;
import com.connecterra.ale.api.XMLSerializationSyntax;
import com.connecterra.ale.axis.AxisALEFactory;
import com.connecterra.ale.axis.adapters.ECIntervalAdapter;
import com.connecterra.ale.axis.adapters.ECReportSpecAdapter;
import com.connecterra.ale.axis.schema.BoundarySpec;
import com.connecterra.ale.axis.schema.EventCycleSpec;
import com.connecterra.ale.axis.schema.LogicalReaders;
import com.connecterra.ale.axis.schema.ReportSpec;
import com.connecterra.ale.axis.schema.ReportSpecs;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ECSpecAdapter
implements ECSpec {
    private EventCycleSpec f;
    private URI b;
    private URI e;
    private List d = new ArrayList();
    private XMLSerializationSyntax c = XMLSerializationSyntax.RFTAGAWARE_1_1;

    public static EventCycleSpec aleToAxis(ECSpec eCSpec) {
        if (eCSpec instanceof ECSpecAdapter) {
            return ((ECSpecAdapter)eCSpec).getAxisEventCycleSpec();
        }
        return new ECSpecAdapter(eCSpec).getAxisEventCycleSpec();
    }

    ECSpecAdapter(ECSpec eCSpec) {
        this.f = new EventCycleSpec();
        this.setLogicalReaderNames(eCSpec.getLogicalReaderNames());
        this.setRepeatPeriod(eCSpec.getRepeatPeriod());
        this.setStableFieldInterval(eCSpec.getStableFieldInterval());
        this.setDuration(eCSpec.getDuration());
        this.setReportSpecs(eCSpec.getReportSpecs());
        this.setApplicationData(eCSpec.getApplicationData());
        this.b = eCSpec.getStartTrigger();
        this.e = eCSpec.getStopTrigger();
    }

    public ECSpecAdapter(EventCycleSpec eventCycleSpec) throws URISyntaxException {
        this.f = eventCycleSpec;
        this.b();
    }

    public EventCycleSpec getAxisEventCycleSpec() {
        this.c();
        return this.f;
    }

    private void b() throws URISyntaxException {
        ReportSpecs reportSpecs;
        ReportSpec[] reportSpecArray;
        BoundarySpec boundarySpec = this.f.getBoundarySpec();
        if (boundarySpec != null) {
            if (boundarySpec.getStartTrigger() != null) {
                this.b = new URI(boundarySpec.getStartTrigger());
            }
            if (boundarySpec.getStopTrigger() != null) {
                this.e = new URI(boundarySpec.getStopTrigger());
            }
        }
        if ((reportSpecArray = (reportSpecs = this.f.getReportSpecs()) == null ? null : reportSpecs.getReportSpec()) == null) {
            this.d = new ArrayList();
        } else {
            this.d = new ArrayList(reportSpecArray.length);
            for (int i = 0; i < reportSpecArray.length; ++i) {
                this.d.add(new ECReportSpecAdapter(reportSpecArray[i]));
            }
        }
    }

    private void c() {
        BoundarySpec boundarySpec = this.f.getBoundarySpec();
        if (boundarySpec == null && (this.b != null || this.e != null)) {
            boundarySpec = new BoundarySpec();
            this.f.setBoundarySpec(boundarySpec);
        }
        if (this.b != null) {
            boundarySpec.setStartTrigger(this.b.toString());
        }
        if (this.e != null) {
            boundarySpec.setStopTrigger(this.e.toString());
        }
        if (this.d.size() == 0) {
            this.f.setReportSpecs(null);
        } else {
            ReportSpec[] reportSpecArray = new ReportSpec[this.d.size()];
            Iterator iterator = this.d.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                reportSpecArray[n] = ECReportSpecAdapter.aleToAxis((ECReportSpec)iterator.next());
                ++n;
            }
            ReportSpecs reportSpecs = new ReportSpecs();
            reportSpecs.setReportSpec(reportSpecArray);
            this.f.setReportSpecs(reportSpecs);
        }
    }

    public List getLogicalReaderNames() {
        LogicalReaders logicalReaders = this.f.getLogicalReaders();
        if (logicalReaders == null || logicalReaders.getLogicalReader() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(Arrays.asList(logicalReaders.getLogicalReader()));
    }

    public void setLogicalReaderNames(List list) {
        LogicalReaders logicalReaders = new LogicalReaders();
        logicalReaders.setLogicalReader(list.toArray(new String[0]));
        this.f.setLogicalReaders(logicalReaders);
    }

    public void addLogicalReaderName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("illegal null argument"));
        }
        List list = this.getLogicalReaderNames();
        if (list.contains(string)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + 1);
        arrayList.addAll(list);
        arrayList.add(string);
        this.setLogicalReaderNames(arrayList);
    }

    public void addLogicalReaderNames(List list) {
        if (list == null) {
            return;
        }
        List list2 = this.getLogicalReaderNames();
        ArrayList<String> arrayList = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (list2.contains(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>(list2.size() + list.size());
                arrayList.addAll(list2);
            }
            arrayList.add(string);
        }
        if (arrayList != null) {
            this.setLogicalReaderNames(arrayList);
        }
    }

    public URI getStartTrigger() {
        return this.b;
    }

    public void setStartTrigger(URI uRI) {
        this.b = uRI;
    }

    public ECInterval getRepeatPeriod() {
        BoundarySpec boundarySpec = this.f.getBoundarySpec();
        if (boundarySpec == null || boundarySpec.getRepeatPeriod() == null) {
            return AxisALEFactory.ZERO_INTERVAL;
        }
        return new ECIntervalAdapter(boundarySpec.getRepeatPeriod());
    }

    public void setRepeatPeriod(ECInterval eCInterval) {
        BoundarySpec boundarySpec = this.f.getBoundarySpec();
        if (boundarySpec == null) {
            boundarySpec = new BoundarySpec();
            this.f.setBoundarySpec(boundarySpec);
        }
        boundarySpec.setRepeatPeriod(ECIntervalAdapter.aleToAxis(eCInterval));
    }

    public URI getStopTrigger() {
        return this.e;
    }

    public void setStopTrigger(URI uRI) {
        this.e = uRI;
    }

    public ECInterval getStableFieldInterval() {
        BoundarySpec boundarySpec = this.f.getBoundarySpec();
        if (boundarySpec == null || boundarySpec.getStableFieldInterval() == null) {
            return AxisALEFactory.ZERO_INTERVAL;
        }
        return new ECIntervalAdapter(boundarySpec.getStableFieldInterval());
    }

    public void setStableFieldInterval(ECInterval eCInterval) {
        BoundarySpec boundarySpec = this.f.getBoundarySpec();
        if (boundarySpec == null) {
            boundarySpec = new BoundarySpec();
            this.f.setBoundarySpec(boundarySpec);
        }
        boundarySpec.setStableFieldInterval(ECIntervalAdapter.aleToAxis(eCInterval));
    }

    public ECInterval getDuration() {
        BoundarySpec boundarySpec = this.f.getBoundarySpec();
        if (boundarySpec == null || boundarySpec.getDuration() == null) {
            return AxisALEFactory.ZERO_INTERVAL;
        }
        return new ECIntervalAdapter(boundarySpec.getDuration());
    }

    public void setDuration(ECInterval eCInterval) {
        BoundarySpec boundarySpec = this.f.getBoundarySpec();
        if (boundarySpec == null) {
            boundarySpec = new BoundarySpec();
            this.f.setBoundarySpec(boundarySpec);
        }
        boundarySpec.setDuration(ECIntervalAdapter.aleToAxis(eCInterval));
    }

    public List getReportSpecs() {
        if (this.d == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.d);
    }

    public ECReportSpec getReportSpec(String string) {
        Iterator iterator = this.d.iterator();
        while (iterator.hasNext()) {
            ECReportSpec eCReportSpec = (ECReportSpec)iterator.next();
            String string2 = eCReportSpec.getName();
            if ((string2 == null || !string2.equals(string)) && (string2 != null || string != null)) continue;
            return eCReportSpec;
        }
        return null;
    }

    public void setReportSpecs(List list) {
        this.d.clear();
        this.addReportSpecs(list);
    }

    public void addReportSpec(ECReportSpec eCReportSpec) {
        if (eCReportSpec == null) {
            throw new IllegalArgumentException(I18N.get("illegal null argument"));
        }
        this.d.add(eCReportSpec);
    }

    public void addReportSpecs(List list) {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addReportSpec((ECReportSpec)iterator.next());
        }
    }

    public String getApplicationData() {
        return this.f.getApplicationData();
    }

    public void setApplicationData(String string) {
        this.f.setApplicationData(string);
    }

    public boolean getIncludeSpecInReports() {
        return false;
    }

    public void setIncludeSpecInReports(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public long getDurationMillis() {
        long l = 0L;
        ECInterval eCInterval = this.getDuration();
        if (ECIntervalUnit.MS == eCInterval.getUnit()) {
            l = eCInterval.getValue();
        }
        return l;
    }

    public void setDurationMillis(long l) {
        this.setDuration(AxisALEFactory.getInstance().createECInterval((int)l, ECIntervalUnit.MS));
    }

    public int getDurationReadCycles() {
        int n = 0;
        ECInterval eCInterval = this.getDuration();
        if (ECIntervalUnit.READ_CYCLE == eCInterval.getUnit()) {
            n = eCInterval.getValue();
        }
        return n;
    }

    public void setDurationReadCycles(int n) {
        this.setDuration(AxisALEFactory.getInstance().createECInterval(n, ECIntervalUnit.READ_CYCLE));
    }

    public long getStableSetIntervalMillis() {
        long l = 0L;
        ECInterval eCInterval = this.getStableFieldInterval();
        if (ECIntervalUnit.MS == eCInterval.getUnit()) {
            l = eCInterval.getValue();
        }
        return l;
    }

    public void setStableSetIntervalMillis(long l) {
        this.setStableFieldInterval(AxisALEFactory.getInstance().createECInterval((int)l, ECIntervalUnit.MS));
    }

    public int getStableSetIntervalReadCycles() {
        int n = 0;
        ECInterval eCInterval = this.getStableFieldInterval();
        if (ECIntervalUnit.READ_CYCLE == eCInterval.getUnit()) {
            n = eCInterval.getValue();
        }
        return n;
    }

    public void setStableSetIntervalReadCycles(int n) {
        this.setStableFieldInterval(AxisALEFactory.getInstance().createECInterval(n, ECIntervalUnit.READ_CYCLE));
    }

    public long getRepeatPeriodMillis() {
        long l = 0L;
        ECInterval eCInterval = this.getRepeatPeriod();
        if (ECIntervalUnit.MS == eCInterval.getUnit()) {
            l = eCInterval.getValue();
        }
        return l;
    }

    public void setRepeatPeriodMillis(long l) {
        this.setRepeatPeriod(AxisALEFactory.getInstance().createECInterval((int)l, ECIntervalUnit.MS));
    }

    public XMLSerializationSyntax getXMLSerializationSyntax() {
        return this.c;
    }

    public int getStableCount() {
        throw new UnsupportedOperationException();
    }

    public void setStableCount(int n) {
        throw new UnsupportedOperationException();
    }
}

