/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.axis;

import com.connecterra.ale.api.ALEFactory;
import com.connecterra.ale.api.ECCountReportOutputSpec;
import com.connecterra.ale.api.ECInterval;
import com.connecterra.ale.api.ECIntervalUnit;
import com.connecterra.ale.api.ECListReportOutputSpec;
import com.connecterra.ale.api.ECReportSpec;
import com.connecterra.ale.api.ECSpec;
import com.connecterra.ale.api.ECSubscriptionControls;
import com.connecterra.ale.axis.adapters.ECIntervalAdapter;
import com.connecterra.ale.axis.adapters.ECReportSpecAdapter;
import com.connecterra.ale.axis.adapters.ECSpecAdapter;
import com.connecterra.ale.axis.adapters.ECSubscriptionControlsAdapter;
import com.connecterra.ale.axis.schema.EventCycleSpec;
import com.connecterra.ale.axis.schema.ReportSpec;
import java.net.URISyntaxException;

public class AxisALEFactory
implements ALEFactory {
    private static ALEFactory c = new AxisALEFactory();
    public static final ECInterval ZERO_INTERVAL = new ECIntervalAdapter(0, ECIntervalUnit.MS);
    private static final ECListReportOutputSpec b = new ListSingleton();
    private static final ECCountReportOutputSpec d = new CountSingleton();
    public static final ECSubscriptionControls ZERO_CONTROLS = new ECSubscriptionControlsAdapter(0, 0L);

    private AxisALEFactory() {
    }

    public static ALEFactory getInstance() {
        return c;
    }

    public ECInterval createECInterval() {
        return ZERO_INTERVAL;
    }

    public ECInterval createECInterval(int n, ECIntervalUnit eCIntervalUnit) {
        return new ECIntervalAdapter(n, eCIntervalUnit);
    }

    public ECReportSpec createECReportSpec() {
        try {
            return new ECReportSpecAdapter(new ReportSpec());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    public ECListReportOutputSpec createECListReportOutputSpec() {
        return b;
    }

    public ECCountReportOutputSpec createECCountReportOutputSpec() {
        return d;
    }

    public ECSpec createECSpec() {
        try {
            return new ECSpecAdapter(new EventCycleSpec());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    public ECSubscriptionControls createECSubscriptionControls() {
        return ZERO_CONTROLS;
    }

    public ECSubscriptionControls createECSubscriptionControls(int n, long l) {
        return new ECSubscriptionControlsAdapter(n, l);
    }

    private static class CountSingleton
    implements ECCountReportOutputSpec {
        private CountSingleton() {
        }
    }

    private static class ListSingleton
    implements ECListReportOutputSpec {
        private ListSingleton() {
        }
    }
}

