/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.persistence;

import com.connecterra.ale.persistence.PersistenceCategory;
import com.connecterra.ale.persistence.PersistenceException;
import com.connecterra.ale.persistence.PersistenceInitializationException;
import com.connecterra.i18n.I18N;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.Controllable;
import com.connecterra.util.RawConfig;
import com.connecterra.util.ValidatedConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersistenceManager
implements Controllable {
    private Config c;
    private long d;
    private Logger b;
    private List g = new ArrayList();
    private Thread f;
    private ShutdownFlag e = new ShutdownFlag();

    public PersistenceManager(RawConfig rawConfig) throws ConfigValidationException, PersistenceInitializationException {
        this.b = Logger.getLogger("com.connecterra.ale.alevent.PersistenceManager");
        ValidatedConfig validatedConfig = new ValidatedConfig();
        validatedConfig.addBooleanItem("disabled", "false");
        validatedConfig.readFrom(rawConfig);
        if (validatedConfig.getBooleanValue("disabled")) {
            this.c = new Config();
            this.b.info(I18N.get("Persistence is disabled!"));
            return;
        }
        validatedConfig.reset();
        validatedConfig.addFileItem("directory", true);
        validatedConfig.addBooleanItem("persistOnActivate", "false");
        validatedConfig.addBooleanItem("allowBadData", "false");
        validatedConfig.addLongItem("interval", 0L, "0");
        validatedConfig.readFrom(rawConfig);
        this.c = new Config(validatedConfig.getFileValue("directory"), validatedConfig.getBooleanValue("persistOnActivate"), validatedConfig.getBooleanValue("allowBadData"));
        this.d = validatedConfig.getLongValue("interval");
        this.b.fine("Persistence is enabled, with\n  bad data " + (this.c.allowBadData() ? "allowed" : "disallowed") + "\n" + "  directory = " + this.c.getDirectory() + "\n" + "  interval = " + this.d + "sec\n" + "  persistence on activation is " + (this.c.persistOnActivate() ? "enabled" : "disabled"));
    }

    public void shutdown() {
        this.e.set();
    }

    public void waitForShutdown(long l) throws InterruptedException {
        if (this.f != null) {
            this.f.join(l);
        }
    }

    public void terminate() {
        if (this.f != null) {
            this.f.interrupt();
        }
    }

    public void waitForTermination(long l) throws InterruptedException {
        if (this.f != null) {
            this.f.join(l);
        }
    }

    public void addPersistenceCategory(PersistenceCategory persistenceCategory) {
        this.g.add(persistenceCategory);
        persistenceCategory.b(this.c, this.b);
    }

    public void restoreAndStart() throws PersistenceInitializationException {
        if (this.c.isDisabled()) {
            return;
        }
        this.b();
        if (this.d > 0L) {
            this.f = new PeriodicPersisterThread();
            this.f.setDaemon(true);
            this.f.start();
        }
    }

    public void wipePersistenceData() throws PersistenceInitializationException {
        if (this.c.isDisabled()) {
            throw new PersistenceInitializationException(I18N.get("Cannot wipe persistence data if persistence is disabled"));
        }
        this.d();
        this.c();
    }

    private void b() throws PersistenceInitializationException {
        this.d();
        File[] fileArray = this.c.getDirectory().listFiles();
        this.c(fileArray);
        Collection collection = this.b(fileArray);
        this.b(collection);
    }

    private void d() throws PersistenceInitializationException {
        if (!this.c.getDirectory().exists()) {
            throw new PersistenceInitializationException(I18N.get("persistence directory {0} does not exist", this.c.getDirectory()));
        }
        if (!this.c.getDirectory().isDirectory()) {
            throw new PersistenceInitializationException(I18N.get("persistence directory {0} is not a directory", this.c.getDirectory()));
        }
        if (!this.c.getDirectory().canRead()) {
            throw new PersistenceInitializationException(I18N.get("persistence directory {0} is not readable", this.c.getDirectory()));
        }
        if (!this.c.getDirectory().canWrite()) {
            throw new PersistenceInitializationException(I18N.get("persistence directory {0} is not writable", this.c.getDirectory()));
        }
        if (this.c.getDirectory().listFiles() == null) {
            throw new PersistenceInitializationException(I18N.get("the contents of persistence directory {0} cannot be listed", this.c.getDirectory()));
        }
    }

    private void c(File[] fileArray) throws PersistenceInitializationException {
        boolean bl = false;
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].canRead()) {
                bl = true;
            } else if (!this.c.allowBadData()) {
                throw new PersistenceInitializationException(I18N.get("persistence directory contains unreadable file {0}", fileArray[i]));
            }
            if (fileArray[i].canWrite()) continue;
            throw new PersistenceInitializationException(I18N.get("persistence directory contains unwritable file {0}", fileArray[i]));
        }
        if (fileArray.length > 0 && !bl) {
            throw new PersistenceInitializationException(I18N.get("persistence directory {0} contains only unreadable files", this.c.getDirectory()));
        }
    }

    private Collection b(File[] fileArray) throws PersistenceInitializationException {
        HashSet<File> hashSet = new HashSet<File>(Arrays.asList(fileArray));
        for (PersistenceCategory persistenceCategory : this.g) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string;
                if (!hashSet.contains(fileArray[i]) || (string = persistenceCategory.getIdFromFile(fileArray[i])) == null) continue;
                try {
                    persistenceCategory.restoreObject(string);
                    hashSet.removeAll(persistenceCategory.b(string));
                    continue;
                }
                catch (PersistenceException persistenceException) {
                    this.b.log(Level.WARNING, I18N.get("error loading persistence based on {0}", fileArray[i]), persistenceException);
                    if (this.c.allowBadData()) continue;
                    throw new PersistenceInitializationException(persistenceException.getMessage(), persistenceException);
                }
            }
        }
        return hashSet;
    }

    private void b(Collection collection) {
        File file = new File(this.c.getDirectory(), "bad");
        boolean bl = false;
        File[] fileArray = collection.iterator();
        while (fileArray.hasNext()) {
            File file2 = (File)fileArray.next();
            if (file2.getName().equals("bad")) continue;
            if (!bl && !file.exists()) {
                file.mkdir();
            }
            bl = true;
            if (!file2.exists()) continue;
            if (file2.renameTo(new File(file, file2.getName()))) {
                this.b.warning(I18N.get("{0} is unknown or part of an incomplete event cycle; moved aside", file2));
                continue;
            }
            this.b.warning(I18N.get("{0} is unknown or part of an incomplete event cycle, but could not be moved", file2));
        }
        if (!bl && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
            file.delete();
        }
    }

    private void c() throws PersistenceInitializationException {
        File file;
        File[] fileArray;
        boolean bl = true;
        File[] fileArray2 = this.c.getDirectory().listFiles();
        if (fileArray2 != null) {
            for (int i = 0; i < fileArray2.length; ++i) {
                if (!fileArray2[i].isFile() || fileArray2[i].delete()) continue;
                bl = false;
            }
        }
        if ((fileArray = (file = new File(this.c.getDirectory(), "bad")).listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].delete()) continue;
                bl = false;
            }
            if (!file.delete()) {
                bl = false;
            }
        }
        if (!bl) {
            throw new PersistenceInitializationException(I18N.get("One or more files in {0} could not be removed.", this.c.getDirectory()));
        }
    }

    private class PeriodicPersisterThread
    extends Thread {
        public PeriodicPersisterThread() {
            super(Thread.currentThread().getThreadGroup(), "PeriodicPersisterThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = System.currentTimeMillis() + PersistenceManager.this.d;
            while (!PersistenceManager.this.e.test()) {
                ShutdownFlag shutdownFlag = PersistenceManager.this.e;
                synchronized (shutdownFlag) {
                    long l2 = l - System.currentTimeMillis();
                    while (l2 > 0L && !PersistenceManager.this.e.test()) {
                        try {
                            PersistenceManager.this.e.wait(l2);
                            l2 = l - System.currentTimeMillis();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                }
                l = System.currentTimeMillis() + PersistenceManager.this.d;
                for (PersistenceCategory persistenceCategory : PersistenceManager.this.g) {
                    persistenceCategory.flushDirtyInfo();
                }
            }
        }
    }

    private static class ShutdownFlag {
        private boolean b = false;

        private ShutdownFlag() {
        }

        public synchronized void set() {
            this.b = true;
            this.notify();
        }

        public synchronized boolean test() {
            return this.b;
        }
    }

    public static class Config {
        private boolean e;
        private File b;
        private boolean c;
        private boolean d;

        public Config() {
            this.e = true;
            this.b = new File("");
            this.c = false;
            this.d = false;
        }

        public Config(File file, boolean bl, boolean bl2) {
            this.e = false;
            this.b = file;
            this.c = bl;
            this.d = bl2;
        }

        public boolean isDisabled() {
            return this.e;
        }

        public File getDirectory() {
            return this.b;
        }

        public boolean persistOnActivate() {
            return this.c;
        }

        public boolean allowBadData() {
            return this.d;
        }
    }
}

